/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ManagedThreadFactory.tx;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.spec.ManagedThreadFactory.tx.CancelledTransactedTask;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class Util {
    private static final String MANAGED_THREAD_FACTORY_SVC_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";
    private Connection conn;

    private Util() {
    }

    public static <T> T waitForTaskComplete(Future<T> future, int maxTaskWaitTime) throws InterruptedException, ExecutionException, TimeoutException {
        T result = null;
        result = future.get(maxTaskWaitTime, TimeUnit.SECONDS);
        return result;
    }

    public static ManagedThreadFactory getManagedThreadFactory() {
        return (ManagedThreadFactory)Util.lookup(MANAGED_THREAD_FACTORY_SVC_JNDI_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lookup(String jndiName) {
        InitialContext ctx = null;
        Object targetObject = null;
        try {
            ctx = new InitialContext();
            targetObject = ctx.lookup(jndiName);
        }
        catch (Exception e) {
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                TestUtil.logErr((String)"failed to lookup resource.", (Throwable)e);
            }
        }
        return (T)targetObject;
    }

    public static Connection getConnection(DataSource ds, String user, String pwd, boolean autoCommit) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (conn == null) {
                conn = ds.getConnection(user, pwd);
            }
            if (null != conn) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            TestUtil.logErr((String)"failed to get connection.", (Throwable)e);
        }
        return conn;
    }

    public static String getUrl(String servletUri, String host, int port) {
        return "http://" + host + ":" + port + "/concurrency_spec_ManagedThreadFactory_tx_web" + servletUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String tableName, String username, String password) {
        Connection conn = Util.getConnection(true, username, password);
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(Connection conn, String tableName, String username, String password) {
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static Connection getConnection(boolean autoCommit, String username, String password) {
        DataSource ds = (DataSource)Util.lookup("jdbc/DB1");
        Connection conn = Util.getConnection(ds, username, password, autoCommit);
        return conn;
    }

    public static Connection getConnection(String dbURL, String propsString, boolean autoCommit) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(dbURL, Util.strToProps(propsString));
            if (conn != null) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException sqle) {
            TestUtil.logErr((String)"failed to get connection.", (Throwable)sqle);
        }
        return conn;
    }

    public static Properties strToProps(String strProps) {
        String[] strArray;
        Properties props = new Properties();
        TestUtil.logTrace((String)("Props String = " + strProps));
        for (String keyValuePair : strArray = strProps.split(":")) {
            String[] strArray2 = keyValuePair.split("=");
            TestUtil.logTrace((String)("Setting property " + strArray2[0] + " = " + strArray2[1]));
            props.setProperty(strArray2[0], strArray2[1]);
        }
        return props;
    }

    private static void printProperties(Properties props) {
        Set<String> propertyNames = props.stringPropertyNames();
        for (String key : propertyNames) {
            TestUtil.logTrace((String)(key + " = " + props.getProperty(key)));
        }
    }

    public static void waitForTransactionBegan(CancelledTransactedTask pp, long maxListenerWaitTime, int poolInterval) {
        long stopTime = System.currentTimeMillis() + maxListenerWaitTime;
        while (!pp.transactionBegin() && System.currentTimeMillis() < stopTime) {
            TestUtil.sleep((int)poolInterval);
        }
    }

    public static void waitTillThreadFinish(Thread thread) {
        long start = System.currentTimeMillis();
        while (thread.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 30000L) continue;
            throw new RuntimeException("wait task timeout");
        }
    }
}

