/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.ConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryRecord;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="inventoryReader")
public class InventoryReader
extends AbstractItemReader {
    private static final String CLASSNAME = InventoryReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected DataSource dataSource = null;
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    int readerIndex = 0;
    InventoryCheckpointData inventoryCheckpoint = new InventoryCheckpointData();

    public void open(Serializable cpd) throws NamingException {
        InventoryCheckpointData checkpointData = (InventoryCheckpointData)cpd;
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("java:module/env/jdbc/orderDB");
        if (cpd != null) {
            this.readerIndex = checkpointData.getInventoryCount();
            this.stepCtx.setTransientUserData((Object)this.readerIndex);
        }
    }

    public InventoryRecord readItem() throws Exception {
        InventoryRecord inventoryRecord;
        int quantity;
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block6: {
            connection = null;
            statement = null;
            rs = null;
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            if (quantity >= 1) break block6;
            InventoryRecord inventoryRecord2 = null;
            ConnectionHelper.cleanupConnection(connection, rs, statement);
            return inventoryRecord2;
        }
        try {
            InventoryRecord ir = new InventoryRecord(1, --quantity);
            this.decrementInventory(connection, ir);
            ++this.readerIndex;
            this.inventoryCheckpoint.setInventoryCount(this.readerIndex);
            inventoryRecord = new InventoryRecord(1, 1);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return inventoryRecord;
    }

    public Serializable checkpointInfo() throws Exception {
        logger.finer("InventoryReader.getInventoryCheckpoint() index = " + this.inventoryCheckpoint.getInventoryCount());
        return this.inventoryCheckpoint;
    }

    private void decrementInventory(Connection connection, InventoryRecord record) throws SQLException {
        int itemID = record.getItemID();
        int quantity = record.getQuantity();
        PreparedStatement statement = null;
        statement = connection.prepareStatement("update inventory set quantity = ? where itemID = ?");
        statement.setInt(2, itemID);
        statement.setInt(1, quantity);
        int rs = statement.executeUpdate();
    }
}

