/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.ejbcontext.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.lite.ejbcontext.common.EJBContextIF;
import com.sun.ts.tests.ejb30.lite.ejbcontext.common.Util;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBContext;
import jakarta.ejb.SessionContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;

public abstract class EJBContextBeanBase
implements EJBContextIF {
    private EJBContext ejbContextFromDescriptorInjection;
    @Resource(description="correspond to <resource-env-ref> in ejb-jar.xml")
    private EJBContext ejbContext;
    private SessionContext sessionContext;
    protected List<String> injectionRecords = new ArrayList<String>();
    private List<EJBContext> lookupValuesInPostConstruct = new ArrayList<EJBContext>();
    private List<EJBContext> lookupValuesInAroundInvoke = new ArrayList<EJBContext>();

    @Resource(description="correspond to <resource-env-ref> in ejb-jar.xml")
    private void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    private void postConstruct() {
        Helper.getLogger().fine("About to verify EJBContext: ejbContext=" + this.ejbContext + ", sessionContext=" + this.sessionContext + ", ejbContextFromDescriptorInjection=" + this.ejbContextFromDescriptorInjection);
        Util.postConstruct0(this.injectionRecords, this.lookupValuesInPostConstruct, new EJBContext[]{this.ejbContext, this.sessionContext, this.ejbContextFromDescriptorInjection});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    private Object aroundInvoke(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        Helper.assertEquals("lookupValuesInAroundInvoke must be empty ", 0, this.lookupValuesInAroundInvoke.size());
        if (methodName.equals("lookupEJBContext")) {
            for (String nm : Util.lookupNames) {
                EJBContext ec = (EJBContext)ServiceLocator.lookupNoTry(nm, new Context[0]);
                this.lookupValuesInAroundInvoke.add(ec);
            }
        }
        try {
            Object object = inv.proceed();
            return object;
        }
        finally {
            this.lookupValuesInAroundInvoke.clear();
        }
    }

    @PreDestroy
    private void preDestroy() {
        Helper.preDestroy(this);
    }

    @Override
    public List<String> getInjectionRecords() {
        return this.injectionRecords;
    }

    @Override
    public List<String> getInjectionRecordsInInterceptor() {
        return null;
    }

    @Override
    public Integer add(int a, int b) {
        return a + b;
    }

    @Override
    public String lookupIllegalArgumentException() throws TestFailedException {
        String[] badLookupNames = new String[]{null, "NoSuchName...", "java:comp/env/*"};
        Object obj = null;
        String result = "";
        for (String lookupName : badLookupNames) {
            try {
                obj = this.ejbContext.lookup(lookupName);
                result = result + " Expecting IllegalArgumentException when looking up non-existent resource: " + lookupName + ", but the lookup result is: " + obj;
                throw new TestFailedException(result);
            }
            catch (IllegalArgumentException e) {
                result = result + " Got expected IllegalArgumentException when looking up non-existent resource: " + lookupName;
            }
        }
        return result;
    }

    @Override
    public String getMessageContextIllegalStateException() throws TestFailedException {
        return "Got expected IllegalStateException: jakarta.ejb.SessionContext#getMessageContext() does not exist in the API anymore";
    }

    @Override
    public Class<?> getInvokedBusinessInterface() {
        return ((SessionContext)this.ejbContext).getInvokedBusinessInterface();
    }

    @Override
    public String getBusinessObjectIllegalStateException() throws TestFailedException {
        Class[] badBusinessInterfaces;
        String result = "";
        for (Class i : badBusinessInterfaces = new Class[]{null, Class.class, Serializable.class, EJB.class}) {
            try {
                Object ob = ((SessionContext)this.ejbContext).getBusinessObject(i);
                throw new TestFailedException("Expecting IllegalStateException with " + i + ", but got " + ob);
            }
            catch (IllegalStateException illegalStateException) {
                result = result + String.format(" Got expected IllegalStateException with %s :%s%n", i, illegalStateException);
            }
        }
        return result;
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        return (T)((SessionContext)this.ejbContext).getBusinessObject(businessInterface);
    }

    @Override
    public String lookupEJBContext() {
        StringBuilder sb = new StringBuilder();
        Helper.assertEquals("", Util.lookupNames.length, this.lookupValuesInPostConstruct.size(), sb);
        for (EJBContext ec : this.lookupValuesInPostConstruct) {
            Helper.assertNotEquals("", null, ec, sb);
        }
        Helper.assertEquals("", Util.lookupNames.length, this.lookupValuesInAroundInvoke.size(), sb);
        for (EJBContext ec : this.lookupValuesInAroundInvoke) {
            Helper.assertNotEquals("", null, ec, sb);
        }
        for (String s : Util.lookupNames) {
            EJBContext ec = (EJBContext)ServiceLocator.lookupNoTry(s, new Context[0]);
            Helper.assertNotEquals("", null, ec, sb);
        }
        return sb.toString();
    }

    @Override
    public String lookupEJBContextInInterceptor() {
        return null;
    }

    @Override
    public String lookupPortableJNDINames() {
        StringBuilder sb = new StringBuilder();
        Context c = (Context)this.ejbContext.lookup("java:comp/env");
        Helper.assertNotEquals(null, null, c, sb);
        String s = (String)this.ejbContext.lookup("java:app/env/myString");
        Helper.assertEquals(null, "app", s, sb);
        s = (String)this.ejbContext.lookup("java:comp/env/myString");
        Helper.assertEquals(null, "comp", s, sb);
        s = (String)this.ejbContext.lookup("myString");
        Helper.assertEquals(null, "comp", s, sb);
        s = (String)this.ejbContext.lookup("java:global/env/ejb30/lite/ejbcontext/myString");
        Helper.assertEquals(null, "global", s, sb);
        s = (String)this.ejbContext.lookup("java:module/env/myString2");
        Helper.assertEquals(null, "module", s, sb);
        return sb.toString();
    }
}

