/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topictests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;

public class TopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.topictests.TopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    public static final int TOPIC = 1;
    ArrayList connections = null;

    public static void main(String[] args) {
        TopicTests theTests = new TopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void cleanupSubscription(TopicSubscriber sub, TopicSession session, String subName) {
        if (sub != null) {
            try {
                TestUtil.logTrace((String)("Closing durable subscriber: " + sub));
                sub.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.connections = new ArrayList(10);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Cleanup: Closing Topic Connections");
            this.tool.closeAllConnections(this.connections);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"An error occurred while cleaning", (Throwable)e);
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void simpleSendReceiveTopicTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveTopicTest");
            TestUtil.logMsg((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logMsg((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("simpleSendReceiveTopicTest");
        }
    }

    public void inactiveNonDurableSubscriberTopicRecTest() throws EETest.Fault {
        TopicSubscriber tSub = null;
        TopicSession tSession = null;
        TopicConnection newTConn = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            TestUtil.logTrace((String)"Set up JmsTool for Topic");
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, lookup, this.mode);
            TestUtil.logTrace((String)"Getting default subscriber");
            tSub = this.tool.getDefaultTopicSubscriber();
            TestUtil.logTrace((String)"Start Connection");
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Create and publish first message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveNonDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receive first message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            TestUtil.logTrace((String)"Verify that first message is received");
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
            TestUtil.logTrace((String)"Close default subscriber");
            tSub.close();
            TestUtil.logTrace((String)"Create and publish second message");
            messageSent2 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent2.setText("test that messages are nondurable");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveNonDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent2);
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logTrace((String)"Recreate default subscriber");
            newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            tSession = newTConn.createTopicSession(false, 1);
            tSub = tSession.createSubscriber(this.tool.getDefaultTopic());
            newTConn.start();
            TestUtil.logTrace((String)"Try to receive second message (should not receive a message)");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Received second message. (Expected NO messages)");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("inactiveNonDurableSubscriberTopicRecTest");
        }
    }

    public void noLocalDeliveryTopicTest() throws EETest.Fault {
        String lookup = "MyTopicConnectionFactory";
        try {
            int i;
            int num = 10;
            TopicSubscriber tSubNoLocal = null;
            TopicConnection newConn = null;
            TopicSession newSess = null;
            TopicPublisher newPub = null;
            TopicSubscriber newSub = null;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            tSubNoLocal = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "", true);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)("Sending " + num + " messages to topic"));
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "noLocalDeliveryTopicTest");
            for (i = 0; i < num; ++i) {
                this.tool.getDefaultTopicPublisher().publish(messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages");
            for (i = 0; i < num; ++i) {
                messageReceived = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                if (messageReceived != null) continue;
                throw new EETest.Fault("Should have received message");
            }
            TestUtil.logMsg((String)"Creating new connection");
            newConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            newSess = newConn.createTopicSession(false, 1);
            newSub = newSess.createSubscriber(this.tool.getDefaultTopic());
            newPub = newSess.createPublisher(this.tool.getDefaultTopic());
            newConn.start();
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            messageReceived = newSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("new connection should have received message");
            }
            TestUtil.logTrace((String)"New connection sending message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.publish(messageSent);
            TestUtil.logTrace((String)"Closing new connection");
            newConn.close();
            TestUtil.logTrace((String)"Try to receive only message from new connection");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("No_local subscriber did not receive any message");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new EETest.Fault("No_local subscriber received local message");
            }
            TestUtil.logTrace((String)"Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("noLocalDeliveryTopicTest");
        }
    }

    public void simpleDurableSubscriberTopicTest() throws EETest.Fault {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            TestUtil.logMsg((String)"Create DurableSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "myDurableTopicSubscriber");
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Creating and sending 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleDurableSubscriberTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logMsg((String)"Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "myDurableTopicSubscriber");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("simpleDurableSubscriberTopicTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "myDurableTopicSubscriber");
                throw throwable;
            }
        }
    }

    public void temporaryTopicConnectionClosesTest() throws EETest.Fault {
        boolean passed = false;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating TemporaryTopic");
            TemporaryTopic tempT = this.tool.getDefaultTopicSession().createTemporaryTopic();
            TestUtil.logTrace((String)"Creating new Connection");
            TopicConnection newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            TestUtil.logTrace((String)"Create new Session");
            TopicSession newTSess = newTConn.createTopicSession(false, 1);
            TestUtil.logTrace((String)"Create new sender for TemporaryTopic");
            TopicPublisher newTPublisher = newTSess.createPublisher((Topic)tempT);
            TestUtil.logTrace((String)"Send message to TemporaryTopic");
            TextMessage tMsg = newTSess.createTextMessage();
            tMsg.setText("test message");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryTopicConnectionClosesTest");
            TestUtil.logTrace((String)"TextMessage created. Now publishing");
            newTPublisher.publish((Message)tMsg);
            TestUtil.logTrace((String)"Close original Connection");
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logTrace((String)"Close new TopicConnection");
            newTConn.close();
            passed = true;
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("temporaryTopicConnectionClosesTest");
        }
    }

    public void temporaryTopicNotConsumableTest() throws EETest.Fault {
        boolean passed = false;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Creating TemporaryTopic");
            TemporaryTopic tempT = this.tool.getDefaultTopicSession().createTemporaryTopic();
            TestUtil.logMsg((String)"Creating new Connection");
            TopicConnection newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            TestUtil.logMsg((String)"Create new Session");
            TopicSession newTSess = newTConn.createTopicSession(false, 1);
            TestUtil.logMsg((String)"Create new publisher for TemporaryTopic");
            TopicPublisher newTPublisher = newTSess.createPublisher((Topic)tempT);
            TestUtil.logMsg((String)"Send message to TemporaryTopic");
            TextMessage tMsg = newTSess.createTextMessage();
            tMsg.setText("test message");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryTopicNotConsumableTest");
            TestUtil.logMsg((String)"TextMessage created. Now publishing");
            newTPublisher.publish((Message)tMsg);
            TestUtil.logMsg((String)"Attempt to create subscriber for TemporaryTopic from another Session");
            try {
                TopicSubscriber newTSubscriber = newTSess.createSubscriber((Topic)tempT);
                if (newTSubscriber != null) {
                    TestUtil.logTrace((String)("newTSubscriber=" + newTSubscriber));
                }
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Received expected JMSException -- GOOD");
                TestUtil.logMsg((String)"Received Exception:", (Throwable)e);
                passed = true;
            }
            TestUtil.logTrace((String)"Close new TopicConnection");
            newTConn.close();
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("temporaryTopicNotConsumableTest");
        }
    }

    public void msgSelectorMsgHeaderTopicTest() throws EETest.Fault {
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            TestUtil.logMsg((String)"Creating subscriber with message selector");
            TopicSubscriber tSelectiveSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "JMSType = 'test_message'", false);
            this.tool.getDefaultTopicConnection().start();
            Message m = this.tool.getDefaultTopicSession().createMessage();
            m.setStringProperty("COM_SUN_JMS_TESTNAME", "msgSelectorMsgHeaderTopicTest");
            TestUtil.logTrace((String)"Sending message not matching selector");
            m.setJMSType("foo");
            m.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish(m);
            TestUtil.logTrace((String)"Sending message that matches selector");
            m.setJMSType("test_message");
            m.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish(m);
            TestUtil.logMsg((String)"Attempt to receive 'good' message");
            Message msg1 = tSelectiveSubscriber.receive(this.timeout);
            if (msg1 == null) {
                throw new Exception("Did not receive expected message");
            }
            if (!msg1.getBooleanProperty("lastMessage")) {
                TestUtil.logMsg((String)"Received message not matching header");
                throw new EETest.Fault("Received incorrect message");
            }
            TestUtil.logMsg((String)"Received correct message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgSelectorMsgHeaderTopicTest");
        }
    }

    public void inactiveDurableSubscriberTopicRecTest() throws EETest.Fault {
        TopicSubscriber durableTS = null;
        TopicSession tSession = null;
        TopicConnection newTConn = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent1 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            TestUtil.logTrace((String)"Create DurableSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "inactiveDurableSubscriberTopicRecTest");
            TestUtil.logTrace((String)"Start Connection");
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating and sending 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
            durableTS.close();
            messageSent1 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent1.setText("test that messages are durable");
            messageSent1.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent1);
            this.tool.getDefaultTopicConnection().close();
            newTConn = (TopicConnection)this.tool.getNewConnection(4, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            tSession = newTConn.createTopicSession(false, 1);
            durableTS = tSession.createDurableSubscriber(this.tool.getDefaultTopic(), "inactiveDurableSubscriberTopicRecTest");
            newTConn.start();
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent1.getText())) {
                throw new EETest.Fault("Received incorrect message.");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct message");
            this.cleanupSubscription(durableTS, tSession, "inactiveDurableSubscriberTopicRecTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("inactiveDurableSubscriberTopicRecTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, tSession, "inactiveDurableSubscriberTopicRecTest");
                throw throwable;
            }
        }
    }

    public void durableSubscriberTopicNoLocalTest() throws EETest.Fault {
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName = "DurableSubscriberTopicNoLocalTestSubscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        String lookup2 = "MyTopicConnectionFactory";
        try {
            int num = 10;
            TopicConnection newConn = null;
            TopicSession newSess = null;
            TopicPublisher newPub = null;
            TopicSubscriber newSub = null;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            TestUtil.logTrace((String)"Create DurableSubscriber");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", true);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)("Sending " + num + " messages to topic"));
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "noLocalDeliveryTopicTest");
            TopicPublisher defaultPub = this.tool.getDefaultTopicPublisher();
            for (int i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages");
            TopicSubscriber defaultSub = this.tool.getDefaultTopicSubscriber();
            for (int i = 0; i < num; ++i) {
                messageReceived = defaultSub.receive(this.timeout);
                if (messageReceived != null) continue;
                throw new EETest.Fault("Should have received message");
            }
            TestUtil.logMsg((String)"Creating new connection");
            newConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup2);
            this.connections.add(newConn);
            newSess = newConn.createTopicSession(false, 1);
            newSub = newSess.createSubscriber(this.tool.getDefaultTopic());
            newPub = newSess.createPublisher(this.tool.getDefaultTopic());
            newConn.start();
            defaultPub.publish(messageSent);
            messageReceived = newSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("new connection should have received message");
            }
            TestUtil.logTrace((String)"New connection sending message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.publish(messageSent);
            TestUtil.logTrace((String)"Closing new connection");
            newConn.close();
            TestUtil.logTrace((String)"Try to receive only message from default connection");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("No_local subscriber did not receive any message");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new EETest.Fault("No_local subscriber received local message");
            }
            TestUtil.logTrace((String)"Received correct message");
            this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("durableSubscriberTopicNoLocalTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
                throw throwable;
            }
        }
    }

    public void durableSubscriberTopicNoLocalTest2() throws EETest.Fault {
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName = "DurableSubscriberTopicNoLocalTest2Subscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            int i;
            int num = 10;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            TestUtil.logTrace((String)"Create DurableSubscriber with no_local=true");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", true);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)("Sending " + num + " messages to topic"));
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberTopicNoLocalTest2");
            TopicPublisher defaultPub = this.tool.getDefaultTopicPublisher();
            for (int i2 = 0; i2 < num; ++i2) {
                defaultPub.publish(messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages from normal subscriber");
            TopicSubscriber defaultSub = this.tool.getDefaultTopicSubscriber();
            for (i = 0; i < num; ++i) {
                messageReceived = defaultSub.receive(this.timeout);
                if (messageReceived == null) {
                    throw new EETest.Fault("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) {
                    throw new EETest.Fault("Received incorrect message lastMessage=true");
                }
                TestUtil.logTrace((String)"Received correct message lastMessage=false");
            }
            TestUtil.logMsg((String)"Attempting to receive messages from (no_local=true) subscriber");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new EETest.Fault("Received unexpected message (incorrect)");
            }
            TestUtil.logTrace((String)"Did not receive message (correct)");
            TestUtil.logTrace((String)("Sending " + num + " messages to topic"));
            for (i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            TestUtil.logTrace((String)"Close DurableSubscriber with no_local=true");
            tSubNoLocal.close();
            TestUtil.logTrace((String)"Create DurableSubscriber with no_local=false");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", false);
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new EETest.Fault("No_local=false subscriber received message (unexpected)");
            }
            TestUtil.logMsg((String)"No_local=false subscriber did not receive any message (expected)");
            TestUtil.logTrace((String)("Sending " + num + " messages to topic"));
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberTopicNoLocalTest2");
            for (i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages from (no_local=false) subscriber");
            for (i = 0; i < num; ++i) {
                messageReceived = tSubNoLocal.receive(this.timeout);
                if (messageReceived == null) {
                    throw new EETest.Fault("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) {
                    throw new EETest.Fault("Received incorrect message lastMessage=true");
                }
                TestUtil.logTrace((String)"Received correct message lastMessage=false");
            }
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new EETest.Fault("Received unexpected final message");
            }
            this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("durableSubscriberTopicNoLocalTest2");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
                throw throwable;
            }
        }
    }

    public void durableSubscriberNewTopicTest() throws EETest.Fault {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Topic newTestTopic = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            newTestTopic = this.tool.createNewTopic("MY_TOPIC2");
            TopicPublisher newTestPublisher = this.tool.getDefaultTopicSession().createPublisher(newTestTopic);
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberNewTopicTest");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("For default topic");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberNewTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct message");
            durableTS.close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(newTestTopic, "durableSubscriberNewTopicTest");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("For new topic");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberNewTopicTest");
            newTestPublisher.publish((Message)messageSent);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberNewTopicTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("durableSubscriberNewTopicTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberNewTopicTest");
                throw throwable;
            }
        }
    }

    public void durableSubscriberChangeSelectorTest() throws EETest.Fault {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest", "TEST = 'test'", false);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest");
            messageSent.setText("For default topic ");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct message");
            durableTS.close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest", "TEST = 'new one'", false);
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "new one");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest");
            messageSent.setText("For new topic");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                if (!messageReceived.getText().equals(messageSent.getText()) || !messageReceived.getBooleanProperty("lastMessage")) {
                    throw new EETest.Fault("didn't get the right message");
                }
            } else {
                throw new EETest.Fault("didn't get any message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("durableSubscriberChangeSelectorTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest");
                throw throwable;
            }
        }
    }

    public void durableSubscriberChangeSelectorTest2() throws EETest.Fault {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            TestUtil.logTrace((String)"Create durable subscription with MessageSelector=\"TEST='test'\",");
            TestUtil.logTrace((String)("TopicName=" + this.tool.getDefaultTopic().getTopicName() + " and SubscriptionName=durableSubscriberChangeSelectorTest2"));
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest2", "TEST = 'test'", false);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Create/Send first message with string property \"TEST = 'test'\"");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest2");
            messageSent.setText("Message #1 with string property TEST='test'");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Create/Send second message with string property \"TEST = 'test again'\"");
            messageSent2 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent2.setStringProperty("TEST", "test again");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest2");
            messageSent2.setText("Message #2 with string property TEST='test again'");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent2);
            TestUtil.logTrace((String)"Try receiving first message (should get message)");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logTrace((String)"Did not receive any message (incorrect)");
                throw new EETest.Fault("didn't receive any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logTrace((String)"Received correct first message");
            TestUtil.logTrace((String)"Try receiving second message (should not get message)");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                    throw new EETest.Fault("received second message (unexpected)");
                }
                TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                throw new EETest.Fault("received unexpected message");
            }
            TestUtil.logTrace((String)"Did not receive second message (correct)");
            TestUtil.logTrace((String)"Close durable subscription");
            durableTS.close();
            TestUtil.logTrace((String)"Create new durable subscription with MessageSelector=\"TEST='test again'\",");
            TestUtil.logTrace((String)("TopicName=" + this.tool.getDefaultTopic().getTopicName() + " and SubscriptionName=durableSubscriberChangeSelectorTest2"));
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest2", "TEST = 'test again'", false);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                throw new EETest.Fault("received unexpected message");
            }
            TestUtil.logTrace((String)"Did not receive any messages (correct)");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest2");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("durableSubscriberChangeSelectorTest2");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest2");
                throw throwable;
            }
        }
    }

    public void msgProducerNullDestinationTopicTest() throws EETest.Fault {
        boolean pass = true;
        TopicPublisher tPublisher = null;
        Topic nullTopic = null;
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        String testName = "msgProducerNullDestinationTopicTest";
        String message = "Just a test from msgProducerNullDestinationTopicTest";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicPublisher().close();
            try {
                tPublisher = this.tool.getDefaultTopicSession().createPublisher(nullTopic);
                TestUtil.logTrace((String)"PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected Exception: ", (Throwable)ee);
                pass = false;
            }
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating  1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText(message);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            TestUtil.logTrace((String)"Publish a message");
            tPublisher.publish(this.tool.getDefaultTopic(), (Message)messageSent);
            TestUtil.logTrace((String)"Receive a message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
            }
            TestUtil.logMsg((String)"Publish message the second time ");
            tPublisher.publish(this.tool.getDefaultTopic(), (Message)messageSent, 2, 4, 0L);
            TestUtil.logMsg((String)"Receiving message again");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText())) {
                pass = false;
                TestUtil.logErr((String)"didn't get the right message");
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during msgProducerNullDestinationTopicTest tests");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred! ", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgProducerNullDestinationTopicTest");
        }
    }

    public void multipleCloseTopicConnectionTest() throws EETest.Fault {
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Call close on a connection ");
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logTrace((String)"Call close on a connection a second time");
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("multipleCloseTopicConnectionTest");
        }
    }

    public void consumerTests() throws EETest.Fault {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Object tempMsg = null;
            int numMessages = 2;
            boolean pass = true;
            MessageConsumer defaultConsumer = null;
            MessageConsumer selectConsumer = null;
            MessageConsumer noLocalConsumer = null;
            Connection newConn = null;
            Session newSess = null;
            MessageProducer newPub = null;
            String testName = "consumerTests";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            newConn = this.tool.getNewConnection(14, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            newSess = newConn.createSession(false, 1);
            noLocalConsumer = newSess.createConsumer(this.tool.getDefaultDestination(), null, true);
            selectConsumer = newSess.createConsumer(this.tool.getDefaultDestination(), "TEST = 'test'", false);
            defaultConsumer = newSess.createConsumer(this.tool.getDefaultDestination());
            newPub = newSess.createProducer(this.tool.getDefaultDestination());
            this.tool.getDefaultConnection().start();
            newConn.start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("Just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            TestUtil.logTrace((String)"Sending message to a Topic");
            messageSent.setBooleanProperty("lastMessage", false);
            newPub.send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.send((Message)messageSent);
            TestUtil.logTrace((String)"noLocalConsumer Receiving message");
            messageReceived = (TextMessage)noLocalConsumer.receive(this.timeout);
            if (messageReceived != null) {
                pass = false;
                TestUtil.logErr((String)"Error:  No_local MessageConsumer did receive local message");
            }
            TestUtil.logTrace((String)"defaultConsumer Receiving message");
            for (int i = 0; i < numMessages; ++i) {
                messageReceived = (TextMessage)defaultConsumer.receive(this.timeout);
                if (messageReceived == null) {
                    pass = false;
                    TestUtil.logErr((String)("Error:  Did not receive message " + i));
                    continue;
                }
                if (messageReceived.getText().equals(messageSent.getText())) continue;
                TestUtil.logErr((String)("Error: didn't get the right message " + i));
                pass = false;
            }
            TestUtil.logTrace((String)"selectConsumer Receiving message");
            messageReceived = (TextMessage)selectConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"Error:  Did not receive correct message");
            } else if (!messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logErr((String)"Error: didn't get the right message");
                pass = false;
            }
            TestUtil.logTrace((String)"sending message from default connection");
            messageSent.setBooleanProperty("newConnection", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            TestUtil.logTrace((String)"noLocalConsumer Receiving message");
            messageReceived = (TextMessage)noLocalConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                TestUtil.logMsg((String)"Received correct message");
            } else {
                TestUtil.logErr((String)"Error: didn't get the right message");
                pass = false;
            }
            noLocalConsumer.close();
            defaultConsumer.close();
            selectConsumer.close();
            try {
                TestUtil.logTrace((String)"Closing new connection");
                newConn.close();
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Error closing the second Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new EETest.Fault(testName + " Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void tempTopicTests() throws EETest.Fault {
        boolean pass = true;
        String testName = "tempTopicTests";
        String message = "Just a test from tempTopicTests";
        TemporaryTopic tempT = null;
        Connection newConn = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            TestUtil.logMsg((String)"Creating TemporaryTopic");
            tempT = this.tool.getDefaultSession().createTemporaryTopic();
            TestUtil.logMsg((String)"Create new sender for TemporaryTopic");
            MessageProducer sender = this.tool.getDefaultSession().createProducer((Destination)tempT);
            MessageConsumer receiver = this.tool.getDefaultSession().createConsumer((Destination)tempT);
            TestUtil.logMsg((String)"Send message to TemporaryTopic");
            TextMessage msgSent = this.tool.getDefaultSession().createTextMessage();
            msgSent.setText(message);
            msgSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            sender.send((Message)msgSent);
            TextMessage msgReceived = (TextMessage)receiver.receive(this.timeout);
            if (msgReceived == null) {
                pass = false;
                TestUtil.logErr((String)"didnot receive message");
            } else if (!msgReceived.getText().equals(message)) {
                pass = false;
                TestUtil.logErr((String)("Received wrong message=" + msgReceived.getText()));
                TestUtil.logErr((String)("Should have: " + message));
            }
            try {
                tempT.delete();
                pass = false;
                TestUtil.logErr((String)"TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                TestUtil.logTrace((String)"Received expected JMSException: ");
            }
            receiver.close();
            try {
                tempT.delete();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
            tempT = this.tool.getDefaultSession().createTemporaryTopic();
            newConn = this.tool.getNewConnection(14, this.jmsUser, this.jmsPassword, lookup);
            Session newSess = newConn.createSession(false, 1);
            TestUtil.logMsg((String)"Attempt to create MessageConsumer for TemporaryTopic from another Connection");
            try {
                MessageConsumer newReceiver = newSess.createConsumer((Destination)tempT);
                if (newReceiver != null) {
                    TestUtil.logTrace((String)("newReceiver=" + newReceiver));
                }
            }
            catch (JMSException e) {
                TestUtil.logTrace((String)"Received expected JMSException from createConsumer.");
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
        finally {
            try {
                this.tool.getDefaultConnection().close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error closing Connection in " + testName), (Throwable)e);
            }
            try {
                newConn.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error closing the new Connection in " + testName), (Throwable)e);
            }
        }
    }
}

