/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.access.field;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.access.field.DataTypes;
import com.sun.ts.tests.jpa.core.annotations.access.field.DataTypes2;
import com.sun.ts.tests.jpa.core.types.common.Grade;
import jakarta.persistence.Query;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    private DataTypes d1;
    private DataTypes2 d2;
    final Date dateId = this.getPKDate(2006, 4, 15);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setup2(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup2");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData2();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setup3(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup3");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData3();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void fieldTypeTest1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && !this.d1.isProperty()) {
                this.d1.setBooleanData(true);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.isProperty()) {
                    TestUtil.logTrace((String)("Received expected result:" + this.d1.isProperty()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: true, actual:" + this.d1.isProperty()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest2() throws EETest.Fault {
        boolean pass = false;
        byte newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getByteData() == 100) {
                this.d1.setByteData(newByte);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getByteData() == newByte) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: 100, actual:" + this.d1.getByteData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest3() throws EETest.Fault {
        boolean pass = false;
        int newChar = 98;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getCharacterData() == 'a') {
                this.d1.setCharacterData('b');
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData() == 'b') {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: a, actual:" + this.d1.getCharacterData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest4() throws EETest.Fault {
        boolean pass = false;
        int newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getShortData() == 100) {
                this.d1.setShortData((short)101);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData() == 101) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: 100, actual:" + this.d1.getShortData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest5() throws EETest.Fault {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntData() == 300) {
                this.d1.setIntData(500);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntData() == 500) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: 300, actual:" + this.d1.getIntData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest6() throws EETest.Fault {
        boolean pass = false;
        long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getLongData() == 600L) {
                this.d1.setLongData(600L);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData() == 600L) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: 600, actual:" + this.d1.getLongData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest7() throws EETest.Fault {
        boolean pass = false;
        double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getDoubleData() == 50.0) {
                this.d1.setDoubleData(80.0);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData() == 80.0) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: 50, actual:" + this.d1.getDoubleData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest8() throws EETest.Fault {
        boolean pass = false;
        float expFloat = 1.0f;
        float floatRange = 2.0f;
        float newFloat = 6.0f;
        float newfloatRange = 7.0f;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)("float value is: " + this.d1.getFloatData()));
                if (this.d1.getFloatData() >= 1.0f && this.d1.getFloatData() < 2.0f) {
                    this.d1.setFloatData(6.0f);
                    this.getEntityManager().merge((Object)this.d1);
                    this.getEntityManager().flush();
                    if (this.d1.getFloatData() >= 6.0f && this.d1.getFloatData() < 7.0f) {
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: >= 6.0 and < 7.0, actual:" + this.d1.getFloatData()));
                    }
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest8 failed");
        }
    }

    public void fieldTypeTest9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find DataTypes entity in fieldTypeTest9");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataTypes is not null, setting enumData");
                this.d1.setEnumData(Grade.B);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Update performed, check results");
                if (null != this.d1 && this.d1.getEnumData().equals((Object)Grade.B)) {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + Grade.B.toString() + ", actual:" + this.d1.getEnumData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest9 failed");
        }
    }

    public void fieldTypeTest10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN fieldTypeTest10");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"fieldTypeTest10:  Check results");
                if (this.d2.getId().equals(this.dateId)) {
                    TestUtil.logTrace((String)("Got expected PK of:" + this.d2.getId() + "received"));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + this.dateId + ", actual: " + this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest11() throws EETest.Fault {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        byte[] a = null;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1 IN fieldTypeTest11");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + 5);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"fieldTypeTest11:  Check results");
                if (null != this.d2 && Arrays.equals(this.d1.getByteArrayData(), a)) {
                    TestUtil.logTrace((String)"fieldTypeTest11: Expected results received");
                    pass = true;
                } else {
                    int n;
                    TestUtil.logErr((String)"Unexpected result in array comparison.");
                    byte[] byArray = a;
                    int n2 = byArray.length;
                    for (n = 0; n < n2; ++n) {
                        Byte aByte = byArray[n];
                        TestUtil.logErr((String)("Array a in propertyTest9 equals: " + aByte));
                    }
                    byArray = b;
                    n2 = byArray.length;
                    for (n = 0; n < n2; ++n) {
                        Byte bByte = byArray[n];
                        TestUtil.logErr((String)("Array b in propertyTest9 equals: " + bByte));
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest12() throws EETest.Fault {
        boolean pass = false;
        char[] charData = new char[]{'c', 't', 's'};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1 IN fieldTypeTest12");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting charData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"fieldTypeTest12:  Check results");
                if (null != this.d1 && Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    TestUtil.logTrace((String)"fieldTypeTest12: Expected Results Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected " + Arrays.toString(charData) + ", actual: " + Arrays.toString(this.d1.getCharArrayData())));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest13() throws EETest.Fault {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN fieldTypeTest13");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"fieldTypeTest13:  Check results");
                if (null != this.d2 && this.d2.getTimeData().equals(timeValue)) {
                    TestUtil.logTrace((String)"fieldTypeTest13: Expected Time Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected " + timeValue + " , actual: " + this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest14() throws EETest.Fault {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN fieldTypeTest14");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"fieldTypeTest14:  Check results");
                if (null != this.d2 && this.d2.getTsData().equals(tsValue)) {
                    TestUtil.logTrace((String)"fieldTypeTest14: Expected Timestamp Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected " + tsValue + " , actual: " + this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest15() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = com.sun.ts.tests.jpa.core.types.common.Grade.A");
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    TestUtil.logTrace((String)("Received expected result:" + this.d1.toString()));
                } else {
                    TestUtil.logErr((String)("Expected:" + this.d1.toString() + ", actual:" + result.toString()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest15 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest16() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = :grade").setParameter("grade", (Object)Grade.A);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    TestUtil.logTrace((String)("Received expected result:" + this.d1.toString()));
                } else {
                    TestUtil.logErr((String)("Expected:" + this.d1.toString() + ", actual:" + result.toString()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest17() throws EETest.Fault {
        boolean pass = false;
        Grade failingGrade = Grade.F;
        Grade incompleteGrade = Grade.INCOMPLETE;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE (dt.enumData <> ?1) OR (dt.enumData <> ?2) ").setParameter(1, (Object)failingGrade).setParameter(2, (Object)incompleteGrade);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    TestUtil.logTrace((String)("Received expected result:" + this.d1.toString()));
                } else {
                    TestUtil.logErr((String)("Expected:" + this.d1.toString() + ", actual:" + result.toString()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("fieldTypeTest17 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setup2")
    public void mixedAccessTest() throws EETest.Fault {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntData2() == 300) {
                TestUtil.logMsg((String)("Int value after find=" + this.d1.getIntData2()));
                this.d1.setIntData2(500);
                TestUtil.logMsg((String)("Int value after set=" + this.d1.getIntData2()));
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.clearCache();
                this.d1 = null;
                this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                if (this.d1.getIntData2() == 500) {
                    pass = true;
                    TestUtil.logTrace((String)("Received expected value:" + this.d1.getIntData2()));
                } else {
                    TestUtil.logErr((String)("Expected:500, actual:" + this.d1.getIntData2()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("mixedAccessTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setup3")
    public void transientTest() throws EETest.Fault {
        boolean pass = false;
        byte newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getTransient() == 0) {
                    TestUtil.logTrace((String)("First find returned expected result:" + this.d1.getTransient()));
                    this.d1.setTransient(newByte);
                    this.getEntityManager().merge((Object)this.d1);
                    this.getEntityManager().flush();
                    this.clearCache();
                    this.d1 = null;
                    this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                    if (this.d1.getTransient() == 0) {
                        pass = true;
                        TestUtil.logTrace((String)("Second find returned expected value:" + this.d1.getTransient()));
                    } else {
                        TestUtil.logErr((String)("Second find expected:0, actual:" + this.d1.getTransient()));
                    }
                } else {
                    TestUtil.logErr((String)("Expected first find to return:0, actual:" + this.d1.getTransient()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"find returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("transientTest failed");
        }
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, false, 100, 'a', 100, 300, 600L, 50.0, 1.0f, cArray, bArray);
            TestUtil.logTrace((String)("dateId is: " + this.dateId));
            this.d2 = new DataTypes2(this.dateId);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    public void createTestData2() {
        TestUtil.logTrace((String)"createTestData2");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 300);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    public void createTestData3() {
        TestUtil.logTrace((String)"createTestData3");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 5);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)("isActive:" + this.getEntityTransaction().isActive()));
            this.getEntityManager().createNativeQuery("Delete from DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

