/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.transport;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

public class send_Test
extends ServiceEETest
implements Serializable {
    private String transport_protocol = null;
    private transient MailTestUtil mailTestUtil;
    private String user;
    private String password;
    private transient Status status;
    private int errors = 0;
    private String mailTo = null;
    private transient Session session;
    public String TO = "ksnijjar@eng";
    public static final String SUBJECT = "Transport class test";
    public static final String TEXT = "Testing Transport class send() API";
    public static final String MAILER = "JavaMail";
    static String msgText = "This is a message body.\nHere's the second line.";

    public static void main(String[] args) {
        send_Test theTests = new send_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            this.user = TestUtil.getProperty((String)"javamail.username");
            this.password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            this.mailTestUtil = new MailTestUtil();
            this.session = this.mailTestUtil.createSession(host, smtpPortStr, this.user, this.password);
            this.mailTo = TestUtil.getProperty((String)"mailuser1");
            if (this.mailTo.length() == 0) {
                throw new EETest.Fault("Invalid mailuser1 - the mail to property");
            }
            this.transport_protocol = TestUtil.getProperty((String)"transport_protocol");
            if (this.transport_protocol.length() == 0) {
                throw new EETest.Fault("Invalid transport_protocol");
            }
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSend() throws EETest.Fault {
        String msgText = "Testing Transport.send(Message msg).\nPASS.";
        try {
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testSend()" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            TestUtil.logTrace((String)"UNIT TEST 1: send(Message)");
            Transport.send((Message)msg);
            TestUtil.logTrace((String)"UNIT TEST 1: passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSend() Failed!", e);
        }
    }

    public void testSend2() throws EETest.Fault {
        String msgText = "Testing Transport.send(Message, Address[]).\nPASS.";
        try {
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testSend2()" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            Transport.send((Message)msg, (Address[])addrs);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSend2() Failed!", e);
        }
    }

    public void testSend3() throws EETest.Fault {
        String msgText = "Testing message/rfc822.";
        try {
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            Address[] addrs = new Address[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, addrs);
            msg.setSubject("get rfc822 type");
            msg.setContent((Object)"Verify that type is rfc822", "text/plain");
            addrs = msg.getFrom();
            String addtype = addrs[0].getType();
            TestUtil.logTrace((String)("addtype is " + addtype));
            if (addtype != null) {
                if (addtype.equals("rfc822")) {
                    TestUtil.logTrace((String)"UNIT TEST  passed\n");
                } else {
                    throw new EETest.Fault("UNIT TEST  FAILED\n");
                }
            }
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSend3() Failed!", e);
        }
    }

    public void testconnect1() throws EETest.Fault {
        Object host = null;
        Object user = null;
        Object password = null;
        String msgText = "Testing connect().\nPASS.";
        try {
            Transport transport = this.session.getTransport(this.transport_protocol);
            if (transport == null) {
                throw new EETest.Fault("WARNING: Failed to create a transport object!");
            }
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testconnect1" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            transport.connect();
            transport.sendMessage((Message)msg, (Address[])addrs);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testConnect1() Failed!", e);
        }
    }

    public void testSendMessage() throws EETest.Fault {
        String msgText = "Testing sendMessage(Message,Address[]).\nPASS.";
        try {
            Transport transport = this.session.getTransport(this.transport_protocol);
            if (transport == null) {
                throw new EETest.Fault("WARNING: Failed to create a transport object!");
            }
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testSendMessage()" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            transport.connect();
            transport.sendMessage((Message)msg, (Address[])addrs);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSendMessage() Failed!", e);
        }
    }

    public void test4() throws EETest.Fault {
        this.TO = this.user;
        TestUtil.logMsg((String)"\nTesting Transport class => send(Message, Address[])\n");
        try {
            MimeMessage msg = new MimeMessage(this.session);
            Transport transport = this.session.getTransport(this.transport_protocol);
            if (transport == null) {
                throw new EETest.Fault("WARNING: Failed to create a transport object!");
            }
            InternetAddress addr = new InternetAddress(this.TO);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("JavaMail send() API Test");
            msg.setContent((Object)msgText, "text/plain");
            TestUtil.logMsg((String)"UNIT TEST 1: send(Message)");
            Transport.send((Message)msg);
            TestUtil.logMsg((String)"UNIT TEST 1: passed\n");
            TestUtil.logMsg((String)"UNIT TEST 2: send(Message, Address[])");
            Transport.send((Message)msg, (Address[])addrs);
            TestUtil.logMsg((String)"UNIT TEST 2: passed\n");
            TestUtil.logMsg((String)"UNIT TEST 3: send(Message, String, String)");
            msg = new MimeMessage(this.session);
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("JavaMail send() API Test");
            msg.setContent((Object)msgText, "text/plain");
            Transport.send((Message)msg, (String)this.user, (String)this.password);
            TestUtil.logMsg((String)"UNIT TEST 3: passed\n");
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test4() Failed!", e);
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }
}

