/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entityManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entityManager.Employee;
import com.sun.ts.tests.jpa.core.entityManager.Order;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.LockModeType;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupOrderData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployeeData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupData() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        TestUtil.logTrace((String)"in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                TestUtil.logTrace((String)("Processing set:" + rsnum));
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    TestUtil.logTrace((String)("Getting result set: " + rsnum + ", size:" + list.size()));
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            TestUtil.logTrace((String)("Saving:" + e));
                            empList.add(e);
                            continue;
                        }
                        TestUtil.logErr((String)("Did not get instance of Employee, instead got:" + o.getClass().getName()));
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    TestUtil.logErr((String)("Result set[" + rsnum + "] returned was null"));
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    TestUtil.logTrace((String)("rowsAffected:" + rowsAffected));
                }
            }
            results = spq.hasMoreResults();
            TestUtil.logTrace((String)("Results:" + results));
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    TestUtil.logTrace((String)"Received expected result:");
                    for (Integer n : actual) {
                        TestUtil.logTrace((String)("id:" + n));
                    }
                    ++count;
                    continue;
                }
                TestUtil.logErr((String)"Did not receive expected result:");
                for (Integer n : expected) {
                    TestUtil.logErr((String)(" Expected id:" + n));
                }
                for (Integer n : actual) {
                    TestUtil.logErr((String)("Actual id:" + n));
                }
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                TestUtil.logTrace((String)("Received expected result:" + e));
            }
            result = true;
        } else {
            TestUtil.logErr((String)"Did not receive expected result:");
            for (Employee e : expected) {
                TestUtil.logErr((String)("expected employee:" + e));
            }
            for (Employee e : actual) {
                TestUtil.logErr((String)("actual employee :" + e));
            }
        }
        return result;
    }

    public void mergeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o1 = (Order)this.getEntityManager().merge((Object)new Order(9, 999, "desc999"));
            this.getEntityTransaction().commit();
            this.clearCache();
            Order o2 = (Order)this.getEntityManager().find(Order.class, (Object)9);
            if (o1.equals((Object)o2)) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results - expected:" + o1.toString() + ", actual:" + o2.toString()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("mergeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeExceptionsTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logMsg((String)"Testing merge(Object");
        TestUtil.logMsg((String)"Testing invalid object ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)this);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing removed entity ");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().remove((Object)o);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)o);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("mergeExceptionsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void persistExceptionsTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing persisting an entity twice ");
        try {
            this.getEntityManager().detach((Object)this.orders[0]);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Try to persist an existing Order");
            this.getEntityManager().persist((Object)this.orders[0]);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"A PersistenceException was not thrown");
        }
        catch (EntityExistsException eee) {
            TestUtil.logTrace((String)"EntityExistsException Caught as Expected:", (Throwable)eee);
            pass1 = true;
        }
        catch (PersistenceException pe) {
            TestUtil.logTrace((String)"A PersistentException was caught:", (Throwable)pe);
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing non-entity ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)this);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException caught as expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("persistExceptionsTest failed");
        }
    }

    public void removeExceptionsTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logMsg((String)"Testing findClassObjectIllegalStateException");
        TestUtil.logMsg((String)"Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)this);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeExceptionsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        TestUtil.logMsg((String)"Testing invalid object for lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing invalid object for lock(Object, LockModeType, Map)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("lockIllegalStateExceptionTest failed");
        }
    }

    public void refreshInvalidObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshInvalidObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void refreshNonManagedObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999));
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshNonManagedObjectIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectEntityNotFoundExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Finding Order");
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            TestUtil.logTrace((String)"Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            TestUtil.logTrace((String)"Refreshing previous order");
            this.getEntityManager().refresh((Object)o);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshRemovedObjectEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInvalidObjectMapIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshInvalidObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonManagedObjectMapIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshNonManagedObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectMapEntityNotFoundExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)2);
            TestUtil.logTrace((String)"Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            TestUtil.logTrace((String)"Refreshing previous order");
            this.getEntityManager().refresh((Object)o, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshRemovedObjectMapEntityNotFoundExceptionTest failed");
        }
    }

    public void refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)3);
            TestUtil.logTrace((String)"Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            TestUtil.logTrace((String)"Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest() throws EETest.Fault {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            TestUtil.logTrace((String)"Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            TestUtil.logTrace((String)"Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest failed");
        }
    }

    public void containsIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains((Object)"notanentity");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("containsIllegalArgumentException failed");
        }
    }

    public void createNamedQueryIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery");
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery", Order.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery with incorrect result type version");
        try {
            this.getEntityManager().createNamedQuery("SELECT o from ORDER o", String.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("createNamedQueryIllegalArgumentExceptionTest failed");
        }
    }

    public void createQueryIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        TestUtil.logTrace((String)"Testing String version");
        try {
            Query q = this.getEntityManager().createQuery("CTS Query");
            TestUtil.logMsg((String)"IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                TestUtil.logErr((String)"Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                TestUtil.logTrace((String)"PersistenceException Caught during execution.");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred during execution", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, Class version");
        try {
            this.getEntityManager().createQuery("SELECT o from ORDER o", String.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing CriteriaQuery version");
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(null);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            TestUtil.logMsg((String)"IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                TestUtil.logErr((String)"Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                TestUtil.logTrace((String)"PersistenceException Caught during execution.");
                pass3 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred during execution", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass3 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("createQueryIllegalArgumentExceptionTest failed");
        }
    }

    public void detachIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(Client.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detachIllegalArgumentExceptionTest failed");
        }
    }

    public void getEntityManagerFactoryTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            EntityManagerFactory emf = em.getEntityManagerFactory();
            if (emf == null) {
                TestUtil.logErr((String)"getEntityManagerFactory() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getEntityManagerFactoryTest failed");
        }
    }

    public void emGetMetamodelTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            Metamodel mm = em.getMetamodel();
            if (mm == null) {
                TestUtil.logErr((String)"getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("emGetMetamodelTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyTest() throws EETest.Fault {
        boolean foundKey = false;
        boolean foundValue = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            EntityManager em = this.getEntityManager();
            String expectedKey = "jakarta.persistence.cache.retrieveMode";
            CacheRetrieveMode expectedValue = CacheRetrieveMode.USE;
            TestUtil.logTrace((String)("Setting property:" + expectedKey + "," + expectedValue.toString()));
            em.setProperty(expectedKey, (Object)expectedValue);
            TestUtil.logTrace((String)"Retrieve all EntityManger properties:");
            Map em_entry = em.getProperties();
            for (Map.Entry entry : em_entry.entrySet()) {
                String key = (String)entry.getKey();
                TestUtil.logMsg((String)("Key = " + key));
                if (!key.contains(expectedKey)) continue;
                foundKey = true;
                Object oValue = entry.getValue();
                if (oValue instanceof CacheRetrieveMode) {
                    CacheRetrieveMode value = (CacheRetrieveMode)oValue;
                    if (value.equals((Object)expectedValue)) {
                        TestUtil.logMsg((String)("Received expected value:" + value.toString()));
                        foundValue = true;
                        continue;
                    }
                    TestUtil.logErr((String)("Key:" + expectedKey + " -  expected value:" + expectedKey + ", actual value" + value));
                    continue;
                }
                TestUtil.logErr((String)("The value for Key:" + expectedKey + "was not an instance of String:" + oValue));
            }
            if (!foundKey) {
                TestUtil.logErr((String)("Property key:" + expectedKey + ", not found in EntityManager"));
            }
            if (!foundValue) {
                TestUtil.logErr((String)("The value for Key:" + expectedKey + ", was not found in EntityManager"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!foundKey || !foundValue) {
            throw new EETest.Fault("setPropertyTest failed");
        }
    }

    public void getCriteriaBuilderTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getCriteriaBuilderTest failed");
        }
    }

    public void isJoinedToTransactionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Test when no transaction active");
        if (!this.getEntityManager().isJoinedToTransaction()) {
            TestUtil.logTrace((String)"Received expected result:false");
            pass1 = true;
        } else {
            TestUtil.logErr((String)"Returned true when not in a transaction");
        }
        TestUtil.logMsg((String)"Test when transaction active");
        this.getEntityTransaction().begin();
        if (this.getEntityManager().isJoinedToTransaction()) {
            TestUtil.logTrace((String)"Received expected result:true");
            pass2 = true;
        } else {
            TestUtil.logErr((String)"Returned false when in a transaction");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("isJoinedToTransactionTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            spq.execute();
            Object oActual = spq.getOutputParameterValue(1);
            if (oActual instanceof String) {
                String actual = (String)oActual;
                if (actual.equals(this.emp0.getFirstName())) {
                    TestUtil.logTrace((String)("Received expected result:" + actual));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Expected String to be returned, actual:" + oActual.getClass()));
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringTest failed");
        }
    }

    public void createStoredProcedureQueryStringIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST");
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                TestUtil.logTrace((String)"Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception after execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            TestUtil.logErr((String)msg.toString());
            throw new EETest.Fault("createStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringClassArrayTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Class[] cArray = new Class[]{Employee.class};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", cArray);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if (spq.execute()) {
                List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Integer> expected = new ArrayList<Integer>();
                    for (Employee e : this.empRef) {
                        expected.add(e.getId());
                    }
                    pass = this.verifyListOfListEmployeeIds(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringClassArrayTest failed");
        }
    }

    public void createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        Class[] cArray = new Class[]{Integer.class};
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", cArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException after execute()");
            }
            catch (PersistenceException pe) {
                TestUtil.logTrace((String)"Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception from execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            TestUtil.logErr((String)msg.toString());
            throw new EETest.Fault("createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createStoredProcedureQueryStringStringArrayTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            String[] sArray = new String[]{"id-firstname-lastname"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", sArray);
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createStoredProcedureQueryStringStringArrayTest failed");
        }
    }

    public void createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            String[] sArray = new String[]{"doesnotexist"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", sArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                TestUtil.logTrace((String)"Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception after execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            TestUtil.logErr((String)msg.toString());
            throw new EETest.Fault("createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupEmployeeData")
    @CleanupMethod(name="cleanupData")
    public void createNamedStoredProcedureQueryStringTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            StoredProcedureQuery spq = null;
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"Calling refcursor specific named stored procedure query");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
            } else {
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createNamedStoredProcedureQueryStringTest failed");
        }
    }

    public void createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.getEntityManager().createNamedStoredProcedureQuery("DOESNOTEXIST");
            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        this.getEntityTransaction().rollback();
        if (!pass) {
            throw new EETest.Fault("createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                TestUtil.logTrace((String)("Persisting order:" + o.toString()));
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                TestUtil.logTrace((String)("persisted employee:" + e));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

