/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.sec.annotations.ejb.basicauth;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Stateless;
import jakarta.jws.WebMethod;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceContext;

@WebService
@Stateless
@DeclareRoles(value={"Administrator", "Manager"})
public class Hello {
    @Resource
    private WebServiceContext context;
    String username = null;
    boolean isUserInRoleAdministrator = false;

    @WebMethod
    @RolesAllowed(value={"Administrator"})
    public String sayHelloProtected(String param) {
        if (this.context.getUserPrincipal() != null) {
            this.username = this.context.getUserPrincipal().getName();
        }
        this.isUserInRoleAdministrator = this.context.isUserInRole("Administrator");
        return "Invoked as user :" + this.username + " : isUserInRoleAdministrator =" + this.isUserInRoleAdministrator + " : Hello " + param;
    }

    @WebMethod
    @PermitAll
    public String sayHelloPermitAll(String param) {
        if (this.context.getUserPrincipal() != null) {
            this.username = this.context.getUserPrincipal().getName();
        }
        this.isUserInRoleAdministrator = this.context.isUserInRole("Administrator");
        return "Invoked as user :" + this.username + " : isUserInRoleAdministrator =" + this.isUserInRoleAdministrator + " : Hello " + param;
    }

    @WebMethod
    @DenyAll
    public String sayHelloDenyAll(String param) {
        return "Hello " + param;
    }
}

