/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.ADVC;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.ALocal;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.BDVC;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.BLocal;
import com.sun.ts.tests.ejb.ee.pm.manyXmany.bi.delete.BLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String BLocal = "java:comp/env/ejb/BEJBLocal";
    private EntityContext context = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract ALocal getA3();

    public abstract void setA3(ALocal var1);

    public abstract ALocal getA4();

    public abstract void setA4(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    public abstract BLocal getB3();

    public abstract void setB3(BLocal var1);

    public abstract BLocal getB4();

    public abstract void setB4(BLocal var1);

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public Collection getBInfoFromA() {
        TestUtil.logTrace((String)"getBInfoFromA");
        Vector<BDVC> v = new Vector<BDVC>();
        if (this.getA1() != null) {
            Collection col = this.getA1().getB();
            for (BLocal b : col) {
                BDVC bDVC = new BDVC(b.getId(), b.getName(), b.getValue());
                v.add(bDVC);
            }
        }
        return v;
    }

    public Collection getAInfoFromB() {
        TestUtil.logTrace((String)"getAInfoFromB");
        Vector<ADVC> v = new Vector<ADVC>();
        if (this.getB1() != null) {
            Collection col = this.getB1().getA();
            for (ALocal a : col) {
                ADVC aDVC = new ADVC(a.getId(), a.getName(), a.getValue());
                v.add(aDVC);
            }
        }
        return v;
    }

    public boolean test1() {
        TestUtil.logMsg((String)"starting test1");
        try {
            ALocal aTwo = this.getA2();
            TestUtil.logMsg((String)("aTwo = " + aTwo));
            TestUtil.logMsg((String)"Delete entitybean object A2");
            aTwo.remove();
            TestUtil.logMsg((String)"Attempt to call a method on A2");
            aTwo.getId();
            TestUtil.logErr((String)"Entitybean object A2 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Entitybean object A2 was deleted");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test2() {
        TestUtil.logMsg((String)"starting test2");
        ALocal aTwo = this.getA2();
        Vector<BLocal> c_A1 = new Vector<BLocal>();
        c_A1.add(this.getB1());
        c_A1.add(this.getB2());
        Vector<BLocal> c_A3 = new Vector<BLocal>();
        c_A3.add(this.getB2());
        c_A3.add(this.getB3());
        c_A3.add(this.getB4());
        Vector<BLocal> c_A4 = new Vector<BLocal>();
        c_A4.add(this.getB3());
        c_A4.add(this.getB4());
        Vector<ALocal> c_B1 = new Vector<ALocal>();
        c_B1.add(this.getA1());
        Vector<ALocal> c_B2 = new Vector<ALocal>();
        c_B2.add(this.getA1());
        c_B2.add(this.getA3());
        Vector<ALocal> c_B3 = new Vector<ALocal>();
        c_B3.add(this.getA3());
        c_B3.add(this.getA4());
        Vector<ALocal> c_B4 = new Vector<ALocal>();
        c_B4.add(this.getA3());
        c_B4.add(this.getA4());
        try {
            TestUtil.logMsg((String)"Delete entitybean object A2");
            aTwo.remove();
            TestUtil.logMsg((String)"Verifying relationships of As and Bs");
            Collection a1 = this.getA1().getB();
            Collection a3 = this.getA3().getB();
            Collection a4 = this.getA4().getB();
            Collection b1 = this.getB1().getA();
            Collection b2 = this.getB2().getA();
            Collection b3 = this.getB3().getA();
            Collection b4 = this.getB4().getA();
            if (!(a1.containsAll(c_A1) && a1.size() == c_A1.size() && a3.containsAll(c_A3) && a3.size() == c_A3.size() && a4.containsAll(c_A4) && a4.size() == c_A4.size() && b1.containsAll(c_B1) && b1.size() == c_B1.size() && b2.containsAll(c_B2) && b2.size() == c_B2.size() && b3.containsAll(c_B3) && b3.size() == c_B3.size() && b4.containsAll(c_B4) && b4.size() == c_B4.size())) {
                TestUtil.logMsg((String)"relationships of As and Bs are not updated correctly");
                return false;
            }
            TestUtil.logMsg((String)"relationships of As and Bs are updated correctly");
            TestUtil.logMsg((String)"Check relationship accessor method of BeanEJB");
            TestUtil.logMsg((String)("getA2() = " + this.getA2()));
            if (this.getA2() == null) {
                TestUtil.logMsg((String)"Relationship accessor method of BeanEJB returns null");
                return true;
            }
            TestUtil.logErr((String)"Relationship accessor method of BeanEJB returns not null");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test3() {
        TestUtil.logMsg((String)"starting test3");
        ALocal aTwo = this.getA2();
        try {
            BLocal bOne = this.getB1();
            TestUtil.logMsg((String)("aTwo = " + aTwo));
            TestUtil.logMsg((String)"Delete entitybean object A2");
            aTwo.remove();
            TestUtil.logMsg((String)"Assigning A2 to B1 must throw IllegalArgumentException");
            Collection c = bOne.getA();
            c.add(aTwo);
            TestUtil.logErr((String)"Did not get expected IllegalArgumentException");
            return false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
        try {
            TestUtil.logMsg((String)"Assigning aTwo to BeanEJB must throw IllegalArgumentException");
            this.setA2(aTwo);
            TestUtil.logErr((String)"Did not get expected IllegalArgumentException");
            return false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
    }

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    a1.setB(null);
                    b1.setA(null);
                    break;
                }
                case 2: {
                    Collection c = a1.getB();
                    c.add(b1);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, ADVC aTwo, ADVC aThree, ADVC aFour, BDVC bOne, BDVC bTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, ADVC aTwo, ADVC aThree, ADVC aFour, BDVC bOne, BDVC bTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            ALocal a2 = this.createALocal(aTwo.getId(), aTwo.getName(), aTwo.getValue());
            this.setA2(a2);
            ALocal a3 = this.createALocal(aThree.getId(), aThree.getName(), aThree.getValue());
            this.setA3(a3);
            ALocal a4 = this.createALocal(aFour.getId(), aFour.getName(), aFour.getValue());
            this.setA4(a4);
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            this.setB2(b2);
            BLocal b3 = this.createBLocal(bThree.getId(), bThree.getName(), bThree.getValue());
            this.setB3(b3);
            BLocal b4 = this.createBLocal(bFour.getId(), bFour.getName(), bFour.getValue());
            this.setB4(b4);
            Collection c = a1.getB();
            c.add(b1);
            c.add(b2);
            c = b1.getA();
            c.add(a2);
            c = a2.getB();
            c.add(b2);
            c.add(b3);
            c = b2.getA();
            c.add(a3);
            c = a3.getB();
            c.add(b3);
            c.add(b4);
            c = b3.getA();
            c.add(a4);
            c = a4.getB();
            c.add(b4);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object a1 ...");
            this.getA1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object a2 ...");
            this.getA2().remove();
        }
        if (this.getA3() != null) {
            TestUtil.logMsg((String)"deleting entitybean object a3 ...");
            this.getA3().remove();
        }
        if (this.getA4() != null) {
            TestUtil.logMsg((String)"deleting entitybean object a4 ...");
            this.getA4().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object b1 ...");
            this.getB1().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object b2 ...");
            this.getB2().remove();
        }
        if (this.getB3() != null) {
            TestUtil.logMsg((String)"deleting entitybean object b3 ...");
            this.getB3().remove();
        }
        if (this.getB4() != null) {
            TestUtil.logMsg((String)"deleting entitybean object b4 ...");
            this.getB4().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

