/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.nonreentranttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.nonreentranttest.LoopBack;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.nonreentranttest.LoopBackHome;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.nonreentranttest.TestBean;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.rmi.RemoteException;
import java.util.Properties;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private CoffeeDAO dao = null;
    private EntityContext ectx = null;
    private static final String loopBackBean = "java:comp/env/ejb/LoopBackBean";

    public Integer ejbCreate(Properties p, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logMsg((String)"Get DB Connection");
            this.dao.startSession();
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void sleep(int n) {
        long t2;
        TestUtil.logTrace((String)"sleep");
        long t1 = System.currentTimeMillis();
        while ((t2 = System.currentTimeMillis()) < t1 + (long)n) {
        }
    }

    public boolean loopBackSameBean() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBean");
        TestUtil.logMsg((String)"Perform loopback test");
        try {
            TestUtil.logMsg((String)"getPrimaryKey() object");
            Object o = this.ectx.getPrimaryKey();
            TestUtil.logMsg((String)"getEJBObject() reference");
            TestBean ref = (TestBean)this.ectx.getEJBObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logErr((String)"No exception occurred during loopback call");
            pass = false;
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)("Caught RemoteException as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBean(Properties p) {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBean");
        try {
            TestUtil.logMsg((String)"Lookup home interface for EJB: java:comp/env/ejb/LoopBackBean");
            LoopBackHome beanHome = (LoopBackHome)this.lookup(loopBackBean, LoopBackHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            LoopBack beanRef = beanHome.create();
            TestUtil.logMsg((String)"Initialize remote logging");
            beanRef.initLogging(p);
            TestUtil.logMsg((String)"Set bean reference");
            beanRef.setBeanRef((TestBean)this.ectx.getEJBObject());
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = beanRef.loopBackTest();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private Object lookup(String s, Class c) {
        TSNamingContext nctx = null;
        try {
            TestUtil.logMsg((String)"obtain naming context");
            nctx = new TSNamingContext();
            if (c != null) {
                return nctx.lookup(s, c);
            }
            return nctx.lookup(s);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("lookup failed: " + e);
        }
    }
}

