/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsongeneratorfactorytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonGeneratorFactoryTest1() throws EETest.Fault {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
            this.logMsg("--------------------------------------------------------");
            this.logMsg("TEST CASE [JsonGeneratorFactory.createGenerator(Writer)]");
            this.logMsg("--------------------------------------------------------");
            this.logMsg("Create 1st JsonGenerator using JsonGeneratorFactory");
            StringWriter sWriter1 = new StringWriter();
            generator1 = generatorFactory.createGenerator((Writer)sWriter1);
            if (generator1 == null) {
                this.logErr("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            this.logMsg("sWriter1=" + sWriter1.toString());
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace(sWriter1.toString());
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonGenerator using JsonGeneratorFactory");
            StringWriter sWriter2 = new StringWriter();
            generator2 = generatorFactory.createGenerator((Writer)sWriter2);
            if (generator2 == null) {
                this.logErr("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            this.logMsg("sWriter2=" + sWriter2.toString());
            expString = "[]";
            actString = JSONP_Util.removeWhitespace(sWriter2.toString());
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorFactoryTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorFactoryTest1 Failed");
        }
    }

    public void jsonGeneratorFactoryTest2() throws EETest.Fault {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------------------------------");
            this.logMsg("TEST CASE [JsonGeneratorFactory.createGenerator(OutputStream, Charset)]");
            this.logMsg("-----------------------------------------------------------------------");
            this.logMsg("Create 1st JsonGenerator using JsonGeneratorFactory with UTF-8 encoding");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            generator1 = generatorFactory.createGenerator((OutputStream)baos1, JSONP_Util.UTF_8);
            if (generator1 == null) {
                this.logErr("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            this.logMsg("baos1=" + baos1.toString("UTF-8"));
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace(baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonGenerator using JsonGeneratorFactory with UTF-16BE encoding");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            generator2 = generatorFactory.createGenerator((OutputStream)baos2, JSONP_Util.UTF_16BE);
            if (generator2 == null) {
                this.logErr("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            this.logMsg("baos2=" + baos2.toString("UTF-16BE"));
            expString = "[]";
            actString = JSONP_Util.removeWhitespace(baos2.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorFactoryTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorFactoryTest2 Failed");
        }
    }

    public void jsonGeneratorFactoryTest3() throws EETest.Fault {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------------------------");
            this.logMsg("TEST CASE [JsonGeneratorFactory.createGenerator(OutputStream os)]");
            this.logMsg("-----------------------------------------------------------------");
            this.logMsg("Create 1st JsonGenerator using JsonGeneratorFactory");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            generator1 = generatorFactory.createGenerator((OutputStream)baos1);
            if (generator1 == null) {
                this.logErr("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            this.logMsg("baos1=" + baos1.toString("UTF-8"));
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace(baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonGenerator using JsonGeneratorFactory");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            generator2 = generatorFactory.createGenerator((OutputStream)baos2);
            if (generator2 == null) {
                this.logErr("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            this.logMsg("baos2=" + baos2.toString("UTF-8"));
            expString = "[]";
            actString = JSONP_Util.removeWhitespace(baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorFactoryTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorFactoryTest3 Failed");
        }
    }

    public void jsonGeneratorFactoryTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("----------------------------------------------");
            this.logMsg("Test scenario1: no supported provider property");
            this.logMsg("----------------------------------------------");
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with EMPTY config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig());
            Map config = generatorFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------");
            this.logMsg("Test scenario2: supported provider property");
            this.logMsg("-------------------------------------------");
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            generatorFactory = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig());
            config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------------------------");
            this.logMsg("Test scenario3: supported and non supported provider property");
            this.logMsg("-------------------------------------------------------------");
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with all config");
            generatorFactory = Json.createGeneratorFactory(JSONP_Util.getAllConfig());
            config = generatorFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorFactoryTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorFactoryTest4 Failed");
        }
    }
}

