/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.Frame;
import jdk.incubator.http.internal.websocket.RawChannel;

abstract class OutgoingMessage {
    private static final SecureRandom maskingKeys = new SecureRandom();
    protected ByteBuffer[] frame;
    protected int offset;

    OutgoingMessage() {
    }

    protected void contextualize(Context context) {
        if (context.isCloseSent()) {
            throw new IllegalStateException("Close sent");
        }
    }

    protected boolean sendTo(RawChannel rawChannel) throws IOException {
        while ((this.offset = this.nextUnwrittenIndex()) != -1) {
            long l = rawChannel.write(this.frame, this.offset, this.frame.length - this.offset);
            if (l != 0L) continue;
            return false;
        }
        return true;
    }

    private int nextUnwrittenIndex() {
        for (int i = this.offset; i < this.frame.length; ++i) {
            if (!this.frame[i].hasRemaining()) continue;
            return i;
        }
        return -1;
    }

    private static ByteBuffer[] getControlMessageBuffers(Frame.Opcode opcode, ByteBuffer byteBuffer) {
        assert (opcode.isControl()) : opcode;
        int n = byteBuffer.remaining();
        if (n > 125) {
            throw new IllegalArgumentException("Long message: " + n);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(14 + n);
        int n2 = maskingKeys.nextInt();
        new Frame.HeaderWriter().fin(true).opcode(opcode).payloadLen(n).mask(n2).write(byteBuffer2);
        Frame.Masker.transferMasking(byteBuffer, byteBuffer2, n2);
        byteBuffer2.flip();
        return new ByteBuffer[]{byteBuffer2};
    }

    private static ByteBuffer[] getDataMessageBuffers(Frame.Opcode opcode, boolean bl, boolean bl2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        assert (!opcode.isControl() && opcode != Frame.Opcode.CONTINUATION) : opcode;
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(14);
        int n = maskingKeys.nextInt();
        new Frame.HeaderWriter().fin(bl2).opcode(bl ? opcode : Frame.Opcode.CONTINUATION).payloadLen(byteBuffer2.remaining()).mask(n).write(byteBuffer3);
        byteBuffer3.flip();
        Frame.Masker.transferMasking(byteBuffer, byteBuffer2, n);
        byteBuffer2.flip();
        return new ByteBuffer[]{byteBuffer3, byteBuffer2};
    }

    public static class Context {
        boolean previousLast = true;
        boolean previousBinary;
        boolean previousText;
        boolean closeSent;

        private boolean isPreviousText() {
            return this.previousText;
        }

        private void setPreviousText(boolean bl) {
            this.previousText = bl;
        }

        private boolean isPreviousBinary() {
            return this.previousBinary;
        }

        private void setPreviousBinary(boolean bl) {
            this.previousBinary = bl;
        }

        private boolean isPreviousLast() {
            return this.previousLast;
        }

        private void setPreviousLast(boolean bl) {
            this.previousLast = bl;
        }

        private boolean isCloseSent() {
            return this.closeSent;
        }

        private void setCloseSent() {
            this.closeSent = true;
        }
    }

    static final class Close
    extends OutgoingMessage {
        Close() {
            this.frame = OutgoingMessage.getControlMessageBuffers(Frame.Opcode.CLOSE, Utils.EMPTY_BYTEBUFFER);
        }

        Close(int n, CharSequence charSequence) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(125).putChar((char)n);
            CoderResult coderResult = StandardCharsets.UTF_8.newEncoder().encode(CharBuffer.wrap(charSequence), byteBuffer, true);
            if (coderResult.isOverflow()) {
                throw new IllegalArgumentException("Long reason");
            }
            if (coderResult.isError()) {
                try {
                    coderResult.throwException();
                }
                catch (CharacterCodingException characterCodingException) {
                    throw new IllegalArgumentException("Malformed UTF-8 reason", characterCodingException);
                }
            }
            byteBuffer.flip();
            this.frame = OutgoingMessage.getControlMessageBuffers(Frame.Opcode.CLOSE, byteBuffer);
        }

        @Override
        protected void contextualize(Context context) {
            super.contextualize(context);
            context.setCloseSent();
        }
    }

    static final class Pong
    extends OutgoingMessage {
        Pong(ByteBuffer byteBuffer) {
            this.frame = OutgoingMessage.getControlMessageBuffers(Frame.Opcode.PONG, byteBuffer);
        }
    }

    static final class Ping
    extends OutgoingMessage {
        Ping(ByteBuffer byteBuffer) {
            this.frame = OutgoingMessage.getControlMessageBuffers(Frame.Opcode.PING, byteBuffer);
        }
    }

    static final class Binary
    extends OutgoingMessage {
        private final ByteBuffer payload;
        private final boolean isLast;

        Binary(ByteBuffer byteBuffer, boolean bl) {
            this.payload = Objects.requireNonNull(byteBuffer);
            this.isLast = bl;
        }

        @Override
        protected void contextualize(Context context) {
            super.contextualize(context);
            if (context.isPreviousText() && !context.isPreviousLast()) {
                throw new IllegalStateException("Unexpected binary message");
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.payload.remaining());
            this.frame = OutgoingMessage.getDataMessageBuffers(Frame.Opcode.BINARY, context.isPreviousLast(), this.isLast, this.payload, byteBuffer);
            context.setPreviousText(false);
            context.setPreviousBinary(true);
            context.setPreviousLast(this.isLast);
        }
    }

    static final class Text
    extends OutgoingMessage {
        private final ByteBuffer payload;
        private final boolean isLast;

        Text(CharSequence charSequence, boolean bl) {
            CharsetEncoder charsetEncoder = StandardCharsets.UTF_8.newEncoder();
            try {
                this.payload = charsetEncoder.encode(CharBuffer.wrap(charSequence));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalArgumentException("Malformed UTF-8 text message");
            }
            this.isLast = bl;
        }

        @Override
        protected void contextualize(Context context) {
            super.contextualize(context);
            if (context.isPreviousBinary() && !context.isPreviousLast()) {
                throw new IllegalStateException("Unexpected text message");
            }
            this.frame = OutgoingMessage.getDataMessageBuffers(Frame.Opcode.TEXT, context.isPreviousLast(), this.isLast, this.payload, this.payload);
            context.setPreviousBinary(false);
            context.setPreviousText(true);
            context.setPreviousLast(this.isLast);
        }
    }
}

