/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.context;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.context.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.full.context.MyContextual;
import org.jboss.cdi.tck.tests.full.context.MySessionBean;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ContextDestroysBeansTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ContextDestroysBeansTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="p"), @SpecAssertion(section="normal_scope", id="d")})
    public void testContextDestroysBeansWhenDestroyed() {
        MyContextual bean = AfterBeanDiscoveryObserver.getBean();
        bean.setShouldReturnNullInstances(false);
        Context sessionContext = this.getCurrentManager().getContext(SessionScoped.class);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)bean);
        MySessionBean instance = (MySessionBean)sessionContext.get((Contextual)bean, creationalContext);
        instance.ping();
        assert (instance != null);
        assert (bean.isCreateCalled());
        this.destroyContext(sessionContext);
        assert (bean.isDestroyCalled());
    }
}

