/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RetryListenerTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testRetryReadListener() throws Exception {
        String METHOD = "testRetryReadListener";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=8,13,22<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: job_retry_listener_test.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testRetryProcessListener() throws Exception {
        String METHOD = "testRetryProcessListener";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=8,13,22<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: job_retry_listener_test.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testRetryWriteListener() throws Exception {
        String METHOD = "testRetryWriteListener";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=8,13,22<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: job_retry_listener_test.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

