/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.reusable.MyBatchletImpl;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentUserData;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.junit.BeforeClass;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StepExecutionTests {
    private static final Logger logger = Logger.getLogger(StepExecutionTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @AfterClass
    public static void cleanup() throws Exception {
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str + "<p>"));
    }

    @Test
    @org.junit.Test
    public void testOneStepExecutionStatus() throws Exception {
        String METHOD = "testOneStepExecutionStatus";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                Reporter.log((String)("Step status = " + step.getBatchStatus() + "<p>"));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
            }
            Reporter.log((String)("Job execution status = " + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testFourStepExecutionStatus() throws Exception {
        String METHOD = "testFourStepExecutionStatus";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            HashSet<Long> stepExecutionsSeen = new HashSet<Long>();
            for (StepExecution step : steps) {
                this.showStepState(step);
                Reporter.log((String)("Step status = " + step.getBatchStatus() + "<p>"));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
                AssertionUtils.assertWithMessage("New StepExecution id", !stepExecutionsSeen.contains(step.getStepExecutionId()));
                stepExecutionsSeen.add(step.getStepExecutionId());
            }
            Reporter.log((String)("Job execution status = " + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testFailedStepExecutionStatus() throws Exception {
        String METHOD = "testFailedStepExecutionStatus";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_failElement.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
            }
            Reporter.log((String)("Job execution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)("Job execution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("TEST_FAIL", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStoppedStepExecutionStatus() throws Exception {
        String METHOD = "testStoppedStepExecutionStatus";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_stopElement.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_stopElement");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
            }
            Reporter.log((String)("Job execution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPersistedStepData() throws Exception {
        String METHOD = "testPersistedStepData";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_persistedData.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"force.failure=true<p>");
            jobParameters.setProperty("force.failure", "true");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_persistedData", jobParameters);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            StepExecution stepExec = steps.get(0);
            AssertionUtils.assertObjEquals(1, steps.size());
            Reporter.log((String)("execution #1 StepExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, stepExec.getBatchStatus());
            AssertionUtils.assertObjEquals(4, ((MyPersistentUserData)stepExec.getPersistentUserData()).getData());
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + jobExec.getExecutionId() + "<p>"));
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), jobParameters);
            steps = jobOp.getStepExecutions(restartedJobExec.getExecutionId());
            stepExec = steps.get(0);
            Reporter.log((String)("execution #1 StepExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, stepExec.getBatchStatus());
            AssertionUtils.assertObjEquals(5, ((MyPersistentUserData)stepExec.getPersistentUserData()).getData());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStepExecutionExitStatus() throws Exception {
        String METHOD = "testStepExecutionExitStatus";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_failElement.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            StepExecution step = steps.get(0);
            this.showStepState(step);
            AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
            AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            Reporter.log((String)("Job batch status =" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("Job exit status =" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "TEST_FAIL", jobExec.getExitStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStepInFlowStepExecution() throws Exception {
        String METHOD = "testStepInFlowStepExecution";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_failElement.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("flow_transition_to_step");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
                AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            }
            Reporter.log((String)("Job batch status =" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("Job exit status =" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "flow1step1, flow1step2, flow1step3, step1", jobExec.getExitStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStepInFlowInSplitStepExecution() throws Exception {
        String METHOD = "testStepInFlowInSplitStepExecution";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: split_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("split_batchlet_4steps");
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "COMPLETED", jobExec.getExitStatus());
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
                AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            }
            Reporter.log((String)("Job batch status =" + jobExec.getBatchStatus() + "<p>"));
            Reporter.log((String)("Job exit status =" + jobExec.getExitStatus() + "<p>"));
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        Reporter.log((String)"---------------------------<p>");
        Reporter.log((String)("getStepName(): " + step.getStepName() + " - "));
        Reporter.log((String)("getStepExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            Reporter.log((String)(metrics[i].getType() + ": " + metrics[i].getValue() + " - "));
        }
        Reporter.log((String)("getStartTime(): " + step.getStartTime() + " - "));
        Reporter.log((String)("getEndTime(): " + step.getEndTime() + " - "));
        Reporter.log((String)("getBatchStatus(): " + step.getBatchStatus() + " - "));
        Reporter.log((String)("getExitStatus(): " + step.getExitStatus() + "<p>"));
        Reporter.log((String)"---------------------------<p>");
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

