/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.query.AbstractIntentQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.genericunit.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceinModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentDocumentQuery
extends AbstractIntentQuery {
    private IntentDocument intentDocument;

    public IntentDocumentQuery(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    public IntentDocument getOrCreateIntentDocument() {
        if (this.intentDocument == null) {
            final Resource resource = this.repositoryAdapter.getResource("/INTENT/IntentDocument");
            if (resource.getContents().isEmpty()) {
                this.repositoryAdapter.execute(new IntentCommand(){

                    public void execute() {
                        resource.getContents().add((Object)IntentDocumentFactory.eINSTANCE.createIntentDocument());
                    }
                });
            }
            this.intentDocument = (IntentDocument)resource.getContents().get(0);
        }
        return this.intentDocument;
    }

    public IntentStructuredElement getElementAtLevel(String level) throws NumberFormatException {
        IntentStructuredElement elementAtLevel = null;
        IntentIndexEntry indexEntry = new IndexQuery(this.repositoryAdapter).getIndexEntryAtLevel(level);
        if (indexEntry != null && indexEntry.getReferencedElement() instanceof IntentStructuredElement) {
            elementAtLevel = (IntentStructuredElement)indexEntry.getReferencedElement();
        }
        return elementAtLevel;
    }

    public Collection<IntentReferenceInstruction> getAllIntentReferenceInstructions() {
        LinkedHashSet intentReferences = Sets.newLinkedHashSet();
        for (DescriptionUnit descriptionUnit : this.getAllDescriptionUnits()) {
            intentReferences.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)descriptionUnit.getInstructions(), IntentReferenceInstruction.class)));
        }
        for (ModelingUnit modelingUnit : this.getAllModelingUnits()) {
            intentReferences.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)modelingUnit.getInstructions(), IntentReferenceinModelingUnit.class)));
        }
        return intentReferences;
    }

    public Collection<DescriptionUnit> getAllDescriptionUnits() {
        LinkedHashSet descriptionUnits = Sets.newLinkedHashSet();
        for (IntentChapter chapter : this.getOrCreateIntentDocument().getChapters()) {
            descriptionUnits.addAll(this.getAllDescriptionUnits((IntentSubSectionContainer)chapter));
        }
        return descriptionUnits;
    }

    public Collection<ModelingUnit> getAllModelingUnits() {
        LinkedHashSet modelingUnits = Sets.newLinkedHashSet();
        for (IntentChapter chapter : this.getOrCreateIntentDocument().getChapters()) {
            modelingUnits.addAll(this.getAllModelingUnits((IntentSubSectionContainer)chapter));
        }
        return modelingUnits;
    }

    public Collection<ModelingUnit> getAllModelingUnits(IntentSubSectionContainer intentElement) {
        LinkedHashSet modelingUnits = Sets.newLinkedHashSet();
        if (intentElement instanceof IntentSection) {
            modelingUnits.addAll(((IntentSection)intentElement).getModelingUnits());
        }
        for (IntentSection subSection : intentElement.getSubSections()) {
            modelingUnits.addAll(this.getAllModelingUnits((IntentSubSectionContainer)subSection));
        }
        return modelingUnits;
    }

    public Collection<DescriptionUnit> getAllDescriptionUnits(IntentSubSectionContainer intentElement) {
        LinkedHashSet descriptionUnits = Sets.newLinkedHashSet();
        descriptionUnits.addAll(intentElement.getDescriptionUnits());
        for (IntentSection subSection : intentElement.getSubSections()) {
            descriptionUnits.addAll(this.getAllDescriptionUnits((IntentSubSectionContainer)subSection));
        }
        return descriptionUnits;
    }

    public Map<String, IntentStructuredElement> getAllIdentifiedElements() {
        HashMap<String, IntentStructuredElement> res = new HashMap<String, IntentStructuredElement>();
        for (IntentChapter chapter : this.getOrCreateIntentDocument().getChapters()) {
            String chapterId = this.getID((IntentStructuredElement)chapter);
            if (chapterId != null) {
                res.put(chapterId, (IntentStructuredElement)chapter);
            }
            res.putAll(this.getAllIdentifiedElements((IntentSubSectionContainer)chapter));
        }
        return res;
    }

    private Map<String, IntentStructuredElement> getAllIdentifiedElements(IntentSubSectionContainer root) {
        HashMap<String, IntentStructuredElement> res = new HashMap<String, IntentStructuredElement>();
        for (IntentSection section : root.getSubSections()) {
            String sectionId = this.getID((IntentStructuredElement)section);
            if (sectionId != null) {
                res.put(sectionId, (IntentStructuredElement)section);
            }
            res.putAll(this.getAllIdentifiedElements((IntentSubSectionContainer)section));
        }
        return res;
    }

    private String getID(IntentStructuredElement element) {
        if (element.getTitle() != null && element.getTitle().getContent() != null && !element.getTitle().getContent().isEmpty()) {
            return ((Text)element.getTitle().getContent().get(0)).getData().replaceAll(" ", "");
        }
        return null;
    }
}

