/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.uri.contribution;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.collab.common.internal.uri.contribution.IntentResourceInitializerDescriptor;
import org.eclipse.mylyn.docs.intent.collab.common.uri.IIntentResourceInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentResourceInitializerRegistry {
    private static final Map<IIntentResourceInitializer, Collection<IntentResourceInitializerDescriptor>> EXTENSIONS = Maps.newHashMap();

    private IntentResourceInitializerRegistry() {
    }

    public static void addExtension(IntentResourceInitializerDescriptor extension) {
        IIntentResourceInitializer synchronizerExtension = extension.getIntentResourceInitializer();
        if (EXTENSIONS.get(synchronizerExtension) == null) {
            EXTENSIONS.put(synchronizerExtension, new HashSet());
        }
        EXTENSIONS.get(synchronizerExtension).add(extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<IntentResourceInitializerDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<IntentResourceInitializerDescriptor> extensions : EXTENSIONS.values()) {
            registeredExtensions.addAll(extensions);
        }
        return registeredExtensions;
    }

    public static Collection<IIntentResourceInitializer> getIntentResourceInitializers(String fileExtension) {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<IntentResourceInitializerDescriptor> extensions : EXTENSIONS.values()) {
            for (IntentResourceInitializerDescriptor descriptor : extensions) {
                if (!fileExtension.equals(descriptor.getFileExtension())) continue;
                registeredExtensions.add(descriptor.getIntentResourceInitializer());
            }
        }
        return registeredExtensions;
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentResourceInitializerDescriptor extension : IntentResourceInitializerRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.get(extension).clear();
        }
    }
}

