/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution.IntentRepositoryManagerContributionRegistry;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public final class IntentRepositoryManagerImpl
implements IntentRepositoryManager {
    private Map<String, Repository> repositoriesByProject = new HashMap<String, Repository>();
    private boolean lock;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Repository getRepository(String identifier) throws RepositoryConnectionException, CoreException {
        Assert.isTrue((!this.lock ? 1 : 0) != 0);
        Repository repository = null;
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        this.lock = true;
        try {
            block8: {
                Iterator<IntentRepositoryManagerContribution> iterator;
                block7: {
                    if (this.repositoriesByProject.get(normalizedIdentifier) != null) {
                        repository = this.repositoriesByProject.get(normalizedIdentifier);
                    }
                    iterator = IntentRepositoryManagerContributionRegistry.getRepositoryManagerContributions().iterator();
                    if (!true) break block7;
                    if (!iterator.hasNext()) return repository;
                    if (repository != null) break block8;
                }
                do {
                    IntentRepositoryManagerContribution repositoryManagerContribution;
                    if ((repositoryManagerContribution = iterator.next()).canCreateRepository(normalizedIdentifier) && (repository = repositoryManagerContribution.createRepository(normalizedIdentifier)) != null) {
                        this.repositoriesByProject.put(normalizedIdentifier, repository);
                    }
                    if (!iterator.hasNext()) return repository;
                } while (repository == null);
            }
            return repository;
        }
        finally {
            this.lock = false;
        }
    }

    public synchronized boolean isManagedProject(String identifier) {
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        return this.repositoriesByProject.get(normalizedIdentifier) != null;
    }

    public synchronized void deleteRepository(String identifier) {
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        this.repositoriesByProject.remove(normalizedIdentifier);
    }

    private String normalizeIdentifier(String identifier) {
        String normalizedIdentifier = identifier;
        if (identifier.startsWith("platform:/resource")) {
            normalizedIdentifier = identifier.toString().replaceFirst("platform:/resource/", "");
            normalizedIdentifier = normalizedIdentifier.split("/")[0];
        }
        return normalizedIdentifier;
    }
}

