/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class IntentEditorActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.docs.intent.client.ui";
    public static final String EDITOR_ID = "org.eclipse.mylyn.docs.intent.client.ui.IntentEditor";
    private static IntentEditorActivator plugin;
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = this.imageMap.get(path);
        if (result == null && (descriptor = this.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            this.imageMap.put(path, result);
        }
        return result;
    }

    private ImageDescriptor getImageDescriptor(String imagePath) {
        URL fullPathString = BundleUtility.find((Bundle)this.getBundle(), (String)imagePath);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(imagePath);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        plugin = null;
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap.clear();
    }

    public static IntentEditorActivator getDefault() {
        return plugin;
    }
}

