/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.retro;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtension;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtensionRegistry;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.AbstractGeneratedElementListener;
import org.eclipse.mylyn.docs.intent.retro.ProtocolFactory;
import org.eclipse.mylyn.docs.intent.retro.RetroGeneratedElementListenerDeltaVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroGeneratedElementListener
extends AbstractGeneratedElementListener
implements ISynchronizerExtension,
IResourceChangeListener {
    public static final String RETRO_SCHEME = "retro";
    protected Map<URI, Set<SynchronizerRepositoryClient>> uriToSynchronizers = Maps.newLinkedHashMap();
    private ArrayList<URI> resourcesToIgnore;

    public RetroGeneratedElementListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        this.resourcesToIgnore = new ArrayList();
    }

    public static RetroGeneratedElementListener getInstance() {
        Iterable synchronizerExtensions = Iterables.filter((Iterable)ISynchronizerExtensionRegistry.getSynchronizerExtensions((String)RETRO_SCHEME), RetroGeneratedElementListener.class);
        if (synchronizerExtensions.iterator().hasNext()) {
            return (RetroGeneratedElementListener)((Object)synchronizerExtensions.iterator().next());
        }
        return null;
    }

    public void addListenedElements(SynchronizerRepositoryClient synchronizer, Set<URI> listenedElementsURIs) {
        for (URI uri : listenedElementsURIs) {
            String projectName = ProtocolFactory.extractProjectName(uri);
            URI simplifiedURI = URI.createURI((String)("retro:/" + projectName));
            if (!this.uriToSynchronizers.containsKey(simplifiedURI)) {
                this.uriToSynchronizers.put(simplifiedURI, Sets.newLinkedHashSet());
            }
            this.uriToSynchronizers.get(simplifiedURI).add(synchronizer);
        }
    }

    public void removeListenedElements(SynchronizerRepositoryClient synchronizer, Set<URI> listenedElementsURIs) {
        for (URI uri : listenedElementsURIs) {
            String projectName = ProtocolFactory.extractProjectName(uri);
            URI simplifiedURI = URI.createURI((String)("retro:/" + projectName));
            this.uriToSynchronizers.remove(simplifiedURI);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta;
        if (event.getType() == 1 && (rootDelta = event.getDelta()) != null) {
            this.analyseWorkspaceDelta(rootDelta);
        }
    }

    private void analyseWorkspaceDelta(IResourceDelta repositoryDelta) {
        RetroGeneratedElementListenerDeltaVisitor visitor = new RetroGeneratedElementListenerDeltaVisitor(this.listenedElementsURIs);
        try {
            repositoryDelta.accept((IResourceDeltaVisitor)visitor);
            ArrayList<URI> changedResources = new ArrayList<URI>();
            if (!visitor.getRemovedResources().isEmpty()) {
                changedResources.addAll(visitor.getRemovedResources());
            }
            for (URI changedResource : visitor.getChangedResources()) {
                if (!this.resourcesToIgnore.contains(changedResource)) {
                    changedResources.add(changedResource);
                    continue;
                }
                this.resourcesToIgnore.remove(changedResource);
            }
            this.treatChangedResources(changedResources);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void treatChangedResources(Collection<URI> changedResources) {
        LinkedHashSet synchronizersToNotify = Sets.newLinkedHashSet();
        for (URI uri : changedResources) {
            Set<SynchronizerRepositoryClient> listeningSynchronizers = this.uriToSynchronizers.get(uri);
            if (listeningSynchronizers != null) {
                synchronizersToNotify.addAll(listeningSynchronizers);
                continue;
            }
            System.err.println("arg");
        }
        for (SynchronizerRepositoryClient listeningSynchronizer : synchronizersToNotify) {
            listeningSynchronizer.handleChangeNotification(null);
        }
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }
}

