/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.utils.IntentEditorOpener;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;

public class OpenEditorAction
extends Action {
    protected TreeViewer viewer;
    private boolean forceNewEditor;

    public OpenEditorAction(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        IntentGenericElement element = this.getIndexEntryFromSelection();
        if (element != null && element.eResource() != null) {
            try {
                IntentEditorOpener.openIntentEditor((Repository)IntentRepositoryManager.INSTANCE.getRepository(this.findProjectForModelURI(element.eResource().getURI()).getName()), (EObject)element, (boolean)false, (EObject)element, (boolean)this.forceNewEditor);
            }
            catch (RepositoryConnectionException e) {
                IntentUiLogger.logError((Throwable)e);
            }
            catch (CoreException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
    }

    private IProject findProjectForModelURI(URI modelURI) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(modelURI.toPlatformString(true))).getProject();
    }

    private IntentGenericElement getIndexEntryFromSelection() {
        TreeSelection selectedElements;
        Object firstElement;
        IntentGenericElement element = null;
        if (this.viewer.getSelection() instanceof TreeSelection && (firstElement = (selectedElements = (TreeSelection)this.viewer.getSelection()).getFirstElement()) instanceof IntentIndexEntry) {
            element = ((IntentIndexEntry)firstElement).getReferencedElement();
        }
        return element;
    }

    public String getText() {
        return "Open in Intent editor";
    }

    public void setForceNewEditor(boolean forceNewEditor) {
        this.forceNewEditor = forceNewEditor;
    }
}

