/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.adapters;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.ide.notification.WorkspaceTypeListener;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceSession;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceAdapter
implements RepositoryAdapter {
    private static final long TIME_TO_WAIT_BEFORE_CHECKING_SESSIONDELTA = 5L;
    private static Map<String, Object> saveOptions;
    private static Map<String, Object> loadOptions;
    private WorkspaceRepository repository;
    private boolean isReadOnlyContext;
    private Map<Notificator, Set<WorkspaceTypeListener>> notificatorToListener;
    private RepositoryStructurer documentStructurer;
    private boolean sendSessionWarningBeforeSaving;
    private List<String> resourcesToIgnorePaths;
    private Predicate<Resource> unloadableResourcePredicate = new Predicate<Resource>(){

        public boolean apply(Resource input) {
            return false;
        }
    };

    public WorkspaceAdapter(WorkspaceRepository repository) {
        this.repository = repository;
        this.isReadOnlyContext = false;
        this.notificatorToListener = new HashMap<Notificator, Set<WorkspaceTypeListener>>();
        this.resourcesToIgnorePaths = new ArrayList<String>();
    }

    public static Map<String, Object> getSaveOptions() {
        if (saveOptions == null) {
            saveOptions = new HashMap<String, Object>();
            saveOptions.put("FORMATTED", false);
        }
        return saveOptions;
    }

    public static Map<String, Object> getLoadOptions() {
        if (loadOptions == null) {
            loadOptions = new HashMap<String, Object>();
            loadOptions.put("DEFER_IDREF_RESOLUTION", true);
            loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        }
        return loadOptions;
    }

    public Object openSaveContext() {
        this.isReadOnlyContext = false;
        return null;
    }

    public Object openReadOnlyContext() {
        this.isReadOnlyContext = true;
        return null;
    }

    public void save() throws ReadOnlyException, SaveException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot save with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        if (this.documentStructurer != null) {
            this.documentStructurer.structure((RepositoryAdapter)this);
        }
        ArrayList resources = Lists.newArrayList((Iterable)this.repository.getResourceSet().getResources());
        try {
            for (Resource resource : resources) {
                try {
                    if (resource.isModified() || resource.getContents().isEmpty()) {
                        while (((WorkspaceSession)this.repository.getOrCreateSession()).isProcessingDelta()) {
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException e) {
                                throw new SaveException(e.getMessage());
                            }
                        }
                        this.treatSessionWarning(resource);
                        resource.save(WorkspaceAdapter.getSaveOptions());
                        resource.setTrackingModification(true);
                        if (!resource.getContents().isEmpty()) continue;
                        resource.delete(null);
                        continue;
                    }
                    if (((EObject)resource.getContents().iterator().next()).eContainer() == null || ((EObject)resource.getContents().iterator().next()).eContainer().eResource() != null) continue;
                    resource.delete(null);
                }
                catch (IOException e) {
                    throw new SaveException(e.getMessage());
                }
                catch (RepositoryConnectionException e) {
                    throw new SaveException(e.getMessage());
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.save();
        }
    }

    private void treatSessionWarning(Resource resource) throws RepositoryConnectionException {
        if (this.sendSessionWarningBeforeSaving) {
            ((WorkspaceSession)this.repository.getOrCreateSession()).addSavedResource(resource);
        } else if (this.isInResourcesToIgnorePath(resource)) {
            ((WorkspaceSession)this.repository.getOrCreateSession()).addSavedResource(resource);
        }
    }

    public boolean isInResourcesToIgnorePath(Resource resource) {
        boolean isInResourceToIgnorePath = false;
        Iterator<String> iterator = this.resourcesToIgnorePaths.iterator();
        while (iterator.hasNext() && !isInResourceToIgnorePath) {
            String resourceToIgnorePath = iterator.next();
            isInResourceToIgnorePath = this.repository.isIncludedInPath(resourceToIgnorePath, resource);
        }
        return isInResourceToIgnorePath;
    }

    public void undo() throws ReadOnlyException {
        CommandStack commandStack = this.repository.getEditingDomain().getCommandStack();
        if (commandStack != null) {
            commandStack.undo();
        }
    }

    public void setUnloadableResourcePredicate(Predicate<Resource> unloadableResourcePredicate) {
        this.unloadableResourcePredicate = unloadableResourcePredicate;
    }

    private boolean isUnloadableResource(Resource resource) {
        return this.unloadableResourcePredicate.apply((Object)resource);
    }

    public void closeContext() {
        this.isReadOnlyContext = false;
    }

    public void attachSessionListenerForTypes(Notificator typeNotificator, Set<EStructuralFeature> listenedTypes) {
        try {
            WorkspaceTypeListener typeListener = new WorkspaceTypeListener(typeNotificator, listenedTypes);
            if (this.notificatorToListener.get(typeNotificator) == null) {
                this.notificatorToListener.put(typeNotificator, new LinkedHashSet());
            }
            this.notificatorToListener.get(typeNotificator).add(typeListener);
            ((WorkspaceSession)this.repository.getOrCreateSession()).addListener(typeListener);
        }
        catch (RepositoryConnectionException repositoryConnectionException) {}
    }

    public void detachSessionListenerForTypes(Notificator typeNotificator) {
        try {
            for (WorkspaceTypeListener listenerToRemove : this.notificatorToListener.get(typeNotificator)) {
                ((WorkspaceSession)this.repository.getOrCreateSession()).removeListener(listenerToRemove);
            }
            this.notificatorToListener.remove(typeNotificator);
        }
        catch (RepositoryConnectionException repositoryConnectionException) {}
    }

    public void allowChangeSubscriptionPolicy() {
    }

    public Object getContext() {
        return null;
    }

    public Resource getResource(String repositoryRelativePath) {
        return this.getResource(repositoryRelativePath, true);
    }

    public Resource getResource(String repositoryRelativePath, boolean loadResourceOnDemand) {
        URI uri = this.repository.getURIMatchingPath(repositoryRelativePath);
        Resource resource = this.repository.getResourceSet().getResource(uri, loadResourceOnDemand);
        if (resource != null) {
            resource.setTrackingModification(true);
        }
        return resource;
    }

    public Resource getOrCreateResource(String path) throws ReadOnlyException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot create a resource with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        URI uri = this.repository.getURIMatchingPath(path);
        Resource returnedResource = this.repository.getResourceSet().getResource(uri, false);
        if (returnedResource == null) {
            returnedResource = this.repository.getResourceSet().createResource(uri);
        } else if (!returnedResource.isLoaded()) {
            try {
                returnedResource.load(WorkspaceAdapter.getLoadOptions());
            }
            catch (IOException iOException) {
                returnedResource = null;
            }
        }
        returnedResource.setTrackingModification(true);
        return returnedResource;
    }

    public EObject getElementWithID(Object uri) {
        if (uri instanceof URI) {
            EObject eObject = this.repository.getResourceSet().getEObject((URI)uri, true);
            return eObject;
        }
        return null;
    }

    public Object getIDFromElement(EObject element) {
        Assert.isNotNull((Object)element);
        URI uri = EcoreUtil.getURI((EObject)element);
        if (uri.toString().startsWith("#")) {
            return null;
        }
        return uri;
    }

    public void attachRepositoryStructurer(RepositoryStructurer structurer) {
        if (!(structurer instanceof RepositoryStructurer)) {
            throw new IllegalArgumentException("Cannot attach " + structurer.getClass().getName() + " to this adapter : should be " + RepositoryStructurer.class.getName());
        }
        this.documentStructurer = structurer;
    }

    public void setSendSessionWarningBeforeSaving(boolean notifySessionBeforeSaving) {
        this.sendSessionWarningBeforeSaving = notifySessionBeforeSaving;
    }

    public void setSendSessionWarningBeforeSaving(Collection<String> resourcesToIgnorePathList) {
        this.sendSessionWarningBeforeSaving = false;
        this.resourcesToIgnorePaths.clear();
        this.resourcesToIgnorePaths.addAll(resourcesToIgnorePathList);
    }

    public EObject reload(EObject elementToReload) {
        EObject resolve = elementToReload;
        if (elementToReload.eIsProxy()) {
            resolve = EcoreUtil.resolve((EObject)elementToReload, (ResourceSet)this.repository.getResourceSet());
        }
        for (Resource resource : this.repository.getResourceSet().getResources()) {
            resource.setTrackingModification(true);
        }
        return resolve;
    }

    public void execute(final IntentCommand command) {
        TransactionalEditingDomain editingDomain = this.repository.getEditingDomain();
        RecordingCommand recordingCommand = new RecordingCommand(editingDomain){

            protected void doExecute() {
                command.execute();
            }
        };
        CommandStack commandStack = editingDomain.getCommandStack();
        if (commandStack != null) {
            commandStack.execute((Command)recordingCommand);
        }
    }
}

