/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidValueException;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.CompilationStatusConverter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationInformationHolder;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.StringToEObjectMap;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedContributionHolder;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedReferenceHolder;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentCompilerInformationHolder {
    private static IntentCompilerInformationHolder currentInstance;
    private CompilationInformationHolder informationHolder = CompilerFactory.eINSTANCE.createCompilationInformationHolder();
    private List<String> currentImportedPackages;
    private CompilationStatusManager statusManager;

    private IntentCompilerInformationHolder() {
    }

    public static IntentCompilerInformationHolder getInstance() {
        if (currentInstance == null) {
            currentInstance = new IntentCompilerInformationHolder();
        }
        return currentInstance;
    }

    public void initialize() {
        this.informationHolder = CompilerFactory.eINSTANCE.createCompilationInformationHolder();
        if (this.statusManager == null) {
            this.statusManager = CompilerFactory.eINSTANCE.createCompilationStatusManager();
        } else {
            this.statusManager.getCompilationStatusList().clear();
            this.statusManager.getModelingUnitToStatusList().clear();
        }
    }

    public CompilationStatusManager getStatusManager() {
        return this.statusManager;
    }

    private void addCreatedElementsToCurrentList(UnitInstruction instruction, EObject createdElement) {
        if (createdElement != null) {
            this.getCurrentCreatedElements().add(createdElement);
            this.informationHolder.getCreatedElementsToInstructions().put((Object)createdElement, (Object)instruction);
        }
    }

    public UnitInstruction getInstructionByCreatedElement(EObject createdElement) {
        return (UnitInstruction)this.informationHolder.getCreatedElementsToInstructions().get((Object)createdElement);
    }

    public Set<UnitInstruction> getAllInstanciationsInstructions() {
        return Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)this.informationHolder.getCreatedElementsToInstructions().values(), (Predicate)new Predicate<UnitInstruction>(){

            public boolean apply(UnitInstruction instruction) {
                return instruction instanceof InstanciationInstruction && ((InstanciationInstruction)instruction).getName() != null;
            }
        }));
    }

    public Object getCreatedInstanceByName(EClassifier type, String name) {
        Object createdInstance = null;
        if (type != null) {
            return ((StringToEObjectMap)this.informationHolder.getTypeToNameToElementsMap().get((Object)type)).getNameToElement().get((Object)name);
        }
        for (EClassifier possibleType : this.informationHolder.getTypeToNameToElementsMap().keySet()) {
            createdInstance = ((StringToEObjectMap)this.informationHolder.getTypeToNameToElementsMap().get((Object)possibleType)).getNameToElement().get((Object)name);
            if (createdInstance != null) break;
        }
        return createdInstance;
    }

    public void addResource(ResourceDeclaration resource) {
        if (this.informationHolder.getResourceToContainedElements().get((Object)resource) == null) {
            this.informationHolder.getResourceToContainedElements().put((Object)resource, (Object)new BasicEList());
        }
    }

    public void addResourceToGeneratedElementMapping(ResourceDeclaration resource, EObject newContainedElement) {
        if (this.informationHolder.getResourceToContainedElements().get((Object)resource) == null) {
            this.informationHolder.getResourceToContainedElements().put((Object)resource, (Object)new BasicEList());
        }
        ((EList)this.informationHolder.getResourceToContainedElements().get((Object)resource)).add((Object)newContainedElement);
    }

    public Set<ResourceDeclaration> getDeclaredResources() {
        return this.informationHolder.getResourceToContainedElements().keySet();
    }

    public EList<EObject> getResourceContent(ResourceDeclaration resource) {
        return (EList)this.informationHolder.getResourceToContainedElements().get((Object)resource);
    }

    public void addUnresolvedReference(EObject generatedElement, UnresolvedReferenceHolder referenceHolder) {
        if (this.informationHolder.getElementToUnresolvedReferenceMap().get((Object)generatedElement) == null) {
            this.informationHolder.getElementToUnresolvedReferenceMap().put((Object)generatedElement, (Object)new BasicEList());
        }
        ((EList)this.informationHolder.getElementToUnresolvedReferenceMap().get((Object)generatedElement)).add((Object)referenceHolder);
    }

    public EList<UnresolvedReferenceHolder> getUnresolvedReferencesByGeneratedElement(EObject elementContainingUnresolvedReference) {
        EList unresolvedRefs = (EList)this.informationHolder.getElementToUnresolvedReferenceMap().get((Object)elementContainingUnresolvedReference);
        if (unresolvedRefs == null) {
            unresolvedRefs = new BasicEList();
        }
        return unresolvedRefs;
    }

    public void setCurrentImportedPackages(List<String> importedPackages) {
        this.currentImportedPackages = importedPackages;
    }

    public List<String> getCurrentImportedPackages() {
        return this.currentImportedPackages;
    }

    public List<EObject> getCurrentCreatedElements() {
        return this.informationHolder.getCurrentGeneratedElementList();
    }

    public void addNameToCreatedElementEntry(String name, EObject createdElement, InstanciationInstruction instruction) {
        if (this.getNameToCreatedElement().get((Object)name) != null) {
            throw new InvalidValueException((UnitInstruction)instruction, "The name " + name + " has already been used to identify an element.");
        }
        if (this.getNameToCreatedElement().get((Object)createdElement.eClass()) == null) {
            this.getNameToCreatedElement().put((Object)createdElement.eClass(), (Object)CompilerFactory.eINSTANCE.createStringToEObjectMap());
        }
        ((StringToEObjectMap)this.getNameToCreatedElement().get((Object)createdElement.eClass())).getNameToElement().put((Object)name, (Object)createdElement);
        this.addCreatedElementsToCurrentList((UnitInstruction)instruction, createdElement);
    }

    public boolean isUnresolvedContribution(ContributionInstruction contributionInstruction) {
        boolean isUnresolved;
        boolean bl = isUnresolved = this.informationHolder.getUnresolvedContributions().get((Object)contributionInstruction.getReferencedElement().getIntentHref()) == null;
        if (!isUnresolved) {
            isUnresolved = true;
            for (UnresolvedContributionHolder holder : (EList)this.informationHolder.getUnresolvedContributions().get((Object)contributionInstruction.getReferencedElement().getIntentHref())) {
                if (holder.getReferencedContribution() != contributionInstruction) continue;
                boolean bl2 = isUnresolved = isUnresolved && !holder.isResolved();
            }
        }
        return isUnresolved;
    }

    public EList<UnresolvedContributionHolder> getContributionsAssociatedTo(String contributedElementName) {
        if (this.informationHolder.getUnresolvedContributions().get((Object)contributedElementName) != null) {
            return new BasicEList((Collection)this.informationHolder.getUnresolvedContributions().get((Object)contributedElementName));
        }
        return new BasicEList();
    }

    public EList<UnresolvedContributionHolder> getUnresolvedContributions(String contributedElementName) {
        if (this.informationHolder.getUnresolvedContributions().get((Object)contributedElementName) != null) {
            return (EList)this.informationHolder.getUnresolvedContributions().get((Object)contributedElementName);
        }
        return new BasicEList();
    }

    public Set<String> getAllUnresolvedContributionsNames() {
        return this.informationHolder.getUnresolvedContributions().keySet();
    }

    private EMap<EClassifier, StringToEObjectMap> getNameToCreatedElement() {
        return this.informationHolder.getTypeToNameToElementsMap();
    }

    public EList<CompilationStatus> getCompilationStatusList() {
        return this.statusManager.getCompilationStatusList();
    }

    public void registerCompilationExceptionAsCompilationStatus(CompilationException compilationException) {
        BasicEList compilationStatusList = new BasicEList();
        CompilationStatus newStatus = CompilerFactory.eINSTANCE.createCompilationStatus();
        newStatus.setMessage(compilationException.getMessage());
        newStatus.setSeverity(CompilationStatusConverter.createStatusSeverityFromCompilationExceptionErrorType(compilationException.getType()));
        newStatus.setType(CompilationStatusConverter.createStatusTypeFromCompilationExceptionErrorType(compilationException.getType()));
        newStatus.setTarget((IntentGenericElement)compilationException.getInvalidInstruction());
        compilationStatusList.add((Object)newStatus);
        this.addStatusListToInformationHolder(this.getModelingUnitForInstruction(compilationException.getInvalidInstruction()), (EList<CompilationStatus>)compilationStatusList);
    }

    public void registerDiagnosticAsCompilationStatusList(EObject generatedElement, Diagnostic diagnostic) {
        BasicEList compilationStatusList = new BasicEList();
        for (Diagnostic subDiagnostic : diagnostic.getChildren()) {
            CompilationStatus newStatus = CompilerFactory.eINSTANCE.createCompilationStatus();
            newStatus.setMessage(subDiagnostic.getMessage());
            newStatus.setSeverity(CompilationStatusConverter.createStatusSeverityFromDiagnosticSeverity(subDiagnostic));
            newStatus.setType(CompilationMessageType.VALIDATION_ERROR);
            newStatus.setTarget((IntentGenericElement)this.getInstructionByCreatedElement(generatedElement));
            compilationStatusList.add((Object)newStatus);
        }
        this.addStatusListToInformationHolder(this.getModelingUnitForInstruction(this.getInstructionByCreatedElement(generatedElement)), (EList<CompilationStatus>)compilationStatusList);
    }

    private void addStatusListToInformationHolder(ModelingUnit unit, EList<CompilationStatus> compilationStatusList) {
        if (unit != null) {
            this.statusManager.getCompilationStatusList().addAll(compilationStatusList);
            if (this.statusManager.getModelingUnitToStatusList().get((Object)unit) == null) {
                this.statusManager.getModelingUnitToStatusList().put((Object)unit, (Object)new BasicEList());
            }
            ((EList)this.statusManager.getModelingUnitToStatusList().get((Object)unit)).addAll(compilationStatusList);
        }
    }

    private ModelingUnit getModelingUnitForInstruction(UnitInstruction instruction) {
        Object foundModelingUnit = null;
        if (instruction != null) {
            foundModelingUnit = (ModelingUnit)instruction.getUnit();
            UnitInstruction parentInstruction = instruction;
            while (foundModelingUnit == null) {
                foundModelingUnit = (parentInstruction = (UnitInstruction)parentInstruction.eContainer()) != null ? (ModelingUnit)parentInstruction.getUnit() : null;
            }
        }
        return foundModelingUnit;
    }

    public void addUnresolvedContribution(String instanceTextualReference, ContributionInstruction contributionInstruction) {
        if (this.informationHolder.getUnresolvedContributions().get((Object)instanceTextualReference) == null) {
            this.informationHolder.getUnresolvedContributions().put((Object)instanceTextualReference, (Object)new BasicEList());
        }
        if (!this.isRegisteredUnresolvedContribution(contributionInstruction)) {
            UnresolvedContributionHolder holder = CompilerFactory.eINSTANCE.createUnresolvedContributionHolder();
            holder.setResolved(false);
            holder.setReferencedContribution(contributionInstruction);
            ((EList)this.informationHolder.getUnresolvedContributions().get((Object)instanceTextualReference)).add((Object)holder);
        }
    }

    public boolean isRegisteredUnresolvedContribution(ContributionInstruction contributionInstruction) {
        boolean isRegistered = false;
        for (UnresolvedContributionHolder holder : (EList)this.informationHolder.getUnresolvedContributions().get((Object)contributionInstruction.getReferencedElement().getIntentHref())) {
            boolean bl = isRegistered = isRegistered || holder.getReferencedContribution() == contributionInstruction;
        }
        return isRegistered;
    }

    public void setContributionInstructionAsResolved(ContributionInstruction contributionInstruction) {
        for (UnresolvedContributionHolder holder : (EList)this.informationHolder.getUnresolvedContributions().get((Object)contributionInstruction.getReferencedElement().getIntentHref())) {
            if (holder.getReferencedContribution() != contributionInstruction) continue;
            holder.setResolved(true);
        }
    }
}

