/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class AbstractContainmentAdapter
implements IContainmentAdapter {
    public boolean contains(Object containmentContext, Object element, int flags) {
        IElement containmentContextAdapter = this.getContentAdapter().adapt(containmentContext);
        if (containmentContextAdapter == null || element == null) {
            return false;
        }
        IResource resource = null;
        IElement elementAdapter = this.getContentAdapter().adapt(element);
        if (elementAdapter == null && (resource = ResourceUtil.getResource((Object)element)) != null) {
            elementAdapter = this.getElementFor(resource);
        }
        if (elementAdapter != null) {
            return this.contains(containmentContextAdapter, elementAdapter, flags);
        }
        if (resource != null) {
            return this.contains(containmentContextAdapter, resource, flags);
        }
        return false;
    }

    protected abstract IElement getElementFor(IResource var1);

    protected IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    protected boolean contains(IElement containmentContext, IElement element, int flags) {
        if (AbstractContainmentAdapter.checkContext(flags) && Elements.equalsAndSameParentChain((IElement)containmentContext, (IElement)element)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && Elements.equalsAndSameParentChain((IElement)containmentContext, (IElement)Elements.getParent((IElement)element))) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.isAncestorOf(containmentContext, element)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.isAncestorOf(element, containmentContext);
    }

    protected boolean isAncestorOf(IElement element, IElement other) {
        return Elements.isAncestorOf((IElement)element, (IElement)Elements.getParent((IElement)other));
    }

    protected boolean contains(IElement containmentContext, IResource resource, int flags) {
        IResource contextResource = Elements.getResource((IElement)containmentContext);
        if (contextResource == null) {
            return false;
        }
        if (AbstractContainmentAdapter.checkContext(flags) && contextResource.equals((Object)resource)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && contextResource.equals((Object)resource.getParent())) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.isAncestorOf(contextResource, resource)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.isAncestorOf(resource, contextResource);
    }

    protected boolean isAncestorOf(IResource resource, IResource other) {
        other = other.getParent();
        while (other != null) {
            if (resource.equals((Object)other)) {
                return true;
            }
            other = other.getParent();
        }
        return false;
    }

    protected static boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }

    protected static boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    protected static boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    protected static boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }
}

