/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.SourceFile;

public abstract class BaseSourceFile
extends SourceFile {
    private final FileWrapper fileWrapper;

    public BaseSourceFile(IElement parent, IFile file) {
        this(parent, FileWrapper.forFile(file));
    }

    public BaseSourceFile(IElement parent, URI locationUri) {
        this(parent, FileWrapper.forLocationUri(locationUri));
    }

    public BaseSourceFile(IElement parent, String name) {
        super(parent, name);
        this.fileWrapper = FileWrapper.NULL;
    }

    private BaseSourceFile(IElement parent, FileWrapper fileWrapper) {
        super(parent, fileWrapper.getName());
        this.fileWrapper = fileWrapper;
    }

    @Override
    public Object getFileObject_() {
        return this.fileWrapper.getFileObject();
    }

    @Override
    public IResource getResource_() {
        return this.getFile_();
    }

    @Override
    public IFile getFile_() {
        return this.fileWrapper.getFile();
    }

    @Override
    public URI getLocationUri_() {
        return this.fileWrapper.getLocationUri();
    }

    private static interface FileWrapper {
        public static final FileWrapper NULL = new FileWrapper(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Object getFileObject() {
                return null;
            }

            @Override
            public IFile getFile() {
                return null;
            }

            @Override
            public URI getLocationUri() {
                return null;
            }

            public String toString() {
                return "NULL";
            }
        };

        public String getName();

        public Object getFileObject();

        public IFile getFile();

        public URI getLocationUri();

        public static FileWrapper forFile(final IFile file) {
            return new FileWrapper(){

                @Override
                public String getName() {
                    return file.getName();
                }

                @Override
                public Object getFileObject() {
                    return file;
                }

                @Override
                public IFile getFile() {
                    return file;
                }

                @Override
                public URI getLocationUri() {
                    return file.getLocationURI();
                }

                public String toString() {
                    return file.getFullPath().toString();
                }
            };
        }

        public static FileWrapper forFileStore(final IFileStore fileStore) {
            return new FileWrapper(){

                @Override
                public String getName() {
                    return fileStore.getName();
                }

                @Override
                public Object getFileObject() {
                    return fileStore;
                }

                @Override
                public IFile getFile() {
                    return null;
                }

                @Override
                public URI getLocationUri() {
                    return fileStore.toURI();
                }

                public String toString() {
                    return fileStore.toString();
                }
            };
        }

        public static FileWrapper forLocationUri(URI uri) {
            IFileStore fileStore;
            try {
                fileStore = EFS.getStore((URI)uri);
            }
            catch (CoreException e) {
                throw new IllegalArgumentException(e);
            }
            return FileWrapper.forFileStore(fileStore);
        }
    }
}

