/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.quickoutline;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.handly.ui.quickoutline.EditorOutlinePopupHost;
import org.eclipse.handly.ui.quickoutline.IOutlinePopupHost;
import org.eclipse.handly.ui.quickoutline.OutlinePopup;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.keys.IBindingService;

public abstract class OutlinePopupHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IOutlinePopupHost host = this.getOutlinePopupHost(event);
        if (host == null) {
            return null;
        }
        OutlinePopup outlinePopup = this.createOutlinePopup();
        outlinePopup.init(host, this.getInvokingKeyStroke(event));
        outlinePopup.open();
        return null;
    }

    protected abstract OutlinePopup createOutlinePopup();

    protected IOutlinePopupHost getOutlinePopupHost(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor == null) {
            return null;
        }
        return new EditorOutlinePopupHost(editor);
    }

    protected KeyStroke getInvokingKeyStroke(ExecutionEvent event) {
        TriggerSequence[] bindings;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = bindings = bindingService.getActiveBindingsFor(new ParameterizedCommand(event.getCommand(), null));
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke[] keyStrokes;
            TriggerSequence binding = triggerSequenceArray[n2];
            if (binding instanceof KeySequence && (keyStrokes = ((KeySequence)binding).getKeyStrokes()).length > 0) {
                return keyStrokes[0];
            }
            ++n2;
        }
        return null;
    }
}

