/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.impl.support.ElementChangeListenerList;
import org.eclipse.handly.model.impl.support.INotificationManager;

public class NotificationManager
implements INotificationManager {
    private final ElementChangeListenerList listenerList = new ElementChangeListenerList();

    public void addElementChangeListener(IElementChangeListener listener) {
        this.listenerList.add(listener, Integer.MAX_VALUE);
    }

    public void addElementChangeListener(IElementChangeListener listener, int eventMask) {
        this.listenerList.add(listener, eventMask);
    }

    public void removeElementChangeListener(IElementChangeListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void fireElementChangeEvent(IElementChangeEvent event) {
        ElementChangeListenerList.Entry[] entries;
        int eventType = event.getType();
        ElementChangeListenerList.Entry[] entryArray = entries = this.listenerList.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ElementChangeListenerList.Entry entry = entryArray[n2];
            if ((eventType & entry.getEventMask()) != 0) {
                SafeRunner.run(() -> entry.getListener().elementChanged(event));
            }
            ++n2;
        }
    }
}

