/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;

public class ViewerDropSupport {
    private StructuredViewer viewer;
    private DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
    private List<ViewerDropAdapter> dropAdapters = new ArrayList<ViewerDropAdapter>();
    private boolean started;

    public ViewerDropSupport(StructuredViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.viewer = viewer;
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.started) {
            throw new IllegalStateException();
        }
        this.delegatingDropAdapter.addDropTargetListener(listener);
        if (listener instanceof ViewerDropAdapter) {
            this.dropAdapters.add((ViewerDropAdapter)listener);
        }
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.viewer.addDropSupport(this.getOperations(), this.delegatingDropAdapter.getTransfers(), (DropTargetListener)this.delegatingDropAdapter);
        this.started = true;
    }

    public void setFeedbackEnabled(boolean value) {
        for (ViewerDropAdapter dropAdapter : this.dropAdapters) {
            dropAdapter.setFeedbackEnabled(value);
        }
    }

    protected int getOperations() {
        return 23;
    }
}

