/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.ISourceConstructImplExtension;

public class StructureHelper {
    private final Map<Object, List<IElement>> children = new HashMap<Object, List<IElement>>();
    private final Map<ISourceConstructImplExtension, Integer> occurrenceCounts = new HashMap<ISourceConstructImplExtension, Integer>();

    public final void pushChild(Object parentBody, IElement child) {
        if (parentBody == null) {
            throw new IllegalArgumentException();
        }
        if (child == null) {
            throw new IllegalArgumentException();
        }
        List<IElement> childrenList = this.children.get(parentBody);
        if (childrenList == null) {
            childrenList = new ArrayList<IElement>();
            this.children.put(parentBody, childrenList);
        }
        childrenList.add(child);
    }

    public final List<IElement> popChildren(Object body) {
        return Optional.ofNullable(this.children.remove(body)).orElse(Collections.emptyList());
    }

    public void resolveDuplicates(ISourceConstructImplExtension element) {
        if (element.getOccurrenceCount_() != 1) {
            throw new IllegalArgumentException();
        }
        Integer occurrenceCount = this.occurrenceCounts.get(element);
        if (occurrenceCount == null) {
            this.occurrenceCounts.put(element, 1);
        } else {
            int newOccurrenceCount = occurrenceCount + 1;
            this.occurrenceCounts.put(element, newOccurrenceCount);
            element.setOccurrenceCount_(newOccurrenceCount);
        }
    }
}

