/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class SourceFileDocumentProvider
extends TextFileDocumentProvider
implements IWorkingCopyManager {
    private static final ISourceFile[] NO_WORKING_COPIES = new ISourceFile[0];

    public SourceFileDocumentProvider() {
        this(null);
    }

    public SourceFileDocumentProvider(IDocumentProvider parent) {
        super(parent);
    }

    @Override
    public ISourceFile getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceFileInfo) {
            return ((SourceFileInfo)info).workingCopy;
        }
        return null;
    }

    @Override
    public ISourceFile getWorkingCopy(IDocument document) {
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)it.next();
            IDocument infoDocument = null;
            if (info.fTextFileBuffer != null) {
                infoDocument = info.fTextFileBuffer.getDocument();
            }
            if (infoDocument == null || !infoDocument.equals(document) || !(info instanceof SourceFileInfo)) continue;
            return ((SourceFileInfo)info).workingCopy;
        }
        return null;
    }

    @Override
    public ISourceFile[] getWorkingCopies() {
        ArrayList<ISourceFile> result = new ArrayList<ISourceFile>();
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            ISourceFile workingCopy;
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)it.next();
            if (!(info instanceof SourceFileInfo) || (workingCopy = ((SourceFileInfo)info).workingCopy) == null) continue;
            result.add(workingCopy);
        }
        return result.toArray(NO_WORKING_COPIES);
    }

    protected abstract ISourceFile getSourceFile(Object var1);

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (info instanceof SourceFileInfo) {
            boolean f = false;
            try {
                ISourceFile workingCopy = this.acquireWorkingCopy(element, info);
                if (workingCopy != null) {
                    if (!Elements.isWorkingCopy((ISourceFile)workingCopy)) {
                        throw new AssertionError();
                    }
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (IBuffer buffer = Elements.getBuffer((ISourceFile)workingCopy);){
                        IDocument document = null;
                        if (info.fTextFileBuffer != null) {
                            document = info.fTextFileBuffer.getDocument();
                        }
                        if (!buffer.getDocument().equals(document)) {
                            this.releaseWorkingCopy(workingCopy, element, info);
                            throw new AssertionError();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ((SourceFileInfo)info).workingCopy = workingCopy;
                }
                f = true;
            }
            finally {
                if (!f) {
                    super.disposeFileInfo(element, info);
                }
            }
        }
        return info;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        try {
            ISourceFile workingCopy;
            if (info instanceof SourceFileInfo && (workingCopy = ((SourceFileInfo)info).workingCopy) != null) {
                this.releaseWorkingCopy(workingCopy, element, info);
            }
        }
        finally {
            super.disposeFileInfo(element, info);
        }
    }

    protected ISourceFile acquireWorkingCopy(Object element, TextFileDocumentProvider.FileInfo info) throws CoreException {
        ISourceFile sourceFile = this.getSourceFile(element);
        if (sourceFile instanceof ISourceFileImplExtension) {
            ((ISourceFileImplExtension)sourceFile).becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
            return sourceFile;
        }
        return null;
    }

    protected void releaseWorkingCopy(ISourceFile workingCopy, Object element, TextFileDocumentProvider.FileInfo info) {
        ((ISourceFileImplExtension)workingCopy).releaseWorkingCopy_();
    }

    protected static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        ISourceFile workingCopy;

        protected SourceFileInfo() {
        }
    }
}

