/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.osgi.framework.Bundle;

public abstract class AbstractTracer {
    private static boolean sIsInfoLogging = false;
    private static boolean sIsDebugLogging = false;
    private static final String EOL;
    private static final String EMPTY_STRING = "";
    private static final String ENTERING_MSG = "Entering method ";
    private static final String SIGNATURE_PATTERN = "$signature$";
    private static final String EXITING_MSG = "Exiting method ";
    private static final String FULL_EXITING_MSG;
    private ILog log = null;
    private boolean infoAlwaysTrue = false;

    static {
        if (Platform.getBundle((String)"org.eclipse.graphiti.examples.common") != null) {
            GFPreferences prefs = GFPreferences.getInstance();
            sIsInfoLogging = prefs.isInfoLevelTracingActive();
            sIsDebugLogging = prefs.isDebugLevelTracingActive();
        } else {
            String logDebugProperty;
            String logInfoProperty = System.getProperty("org.eclipse.graphiti.logging.info", "false");
            if ("true".equals(logInfoProperty)) {
                sIsInfoLogging = true;
            }
            if ("true".equals(logDebugProperty = System.getProperty("org.eclipse.graphiti.logging.debug", "false"))) {
                sIsDebugLogging = true;
            }
        }
        EOL = System.getProperty("line.separator");
        FULL_EXITING_MSG = "#Exiting method $signature$#" + EOL;
    }

    public AbstractTracer(String location) {
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)location);
            this.log = Platform.getLog((Bundle)bundle);
        } else {
            System.err.println("================================================================================================");
            System.err.println("Logging is disabled because the platform is not running! (This message is OK for Unit test runs)");
            System.err.println("================================================================================================");
            this.log = null;
        }
    }

    public static void setInfoLogging(boolean isInfoLogging) {
        sIsInfoLogging = isInfoLogging;
    }

    public static void setDebugLogging(boolean isDebugLogging) {
        sIsDebugLogging = isDebugLogging;
    }

    public void entering(Class<?> clazz, String signature, Object ... args) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), "Class '" + clazz.getName() + "': " + this.createTraceMsg(ENTERING_MSG + signature, args)));
        }
    }

    public void exiting(Class<?> clazz, String signature) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), "Class '" + clazz.getName() + "':'" + FULL_EXITING_MSG.replaceFirst(SIGNATURE_PATTERN, signature)));
        }
    }

    public void exiting(Class<?> clazz, String signature, Object res) {
        Object result = res;
        if (result == null) {
            result = new String("<null>");
        }
        if (this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), "Class '" + clazz.getName() + "':'" + this.createTraceMsg(EXITING_MSG + signature, result)));
        }
    }

    public boolean debug() {
        return sIsDebugLogging;
    }

    public void debug(String msg) {
        if (this.debug() && this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), "DEBUG: " + msg));
        }
    }

    public void debug(String msg, Throwable throwable) {
        if (this.debug() && this.log != null) {
            this.log.log((IStatus)new Status(4, this.log.getBundle().getSymbolicName(), msg, throwable));
        }
    }

    public void error(String methodName, String msg) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(4, this.log.getBundle().getSymbolicName(), "Method '" + methodName + "': " + msg));
        }
    }

    public void error(String msg, Throwable throwable) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(4, this.log.getBundle().getSymbolicName(), msg, throwable));
        }
    }

    public void error(String msg) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(4, this.log.getBundle().getSymbolicName(), msg));
        }
    }

    public boolean info() {
        if (this.getInfoAlwaysTrue()) {
            return true;
        }
        return sIsInfoLogging;
    }

    public void info(String className, String methodName, String msg) {
        if (this.info() && this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), "Class '" + className + "' method '" + methodName + "': " + msg));
        }
    }

    public void info(String msg) {
        if (this.info() && this.log != null) {
            this.log.log((IStatus)new Status(1, this.log.getBundle().getSymbolicName(), msg));
        }
    }

    public void log(int level, String msg, Throwable throwable) {
        this.log.log((IStatus)new Status(level, this.log.getBundle().getSymbolicName(), msg, throwable));
    }

    public void log(int level, String msg) {
        if ((level == 1 && this.info() || level == 2 || level == 4) && this.log != null) {
            this.log.log((IStatus)new Status(level, this.log.getBundle().getSymbolicName(), msg));
        }
    }

    public void warning(String methodName, String msg) {
        if ((this.info() || this.debug()) && this.log != null) {
            this.log.log((IStatus)new Status(2, this.log.getBundle().getSymbolicName(), "Method '" + methodName + "': " + msg));
        }
    }

    public void warning(String msg) {
        if ((this.info() || this.debug()) && this.log != null) {
            this.log.log((IStatus)new Status(2, this.log.getBundle().getSymbolicName(), msg));
        }
    }

    public void warning(String msg, Throwable throwable) {
        if (this.log != null) {
            this.log.log((IStatus)new Status(2, this.log.getBundle().getSymbolicName(), msg, throwable));
        }
    }

    private String createTraceMsg(String msg, Object ... args) {
        StringBuffer sb = new StringBuffer(512);
        StringBuffer esc = new StringBuffer();
        sb.append('#');
        sb.append(msg);
        if (args != null) {
            sb.append('#');
            sb.append(args.length);
            int i = 0;
            while (i < args.length) {
                sb.append('#');
                if (args[i] != null) {
                    sb.append(this.escape(args[i].toString(), esc));
                } else {
                    sb.append(EMPTY_STRING);
                }
                ++i;
            }
        }
        sb.append('#');
        sb.append(EOL);
        return sb.toString();
    }

    private StringBuffer escape(String s, StringBuffer buf) {
        int len = 0;
        if (s == null) {
            s = EMPTY_STRING;
        }
        len = s.length();
        buf.setLength(0);
        buf.append(s);
        int i = 0;
        while (i < len) {
            switch (buf.charAt(i)) {
                case '#': {
                    buf.replace(i, i + 1, "\\#");
                    ++len;
                    ++i;
                    break;
                }
                case '\\': {
                    buf.replace(i, i + 1, "\\\\");
                    ++len;
                    ++i;
                }
            }
            ++i;
        }
        return buf;
    }

    public final boolean getInfoAlwaysTrue() {
        return this.infoAlwaysTrue;
    }

    public final void setInfoAlwaysTrue(boolean b) {
        this.infoAlwaysTrue = b;
    }
}

