/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.validation;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.features.validation.RequestMarkersAction;
import org.eclipse.glsp.server.features.validation.SetMarkersAction;
import org.eclipse.glsp.server.model.GModelState;

public class RequestMarkersHandler
extends AbstractActionHandler<RequestMarkersAction> {
    private static final Logger LOGGER = LogManager.getLogger(RequestMarkersHandler.class);
    @Inject
    protected Optional<ModelValidator> validator;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> executeAction(RequestMarkersAction action) {
        List<String> elementIds = action.getElementsIDs();
        if (this.validator.isEmpty()) {
            LOGGER.warn("Cannot compute markers! No implementation for " + ModelValidator.class + " has been bound");
            return this.none();
        }
        if (elementIds == null || elementIds.size() == 0 || elementIds.size() == 1 && "EMPTY".equals(elementIds.get(0))) {
            elementIds = Arrays.asList(((GModelRoot)this.modelState.getRoot()).getId());
        }
        List<GModelElement> elements = elementIds.stream().flatMap(element -> this.modelState.getIndex().get(element).stream()).collect(Collectors.toList());
        List<Marker> markers = this.validator.get().validate(elements, action.getReason());
        return this.listOf(new SetMarkersAction(markers, action.getReason()));
    }
}

