/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.AbstractOperationHandler;
import org.eclipse.glsp.server.operations.ChangeRoutingPointsOperation;
import org.eclipse.glsp.server.types.ElementAndRoutingPoints;
import org.eclipse.glsp.server.types.GLSPServerException;

public class GModelChangeRoutingPointsHandler
extends AbstractOperationHandler<ChangeRoutingPointsOperation> {
    @Inject
    protected GModelState modelState;

    @Override
    protected void executeOperation(ChangeRoutingPointsOperation operation) {
        if (operation.getNewRoutingPoints() == null) {
            throw new IllegalArgumentException("Incomplete change routingPoints  action");
        }
        GModelIndex index = this.modelState.getIndex();
        for (ElementAndRoutingPoints ear : operation.getNewRoutingPoints()) {
            GEdge edge = (GEdge)GLSPServerException.getOrThrow(index.findElementByClass(ear.getElementId(), GEdge.class), "Invalid edge: edge ID " + ear.getElementId());
            EList routingPoints = edge.getRoutingPoints();
            routingPoints.clear();
            routingPoints.addAll(ear.getNewRoutingPoints());
        }
    }
}

