/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.model;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.model.GModelStateImpl;
import org.eclipse.glsp.server.model.ModelStateProvider;
import org.eclipse.glsp.server.protocol.ClientSessionListener;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;

@Singleton
public class DefaultModelStateProvider
implements ModelStateProvider,
ClientSessionListener {
    @Inject
    protected ClientSessionManager sessionManager;
    private final Map<String, GModelState> clientModelStates = new ConcurrentHashMap<String, GModelState>();

    @Inject
    public DefaultModelStateProvider() {
    }

    @Inject
    public void postConstruct() {
        this.sessionManager.addListener(this);
    }

    @Override
    public Optional<GModelState> getModelState(String clientId) {
        return Optional.ofNullable(this.clientModelStates.get(clientId));
    }

    @Override
    public GModelState create(String clientId) {
        GModelState modelState = this.createModelState();
        modelState.setClientId(clientId);
        this.clientModelStates.put(clientId, modelState);
        return modelState;
    }

    protected GModelState createModelState() {
        return new GModelStateImpl();
    }

    @Override
    public void remove(String clientId) {
        this.clientModelStates.remove(clientId);
    }

    @Override
    public void sessionClosed(String clientId, GLSPClient client) {
        this.clientModelStates.remove(clientId);
    }

    @Override
    public void clientDisconnected(GLSPClient client) {
        this.sessionManager.removeListener(this);
    }
}

