/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.action;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.actions.InitializeClientSessionAction;
import org.eclipse.glsp.server.actions.ResponseAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.model.ModelStateProvider;
import org.eclipse.glsp.server.protocol.ClientSessionListener;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServerException;
import org.eclipse.glsp.server.utils.FutureUtil;

public class DefaultActionDispatcher
implements ActionDispatcher,
ClientSessionListener {
    private static final Logger LOG = Logger.getLogger(DefaultActionDispatcher.class);
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    @Inject
    protected ActionHandlerRegistry actionHandlerRegistry;
    @Inject
    protected ModelStateProvider modelStateProvider;
    private final ClientSessionManager clientSessionManager;
    protected final String name;
    protected final Thread thread;
    protected final BlockingQueue<ActionMessage> actionsQueue = new ArrayBlockingQueue<ActionMessage>(100, true);
    protected final Map<ActionMessage, CompletableFuture<Void>> results = Collections.synchronizedMap(new HashMap());
    @Inject
    protected Provider<GLSPClient> client;

    @Inject
    public DefaultActionDispatcher(ClientSessionManager clientSessionManager) {
        this.name = String.valueOf(this.getClass().getSimpleName()) + " " + COUNT.incrementAndGet();
        this.clientSessionManager = clientSessionManager;
        this.clientSessionManager.addListener(this);
        this.thread = new Thread(this::runThread);
        this.thread.setName(this.name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public CompletableFuture<Void> dispatch(String clientId, Action action) {
        return this.dispatch(new ActionMessage(clientId, action));
    }

    @Override
    public CompletableFuture<Void> dispatch(ActionMessage message) {
        if (message == null) {
            String errorMsg = String.format("Received a null message in DefaultActionDispatcher: %s", this.name);
            throw new IllegalArgumentException(errorMsg);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.results.put(message, result);
        if (this.thread == Thread.currentThread()) {
            this.handleMessage(message);
        } else {
            this.addToQueue(message);
        }
        return result;
    }

    protected void addToQueue(ActionMessage message) {
        if (Thread.currentThread() == this.thread) {
            LOG.error((Object)"ActionMessages shouldn't be added to the actions queue from the dispatcher thread!");
            this.handleMessage(message);
            return;
        }
        boolean success = this.actionsQueue.offer(message);
        while (!success) {
            if (!this.thread.isAlive() || this.thread.isInterrupted()) {
                LOG.warn((Object)String.format("Received an action message after the ActionDispatcher was stopped. Ignoring message: %s", message));
                return;
            }
            try {
                success = this.actionsQueue.offer(message, 1L, TimeUnit.SECONDS);
                if (success) continue;
                LOG.warn((Object)String.format("Actions queue is currently full for dispatcher %s ; retrying...", this.name));
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    private void runThread() {
        try {
            while (true) {
                this.handleNextMessage();
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)String.format("Terminating DefaultActionDispatcher thread %s", Thread.currentThread().getName()));
            LOG.info((Object)"Terminating DefaultActionDispatcher");
            return;
        }
    }

    private void handleNextMessage() throws InterruptedException {
        ActionMessage message = this.actionsQueue.take();
        if (message != null) {
            this.handleMessage(message);
        }
    }

    protected void handleMessage(ActionMessage message) {
        this.checkThread();
        Action action = message.getAction();
        String clientId = message.getClientId();
        if (action == null) {
            LOG.warn((Object)String.format("Received an action message without an action for client %s", clientId));
            return;
        }
        try {
            List<CompletableFuture<Void>> results = this.runAction(action, clientId);
            CompletableFuture<Void> result = FutureUtil.aggregateResults(results);
            ((CompletableFuture)result.thenAccept(any -> this.results.remove(message).complete(null))).exceptionally(t -> {
                this.results.remove(message).completeExceptionally((Throwable)t);
                return null;
            });
        }
        catch (Throwable t2) {
            this.results.remove(message).completeExceptionally(t2);
        }
    }

    protected List<CompletableFuture<Void>> runAction(Action action, String clientId) {
        List<ActionHandler> actionHandlers = this.actionHandlerRegistry.get(action);
        if (actionHandlers.isEmpty()) {
            throw new IllegalArgumentException("No handler registered for action: " + action);
        }
        Optional<GModelState> modelState = this.modelStateProvider.getModelState(clientId);
        if (!modelState.isPresent()) {
            if (action instanceof InitializeClientSessionAction) {
                modelState = Optional.of(this.modelStateProvider.create(clientId));
            } else {
                String errorMsg = String.format("The session for client '%s' has not been initialized yet. Could not process action: %s", clientId, action);
                throw new GLSPServerException(errorMsg);
            }
        }
        ArrayList<CompletableFuture<Void>> results = new ArrayList<CompletableFuture<Void>>();
        for (ActionHandler actionHandler : actionHandlers) {
            List<Action> responses = actionHandler.execute(action, modelState.get()).stream().map(response -> ResponseAction.respond(action, response)).collect(Collectors.toList());
            results.addAll(this.dispatchAll(clientId, responses));
        }
        return results;
    }

    protected final void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("This method should only be invoked from the ActionDispatcher's thread: " + this.name);
        }
    }

    @Override
    public void clientDisconnected(GLSPClient client) {
        if (client == this.client.get()) {
            this.thread.interrupt();
            this.clientSessionManager.removeListener(this);
        }
    }
}

