/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.sirius.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gendoc.bundle.acceleo.commons.files.CommonService;
import org.eclipse.gendoc.table.Cell;
import org.eclipse.gendoc.table.Row;
import org.eclipse.gendoc.table.Table;
import org.eclipse.gendoc.table.TableFactory;
import org.eclipse.gendoc.table.TableHeader;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.tools.internal.export.csv.TableCsvHelper;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusServices {
    public List<Diagram> getSiriusDiagrams(EObject self) {
        CommonService.load((EObject)self, (String)"aird");
        ResourceSet set = null;
        if (self.eResource() != null && self.eResource().getResourceSet() != null) {
            set = self.eResource().getResourceSet();
        }
        if (set == null) {
            return Arrays.asList(new Diagram[0]);
        }
        ECrossReferenceAdapter cross = ECrossReferenceAdapter.getCrossReferenceAdapter(set);
        if (cross == null) {
            cross = new ECrossReferenceAdapter();
            set.eAdapters().add((Object)cross);
        }
        LinkedList<Diagram> result = new LinkedList<Diagram>();
        Collection inverses = cross.getInverseReferences(self, true);
        for (EStructuralFeature.Setting s : inverses) {
            if (!(s.getEObject() instanceof DSemanticDiagram)) continue;
            DSemanticDiagram sem = (DSemanticDiagram)s.getEObject();
            for (AnnotationEntry e : sem.getOwnedAnnotationEntries()) {
                if (!"GMF_DIAGRAMS".equals(e.getSource()) || !(e.getData() instanceof Diagram)) continue;
                result.add((Diagram)e.getData());
            }
        }
        return result;
    }

    public Collection<Table> getSiriusTables(EObject element) {
        CommonService.load((EObject)element, (String)"aird");
        ResourceSet set = null;
        if (element.eResource() != null && element.eResource().getResourceSet() != null) {
            set = element.eResource().getResourceSet();
        }
        if (set == null) {
            return null;
        }
        ECrossReferenceAdapter cross = ECrossReferenceAdapter.getCrossReferenceAdapter(set);
        if (cross == null) {
            cross = new ECrossReferenceAdapter();
            set.eAdapters().add((Object)cross);
        }
        Collection inverses = cross.getInverseReferences(element, true);
        LinkedList<Table> results = new LinkedList<Table>();
        for (EStructuralFeature.Setting s : inverses) {
            if (!(s.getEObject() instanceof DTable)) continue;
            DTable sem = (DTable)s.getEObject();
            Table result = TableFactory.eINSTANCE.createTable();
            result.setName(sem.getName());
            Iterable tableDescriptors = TableCsvHelper.getTableDescriptor((DTable)sem);
            int index = 0;
            for (Iterable line : tableDescriptors) {
                Cell cell;
                if (index == 0) {
                    TableHeader header = TableFactory.eINSTANCE.createTableHeader();
                    for (String cellValue : line) {
                        cell = TableFactory.eINSTANCE.createCell();
                        cell.setLabel(cellValue);
                        header.getCells().add((Object)cell);
                    }
                    result.setTableheader(header);
                } else {
                    Row row = TableFactory.eINSTANCE.createRow();
                    for (String cellValue : line) {
                        cell = TableFactory.eINSTANCE.createCell();
                        cell.setLabel(cellValue);
                        row.getCells().add((Object)cell);
                    }
                    result.getRows().add((Object)row);
                }
                ++index;
            }
            results.add(result);
        }
        return results;
    }
}

