/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.context;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.exception.ElementNotFoundException;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;

public class EMFModelLoaderService
extends AbstractService
implements IEMFModelLoaderService {
    private static final String SEPARATOR = "/";
    private final Pattern patternForIndex = Pattern.compile("\\{(\\d*)\\}");
    private final Pattern patternForAttribut = Pattern.compile("(.*)=\"(.*)\"");
    protected ResourceSet resourceSet;
    private List<URI> paths;
    private boolean isRootVirtual = false;

    protected ResourceSet constructResourceSet() {
        return new ResourceSetImpl();
    }

    protected Resource getResource(URI uri) {
        return this.getResourceSet().getResource(uri, true);
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = this.constructResourceSet();
        }
        return this.resourceSet;
    }

    @Override
    public EObject getModel(URI path) throws ModelNotFoundException {
        this.checkPath(path);
        if (this.paths == null) {
            this.paths = new LinkedList<URI>();
        }
        EObject model = null;
        try {
            final Resource resource = this.getResource(path);
            if (!this.paths.contains(path)) {
                this.paths.add(path);
                this.resolve(resource);
            }
            switch (resource.getContents().size()) {
                case 0: {
                    if (!resource.isLoaded()) {
                        throw new ModelNotFoundException("Model can not be loaded from URL: \"" + path.toString() + "\"");
                    }
                    break;
                }
                case 1: {
                    this.isRootVirtual = false;
                    model = (EObject)resource.getContents().get(0);
                    break;
                }
                default: {
                    this.isRootVirtual = true;
                    model = new EObject(){

                        public TreeIterator<EObject> eAllContents() {
                            return null;
                        }

                        public EClass eClass() {
                            return null;
                        }

                        public EObject eContainer() {
                            return null;
                        }

                        public EStructuralFeature eContainingFeature() {
                            return null;
                        }

                        public EReference eContainmentFeature() {
                            return null;
                        }

                        public EList<EObject> eContents() {
                            return resource.getContents();
                        }

                        public EList<EObject> eCrossReferences() {
                            return null;
                        }

                        public Object eGet(EStructuralFeature arg0) {
                            return null;
                        }

                        public Object eGet(EStructuralFeature arg0, boolean arg1) {
                            return null;
                        }

                        public boolean eIsProxy() {
                            return false;
                        }

                        public boolean eIsSet(EStructuralFeature arg0) {
                            return false;
                        }

                        public Resource eResource() {
                            return resource;
                        }

                        public void eSet(EStructuralFeature arg0, Object arg1) {
                        }

                        public void eUnset(EStructuralFeature arg0) {
                        }

                        public EList<Adapter> eAdapters() {
                            return null;
                        }

                        public boolean eDeliver() {
                            return false;
                        }

                        public void eNotify(Notification arg0) {
                        }

                        public void eSetDeliver(boolean arg0) {
                        }

                        public Object eInvoke(EOperation arg0, EList<?> arg1) throws InvocationTargetException {
                            return null;
                        }
                    };
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ModelNotFoundException("Model can not be loaded from URL: \"" + path.toString() + "\"");
        }
        return model;
    }

    protected void resolve(Resource resource) {
        this.getResourceSet().eSetDeliver(false);
        EcoreUtil.resolveAll((Resource)resource);
        this.getResourceSet().eSetDeliver(true);
    }

    protected void checkPath(URI path) throws ModelNotFoundException {
        if (path == null) {
            throw new ModelNotFoundException("No path provided");
        }
    }

    @Override
    public EObject getCurrentElement(String elementPath, EObject model, int i, String attribute) throws ElementNotFoundException {
        if (i < 1) {
            throw new IllegalArgumentException("i must be higher than zero");
        }
        if (i == 1 && (elementPath == null || elementPath.length() == 0)) {
            return model;
        }
        String[] splitAttribute = new String[]{};
        if (elementPath != null) {
            splitAttribute = elementPath.split(SEPARATOR);
        }
        if (!this.isRootVirtual) {
            if (i == 1 && splitAttribute.length == 1 && (this.isEquals(model, attribute, elementPath) || this.getIndex(elementPath) == 0)) {
                return model;
            }
            if (i >= splitAttribute.length) {
                throw new IllegalArgumentException("i must be lower than length of segments");
            }
        }
        String toSearch = this.isRootVirtual ? splitAttribute[i - 1] : splitAttribute[i];
        String trim = toSearch.trim();
        EObject object = null;
        int index = this.getIndex(trim);
        if (index >= 0 && !model.eContents().isEmpty()) {
            object = (EObject)model.eContents().get(index);
        } else {
            for (EObject tmp : model.eContents()) {
                if (!this.isEquals(tmp, attribute, toSearch)) continue;
                object = tmp;
                break;
            }
        }
        if (object != null) {
            int splitAttributeLength;
            int n = splitAttributeLength = this.isRootVirtual ? splitAttribute.length : splitAttribute.length - 1;
            if (i != splitAttributeLength) {
                return this.getCurrentElement(elementPath, object, i + 1, attribute);
            }
            if (i == splitAttributeLength) {
                return object;
            }
        }
        throw new ElementNotFoundException(elementPath, model.eResource().getURI().toString());
    }

    public boolean isEquals(EObject tmp, String attribute, String toSearch) {
        String content;
        String featureName = attribute;
        String featureValue = toSearch;
        Matcher m = this.patternForAttribut.matcher(toSearch);
        if (m.matches() && m.groupCount() == 2) {
            featureName = m.group(1);
            featureValue = m.group(2);
        }
        return (content = this.getEStructuralFeature(tmp, featureName)) != null && content.equals(featureValue);
    }

    protected int getIndex(String element) {
        Matcher m = this.patternForIndex.matcher(element);
        if (m.matches() && m.groupCount() == 1) {
            String group = m.group(1);
            try {
                int result = Integer.valueOf(group);
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    protected String getEStructuralFeature(EObject e, String attribute) {
        if (e != null && attribute != null) {
            EList all = e.eClass().getEAllStructuralFeatures();
            for (EStructuralFeature f : all) {
                Object content;
                if (!f.getName().equalsIgnoreCase(attribute) || !((content = e.eGet(f)) instanceof String)) continue;
                return (String)content;
            }
        }
        return null;
    }

    public void clear() {
        EList resources = this.getResourceSet().getResources();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            try {
                r.unload();
            }
            catch (Exception exception) {}
            ++i;
        }
        if (this.paths != null) {
            this.paths.clear();
        }
    }
}

