/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.trace.commons.model.trace.BigStep;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.SequentialStep;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.IStateManager;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewNotifier;

public class GenericTraceExplorer
implements ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> {
    private Trace<?, ?, ?> trace;
    private final List<Step<?>> callStack = new ArrayList();
    private State<?, ?> currentState;
    private Step<?> stepIntoResult;
    private Step<?> stepOverResult;
    private Step<?> stepReturnResult;
    private Step<?> stepBackIntoResult;
    private Step<?> stepBackOverResult;
    private Step<?> stepBackOutResult;
    private HashMap<Dimension<?>, Boolean> canBackValueCache = new HashMap();
    private HashMap<Dimension<?>, Boolean> canStepValueCache = new HashMap();
    private Map<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>> listeners = new HashMap<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>>();
    private IStateManager<State<?, ?>> stateManager;

    public GenericTraceExplorer(Trace<?, ?, ?> trace) {
        this.trace = trace;
    }

    public GenericTraceExplorer(Trace<?, ?, ?> trace, IStateManager<State<?, ?>> stateManager) {
        this.stateManager = stateManager;
        this.trace = trace;
    }

    private List<? extends Step<?>> getSubSteps(Step<?> step) {
        if (step instanceof BigStep) {
            return ((BigStep)step).getSubSteps();
        }
        return Collections.emptyList();
    }

    private Step<?> computeBackInto(List<Step<?>> stepPath) {
        Step<?> currentStep;
        int idx;
        List<Step<?>> rootSteps = this.getSubSteps(this.trace.getRootStep());
        int depth = stepPath.size();
        Step result = null;
        if (depth > 1) {
            Step<?> currentStep2 = stepPath.get(depth - 1);
            Step parentStep = stepPath.get(depth - 2);
            SequentialStep parentStep_cast = (SequentialStep)parentStep;
            EList parentSubSteps = parentStep_cast.getSubSteps();
            int idx2 = parentSubSteps.indexOf(currentStep2);
            if (idx2 == 0) {
                result = parentStep;
            } else if (idx2 > 0) {
                SequentialStep tmpStep_cast;
                Step previousSiblingStep;
                Step tmpStep = previousSiblingStep = (Step)parentSubSteps.get(idx2 - 1);
                ArrayList tmpSubSteps = new ArrayList();
                tmpSubSteps.clear();
                if (tmpStep instanceof SequentialStep) {
                    tmpStep_cast = (SequentialStep)tmpStep;
                    tmpSubSteps.addAll(tmpStep_cast.getSubSteps());
                }
                while (!tmpSubSteps.isEmpty()) {
                    tmpStep = (Step)tmpSubSteps.get(tmpSubSteps.size() - 1);
                    tmpSubSteps.clear();
                    if (!(tmpStep instanceof SequentialStep)) continue;
                    tmpStep_cast = (SequentialStep)tmpStep;
                    tmpSubSteps.addAll(tmpStep_cast.getSubSteps());
                }
                result = tmpStep;
            }
        } else if (depth == 1 && (idx = rootSteps.indexOf(currentStep = stepPath.get(0))) > 0) {
            SequentialStep tmpStep_cast;
            Step tmpStep = rootSteps.get(idx - 1);
            ArrayList tmpSubSteps = new ArrayList();
            tmpSubSteps.clear();
            if (tmpStep instanceof SequentialStep) {
                tmpStep_cast = (SequentialStep)tmpStep;
                tmpSubSteps.addAll(tmpStep_cast.getSubSteps());
            }
            while (!tmpSubSteps.isEmpty()) {
                tmpStep = (Step)tmpSubSteps.get(tmpSubSteps.size() - 1);
                tmpSubSteps.clear();
                if (!(tmpStep instanceof SequentialStep)) continue;
                tmpStep_cast = (SequentialStep)tmpStep;
                tmpSubSteps.addAll(tmpStep_cast.getSubSteps());
            }
            result = tmpStep;
        }
        return result;
    }

    private Step<?> computeBackOver(List<Step<?>> stepPath) {
        Step<?> currentStep;
        int idx;
        List<Step<?>> rootSteps = this.getSubSteps(this.trace.getRootStep());
        int depth = stepPath.size();
        Object result = null;
        if (depth > 1) {
            Step<?> currentStep2 = stepPath.get(depth - 1);
            Step<?> parentStep = stepPath.get(depth - 2);
            BigStep parentStep_cast = (BigStep)parentStep;
            EList parentSubSteps = parentStep_cast.getSubSteps();
            int idx2 = parentSubSteps.indexOf(currentStep2);
            result = idx2 == 0 ? parentStep : (Step)parentSubSteps.get(idx2 - 1);
        } else if (depth == 1 && (idx = rootSteps.indexOf(currentStep = stepPath.get(0))) > 0) {
            result = rootSteps.get(idx - 1);
        }
        return result;
    }

    private Step<?> computeBackOut(List<Step<?>> stepPath) {
        if (stepPath.size() > 1) {
            return stepPath.get(stepPath.size() - 2);
        }
        return null;
    }

    private Step<?> computeStepInto(List<? extends Step<?>> stepPath, List<? extends Step<?>> rootSteps) {
        return this.findNextStep(stepPath, null, 0);
    }

    private Step<?> computeStepOver(List<? extends Step<?>> stepPath, List<? extends Step<?>> rootSteps) {
        if (!stepPath.isEmpty()) {
            return this.findNextStep(stepPath, stepPath.get(stepPath.size() - 1), 1);
        }
        return null;
    }

    private Step<?> computeStepReturn(List<? extends Step<?>> stepPath, List<? extends Step<?>> rootSteps) {
        if (stepPath.size() > 1) {
            return this.findNextStep(stepPath, stepPath.get(stepPath.size() - 2), 2);
        }
        return null;
    }

    private Step<?> findNextStep(List<? extends Step<?>> stepPath, Step<?> previousStep, int start) {
        int idx;
        List<Step<?>> rootSteps = this.getSubSteps(this.trace.getRootStep());
        Step result = null;
        int i = start;
        int depth = stepPath.size();
        Step<?> previous = previousStep;
        while (result == null && i < depth) {
            Step<?> currentStep = stepPath.get(depth - i - 1);
            ArrayList currentSubSteps = new ArrayList();
            if (currentStep instanceof BigStep) {
                currentSubSteps.addAll(((BigStep)currentStep).getSubSteps());
            }
            if (currentSubSteps.isEmpty()) {
                previous = currentStep;
            } else if (previous == null) {
                result = (Step)currentSubSteps.get(0);
            } else {
                int idx2 = currentSubSteps.indexOf(previous) + 1;
                if (idx2 < currentSubSteps.size()) {
                    result = (Step)currentSubSteps.get(idx2);
                } else {
                    previous = currentStep;
                }
            }
            ++i;
        }
        if (result == null && (idx = rootSteps.indexOf(previous) + 1) < rootSteps.size()) {
            result = rootSteps.get(idx);
        }
        return result;
    }

    private void computeExplorerState(List<Step<?>> stepPath) {
        List<? extends Step<?>> rootSteps = this.getSubSteps(this.trace.getRootStep());
        this.stepIntoResult = this.computeStepInto(stepPath, rootSteps);
        this.stepOverResult = this.computeStepOver(stepPath, rootSteps);
        this.stepReturnResult = this.computeStepReturn(stepPath, rootSteps);
        this.stepBackIntoResult = this.computeBackInto(stepPath);
        this.stepBackOverResult = this.computeBackOver(stepPath);
        this.stepBackOutResult = this.computeBackOut(stepPath);
        this.callStack.clear();
        this.callStack.addAll(stepPath);
        this.canBackValueCache.clear();
        this.canStepValueCache.clear();
    }

    private void goTo(State<?, ?> state) {
        if (state != null && this.stateManager != null) {
            this.stateManager.restoreState(state);
        }
    }

    private void jumpBeforeStep(Step<?> step) {
        if (step != null) {
            State state;
            this.currentState = state = step.getStartingState();
            this.goTo(this.currentState);
            this.updateCallStack(step);
        }
    }

    public void loadTrace(Trace<Step<?>, TracedObject<?>, State<?, ?>> trace) {
        this.trace = trace;
    }

    public void loadTrace(Trace<Step<?>, TracedObject<?>, State<?, ?>> trace, IStateManager<State<?, ?>> stateManager) {
        this.stateManager = stateManager;
        this.trace = trace;
    }

    public Step<?> getCurrentForwardStep() {
        if (!this.callStack.isEmpty()) {
            return this.callStack.get(this.callStack.size() - 1);
        }
        return null;
    }

    public Step<?> getCurrentBackwardStep() {
        return this.stepBackOverResult;
    }

    public Step<?> getCurrentBigStep() {
        return this.stepBackOutResult;
    }

    public void jump(State<?, ?> state) {
        if (state != null) {
            this.currentState = state;
            this.goTo(this.currentState);
            EList steps = this.currentState.getStartedSteps();
            Step step = steps.isEmpty() ? null : (Step)steps.get(0);
            this.updateCallStack(step);
        }
    }

    public void jump(Value<?> value) {
        EList states;
        if (value != null && !(states = value.getStates()).isEmpty()) {
            this.jump((State)states.get(0));
        }
    }

    private List<? extends Step<?>> getStepsForStates(int startingState, int endingState) {
        EList states = this.trace.getStates();
        Predicate<Step> predicate = arg_0 -> GenericTraceExplorer.lambda$0((List)states, startingState, endingState, arg_0);
        return this.getSubSteps(this.trace.getRootStep()).stream().filter(predicate).collect(Collectors.toList());
    }

    public void loadLastState() {
        int idx = this.trace.getStates().size() - 1;
        ArrayList steps = new ArrayList(this.getStepsForStates(idx, idx));
        Step lastStep = null;
        while (!steps.isEmpty()) {
            lastStep = (Step)steps.get(steps.size() - 1);
            steps.clear();
            if (!(lastStep instanceof BigStep)) continue;
            EList subSteps = ((BigStep)lastStep).getSubSteps();
            steps.addAll((Collection<Step<?>>)subSteps);
        }
        this.jumpBeforeStep(lastStep);
    }

    public boolean stepInto() {
        if (this.stepIntoResult != null) {
            this.jumpBeforeStep(this.stepIntoResult);
            return true;
        }
        return false;
    }

    public boolean stepOver() {
        if (this.stepOverResult != null) {
            this.jumpBeforeStep(this.stepOverResult);
            return true;
        }
        return false;
    }

    public boolean stepReturn() {
        if (this.stepReturnResult != null) {
            this.jumpBeforeStep(this.stepReturnResult);
            return true;
        }
        return false;
    }

    public boolean canStepBackInto() {
        return this.stepBackIntoResult != null;
    }

    public boolean canStepBackOver() {
        return this.stepBackOverResult != null;
    }

    public boolean canStepBackOut() {
        return this.stepBackOutResult != null;
    }

    public boolean stepBackInto() {
        if (this.stepBackIntoResult != null) {
            this.jumpBeforeStep(this.stepBackIntoResult);
            return true;
        }
        return false;
    }

    public boolean stepBackOver() {
        if (this.stepBackOverResult != null) {
            this.jumpBeforeStep(this.stepBackOverResult);
            return true;
        }
        return false;
    }

    public boolean stepBackOut() {
        if (this.stepBackOutResult != null) {
            this.jumpBeforeStep(this.stepBackOutResult);
            return true;
        }
        return false;
    }

    private Value<?> getCurrentValue(Dimension<?> dimension) {
        if (this.currentState == null) {
            return null;
        }
        return this.currentState.getValues().stream().filter(v -> ((Value)v).eContainer() == dimension).findFirst().orElse(null);
    }

    public boolean canStepValue(Dimension<?> dimension) {
        EList values;
        int idx;
        Boolean cachedValue = this.canStepValueCache.get(dimension);
        if (cachedValue != null) {
            return cachedValue;
        }
        Value<?> currentValue = this.getCurrentValue(dimension);
        boolean result = currentValue != null ? (idx = (values = dimension.getValues()).indexOf(currentValue)) < values.size() : false;
        this.canStepValueCache.put(dimension, result);
        return result;
    }

    public boolean canBackValue(Dimension<?> dimension) {
        EList values;
        int idx;
        Boolean cachedValue = this.canBackValueCache.get(dimension);
        if (cachedValue != null) {
            return cachedValue;
        }
        Value<?> currentValue = this.getCurrentValue(dimension);
        boolean result = currentValue != null ? (idx = (values = dimension.getValues()).indexOf(currentValue)) > 0 : false;
        this.canBackValueCache.put(dimension, result);
        return result;
    }

    public void stepValue(Dimension<?> dimension) {
        if (this.canStepValue(dimension)) {
            Value<?> currentValue = this.getCurrentValue(dimension);
            EList values = dimension.getValues();
            int idx = values.indexOf(currentValue);
            this.jump((Value)values.get(idx + 1));
        }
    }

    public void backValue(Dimension<?> dimension) {
        if (this.canBackValue(dimension)) {
            Value<?> currentValue = this.getCurrentValue(dimension);
            EList values = dimension.getValues();
            int idx = values.indexOf(currentValue);
            this.jump((Value)values.get(idx - 1));
        }
    }

    public boolean isInReplayMode() {
        return this.stepIntoResult != null;
    }

    public List<Step<?>> getCallStack() {
        return this.callStack;
    }

    public void updateCallStack(Step<?> step) {
        ArrayList newPath = new ArrayList();
        if (step != null) {
            newPath.add(step);
            EObject container = step.eContainer();
            while (container != null && container instanceof Step && container != this.trace.getRootStep()) {
                newPath.add(0, (Step)container);
                container = container.eContainer();
            }
            this.currentState = step.getStartingState();
        }
        this.computeExplorerState(newPath);
        this.notifyListeners();
    }

    public void notifyListeners() {
        for (Map.Entry<ITraceViewListener, Set<ITraceViewNotifier.TraceViewCommand>> entry : this.listeners.entrySet()) {
            entry.getValue().forEach(c -> c.execute());
        }
    }

    public void registerCommand(ITraceViewListener listener, ITraceViewNotifier.TraceViewCommand command) {
        if (listener != null) {
            Set<ITraceViewNotifier.TraceViewCommand> commands = this.listeners.get(listener);
            if (commands == null) {
                commands = new HashSet<ITraceViewNotifier.TraceViewCommand>();
                this.listeners.put(listener, commands);
            }
            commands.add(command);
        }
    }

    public void removeListener(ITraceViewListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void statesAdded(List<State<?, ?>> states) {
    }

    public void stepsStarted(List<Step<?>> steps) {
    }

    public void stepsEnded(List<Step<?>> steps) {
    }

    public void valuesAdded(List<Value<?>> values) {
    }

    public void dimensionsAdded(List<Dimension<?>> dimensions) {
    }

    public State<?, ?> getCurrentState() {
        return this.currentState;
    }

    private static /* synthetic */ boolean lambda$0(List list, int n, int n2, Step s) {
        int stepEndingIndex;
        State stepStartingState = s.getStartingState();
        State stepEndingState = s.getEndingState();
        int stepStartingIndex = list.indexOf(stepStartingState);
        int n3 = stepEndingIndex = stepEndingState == null ? -1 : list.indexOf(stepEndingState);
        return (stepEndingIndex == -1 || stepEndingIndex >= n) && stepStartingIndex <= n2;
    }
}

