/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.gemoc.generator.util.PluginProjectHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class StandaloneEMFProjectGenerator {
    protected final EPackage ecoreModel;
    protected final String projectName;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected IProject project;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final Set<GenPackage> referencedGenPackages = new HashSet<GenPackage>();
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final Set<EPackage> rootPackages = new HashSet<EPackage>();
    protected GenModel genModel;
    public static final String MODEL_GEN_FOLDER = "model";
    protected IProgressMonitor progressMonitor;
    protected ResourceSet resourceSet;
    protected URI modelGenFolderURI;
    protected String srcFolderPathString;
    protected Resource ecoreModelResource;
    private Set<GenModel> fixedGenModels = new HashSet<GenModel>();

    public void generateModelCode() {
        try {
            IRunnableWithProgress _function = m -> {
                try {
                    this.generateModelCode(m);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public StandaloneEMFProjectGenerator(String projectName, EPackage p) {
        this.ecoreModel = p;
        this.projectName = projectName;
    }

    public void generateBaseEMFProject(IProgressMonitor m) {
        try {
            this.progressMonitor = m;
            ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
            this.resourceSet = _resourceSetImpl;
            this.project = PluginProjectHelper.createPluginProject(this.projectName, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"src"})), Collections.unmodifiableList(CollectionLiterals.newArrayList()), Collections.unmodifiableSet(CollectionLiterals.newHashSet()), Collections.unmodifiableList(CollectionLiterals.newArrayList()), m);
            this.modelGenFolderURI = this.setupModelGenFolder();
            this.srcFolderPathString = this.setupSrcFolder();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(this.projectName);
            _builder.append("/");
            _builder.append(MODEL_GEN_FOLDER);
            _builder.append("/");
            String _name = this.ecoreModel.getName();
            _builder.append(_name);
            _builder.append(".ecore");
            this.ecoreModelResource = this.resourceSet.createResource(URI.createPlatformResourceURI((String)_builder.toString(), (boolean)true));
            this.ecoreModelResource.getContents().add((Object)this.ecoreModel);
            this.save(this.ecoreModelResource);
            this.ecoreModelResource.unload();
            this.ecoreModelResource.load(null);
            this.ecoreModelResource.unload();
            this.ecoreModelResource.load(null);
            this.checkReferencedPackages(this.ecoreModelResource);
            EObject _get = (EObject)this.ecoreModelResource.getContents().get(0);
            this.genModel = this.generateGenModel((EPackage)_get, this.modelGenFolderURI);
            this.rootPackages.addAll(IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)this.ecoreModelResource.getContents(), EPackage.class)));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void generateModelCode(IProgressMonitor m) throws Exception {
        this.generateCode(this.progressMonitor);
    }

    private URI setupModelGenFolder() {
        boolean _not;
        URI modelGenFolderURI = null;
        IFolder modelGenFolder = this.project.getFolder(MODEL_GEN_FOLDER);
        boolean _exists = modelGenFolder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                modelGenFolder.create(true, true, null);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The folder '");
                    _builder.append(MODEL_GEN_FOLDER);
                    _builder.append("' could not be created.");
                    throw new RuntimeException(_builder.toString(), (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        modelGenFolderURI = URI.createPlatformResourceURI((String)modelGenFolder.getFullPath().toString(), (boolean)true);
        return modelGenFolderURI;
    }

    private String setupSrcFolder() {
        boolean _not;
        String srcFolderPathString = null;
        IFolder srcFolder = this.project.getFolder("src");
        boolean _exists = srcFolder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                srcFolder.create(true, true, null);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    throw new RuntimeException("The source folder 'src' could not be created.", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        srcFolderPathString = srcFolder.getFullPath().toString();
        return srcFolderPathString;
    }

    private void checkReferencedPackages(Resource xmofModelResource) {
        boolean _greaterThan;
        HashSet<URI> missingPackages = new HashSet<URI>();
        Map externalCrossReferences = EcoreUtil.ExternalCrossReferencer.find((Resource)xmofModelResource);
        Set _keySet = externalCrossReferences.keySet();
        for (EObject eObject : _keySet) {
            boolean _eIsProxy = eObject.eIsProxy();
            if (!_eIsProxy) continue;
            missingPackages.add(EcoreUtil.getURI((EObject)eObject).trimFragment());
        }
        int _size = missingPackages.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _xifexpression = null;
            int _size_1 = missingPackages.size();
            boolean _equals = _size_1 == 1;
            _xifexpression = _equals ? "" : "s";
            String _plus = "Unable to load the following referenced resource" + _xifexpression;
            String _plus_1 = String.valueOf(_plus) + ": ";
            String _string = ((Object)missingPackages).toString();
            String message = String.valueOf(_plus_1) + _string;
            throw new RuntimeException(message);
        }
    }

    protected GenModel generateGenModel(EPackage rootEPackage, URI modelGenFolderURI) {
        Resource genModelResource = this.createGenModel(rootEPackage);
        EObject _get = (EObject)genModelResource.getContents().get(0);
        GenModel genModel = (GenModel)_get;
        this.setInitializeByLoad(genModel);
        this.save(genModelResource);
        return genModel;
    }

    protected Resource createGenModel(EPackage rootEPackage) {
        Resource ecoreModelResource = rootEPackage.eResource();
        String genModelFileName = ecoreModelResource.getURI().trimFileExtension().appendFileExtension("genmodel").lastSegment().toString();
        URI genModelURI = this.modelGenFolderURI.appendSegment(genModelFileName);
        Resource genModelResource = this.resourceSet.createResource(genModelURI);
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModelResource.getContents().add((Object)genModel);
        IFolder srcFolder = this.project.getFolder("src");
        genModel.setModelDirectory(srcFolder.getFullPath().toString());
        genModel.getForeignModel().add((Object)ecoreModelResource.getURI().toString());
        genModel.setModelName(this.getModelName(genModelURI));
        genModel.setModelPluginID(this.getPluginID(genModelURI));
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
        genModel.setComplianceLevel(this.getComplicanceLevel());
        genModel.setImportOrganizing(true);
        genModel.initialize(Collections.singleton(rootEPackage));
        this.setMissingParameterTypes(genModel);
        this.fixUsedGenPackages(genModel);
        return genModelResource;
    }

    private void fixUsedGenPackages(GenModel genModel) {
        boolean _not;
        boolean _contains = this.fixedGenModels.contains(genModel);
        boolean bl = _not = !_contains;
        if (_not) {
            this.fixedGenModels.add(genModel);
            Functions.Function1 _function = p -> {
                GenModel _genModel = p.getGenModel();
                return Objects.equal((Object)_genModel, null);
            };
            CollectionExtensions.removeAll((Collection)genModel.getUsedGenPackages(), (Iterable)IterableExtensions.filter((Iterable)ImmutableList.copyOf((Collection)genModel.getUsedGenPackages()), (Functions.Function1)_function));
            List<GenPackage> missingGenPackages = this.computeMissingGenPackages(genModel);
            for (GenPackage genPackage : missingGenPackages) {
                this.fixUsedGenPackages(genPackage.getGenModel());
            }
            this.referencedGenPackages.addAll(missingGenPackages);
            this.referencedGenPackages.addAll((Collection<GenPackage>)genModel.getGenPackages());
            genModel.getUsedGenPackages().addAll(missingGenPackages);
        }
    }

    protected String getModelName(URI genModelURI) {
        String genModelFileName = genModelURI.trimFileExtension().lastSegment();
        String _upperCase = genModelFileName.substring(0, 1).toUpperCase();
        String _substring = genModelFileName.substring(1);
        String modelName = String.valueOf(_upperCase) + _substring;
        return modelName;
    }

    protected String getPluginID(URI uri) {
        String pluginID = "";
        IFile manifestFile = this.project.getFolder("META-INF").getFile("MANIFEST.MF");
        try {
            boolean _notEquals;
            InputStream _contents = manifestFile.getContents();
            Manifest manifest = new Manifest(_contents);
            String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            boolean bl = _notEquals = !Objects.equal((Object)symbolicName, null);
            if (_notEquals) {
                int index = symbolicName.indexOf(";");
                if (index > 0) {
                    symbolicName = symbolicName.substring(0, index);
                }
                pluginID = symbolicName.trim();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _string = manifestFile.getFullPath().toString();
                String _plus = "Could not find manifest file '" + _string;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return pluginID;
    }

    private GenJDKLevel getComplicanceLevel() {
        String complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)this.project);
        boolean _equals = "1.4".equals(complianceLevel);
        if (_equals) {
            return GenJDKLevel.JDK14_LITERAL;
        }
        boolean _equals_1 = "1.5".equals(complianceLevel);
        if (_equals_1) {
            return GenJDKLevel.JDK50_LITERAL;
        }
        boolean _equals_2 = "1.6".equals(complianceLevel);
        if (_equals_2) {
            return GenJDKLevel.JDK60_LITERAL;
        }
        boolean _equals_3 = "1.7".equals(complianceLevel);
        if (_equals_3) {
            return GenJDKLevel.JDK70_LITERAL;
        }
        return GenJDKLevel.JDK80_LITERAL;
    }

    private void setMissingParameterTypes(GenModel genModel) {
        Set _set = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)genModel.eAllContents(), GenParameter.class));
        for (GenParameter genModelElement : _set) {
            GenParameter genParameter = genModelElement;
            EParameter ecoreParameter = genParameter.getEcoreParameter();
            EClassifier _eType = ecoreParameter.getEType();
            boolean _equals = Objects.equal((Object)_eType, null);
            if (!_equals) continue;
            ecoreParameter.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        }
    }

    protected List<GenPackage> computeMissingGenPackages(GenModel genModel) {
        UniqueEList missingGenPackages = new UniqueEList();
        Map genModelLocationMapTargetEnvironment = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
        Map genModelLocationMapEnvironment = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
        List _missingPackages = genModel.getMissingPackages();
        for (EPackage ePackage : _missingPackages) {
            boolean _equals_1;
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)ePackage, null);
            if (!_notEquals) continue;
            URI missingGenModelURI = (URI)genModelLocationMapEnvironment.get(ePackage.getNsURI());
            boolean _equals = Objects.equal((Object)missingGenModelURI, null);
            if (_equals) {
                missingGenModelURI = (URI)genModelLocationMapTargetEnvironment.get(ePackage.getNsURI());
            }
            if (_equals_1 = Objects.equal((Object)missingGenModelURI, null)) {
                String _nsURI = ePackage.getNsURI();
                String _plus = "Unable to load generator model of required package '" + _nsURI;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1);
            }
            Resource missingGenModelResource = null;
            try {
                missingGenModelResource = this.resourceSet.getResource(missingGenModelURI, true);
            }
            catch (Throwable _t) {
                if (_t instanceof RuntimeException) {
                    String _nsURI_1 = ePackage.getNsURI();
                    String _plus_2 = "Unable to load generator model of required package '" + _nsURI_1;
                    String _plus_3 = String.valueOf(_plus_2) + "'.";
                    throw new RuntimeException(_plus_3);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            EObject _get = (EObject)missingGenModelResource.getContents().get(0);
            GenModel missingGenModel = (GenModel)_get;
            missingGenPackages.addAll(missingGenModel.getGenPackages());
        }
        return missingGenPackages;
    }

    protected void setInitializeByLoad(GenModel genModel) {
        EList _genPackages = genModel.getGenPackages();
        for (GenPackage genPackage : _genPackages) {
            this.setInitializeByLoad(genPackage);
        }
    }

    private void setInitializeByLoad(GenPackage genPackage) {
        genPackage.setLoadInitialization(false);
        List _subGenPackages = genPackage.getSubGenPackages();
        for (GenPackage subGenPackage : _subGenPackages) {
            this.setInitializeByLoad(subGenPackage);
        }
    }

    private List<Diagnostic> expandDiagnostics(Diagnostic d) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        result.add(d);
        result.addAll(d.getChildren());
        List _children = d.getChildren();
        for (Diagnostic c : _children) {
            result.addAll(this.expandDiagnostics(c));
        }
        return result;
    }

    private String exceptionToStackString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter _printWriter = new PrintWriter(sw);
        e.printStackTrace(_printWriter);
        String exceptionAsString = sw.toString();
        return exceptionAsString;
    }

    private String diagnosticErrorsToString(Diagnostic diagnostic) {
        Functions.Function1 _function = d -> {
            int _severity = d.getSeverity();
            return _severity == 4;
        };
        Set errors = IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.expandDiagnostics(diagnostic), (Functions.Function1)_function));
        Functions.Function1 _function_1 = e -> {
            Throwable _exception = e.getException();
            return !Objects.equal((Object)_exception, null);
        };
        Functions.Function1 _function_2 = e -> this.exceptionToStackString(e.getException());
        Set exceptions = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)errors, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String e2 : exceptions) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("Encountered exceptions:\n");
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.append("- ");
            _builder.append(e2);
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        boolean _hasElements_1 = false;
        for (Diagnostic e_1 : errors) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
                _builder.append("Encountered diagnostic errors:\n");
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.append("- ");
            String _message = e_1.getMessage();
            _builder.append(_message);
            _builder.append(" ");
            _builder.append("\t\t\t");
        }
        if (_hasElements_1) {
            _builder.append("\n");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected void generateCode(IProgressMonitor progressMonitor) throws Exception {
        boolean success = false;
        this.prepareGenModelForCodeGeneration(this.genModel);
        Generator generator = GenModelUtil.createGenerator((GenModel)this.genModel);
        boolean canGenerate = generator.canGenerate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot generate code of EPackage ");
        String _name = this.ecoreModel.getName();
        _builder.append(_name);
        String message = _builder.toString();
        if (canGenerate) {
            Diagnostic diagnostic = null;
            String otherMessage = "";
            try {
                diagnostic = generator.generate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    otherMessage = this.exceptionToStackString(t);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (!Objects.equal((Object)diagnostic, null) && diagnostic.getSeverity() == 0) {
                success = true;
            } else {
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)diagnostic, null);
                if (_notEquals) {
                    String _message = message;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(": ");
                    String _diagnosticErrorsToString = this.diagnosticErrorsToString(diagnostic);
                    _builder_1.append(_diagnosticErrorsToString);
                    _builder_1.append(".");
                    message = String.valueOf(_message) + _builder_1;
                } else {
                    String _message_1 = message;
                    message = String.valueOf(_message_1) + otherMessage;
                }
            }
        } else {
            String _message_2 = message;
            message = String.valueOf(_message_2) + "generator.canGenerate returns false.";
        }
        if (!success) {
            throw new Exception(message);
        }
    }

    protected void prepareGenModelForCodeGeneration(GenModel genModel) {
        genModel.reconcile();
        genModel.setCanGenerate(true);
    }

    private void save(Resource resource) {
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                URI _uRI = resource.getURI();
                String _plus = "Could not save resource '" + _uRI;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Pure
    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    @Pure
    public Set<GenPackage> getReferencedGenPackages() {
        return this.referencedGenPackages;
    }

    @Pure
    public Set<EPackage> getRootPackages() {
        return this.rootPackages;
    }
}

