/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.pages.AskMoCInfoWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class CreateNewMoCProject
extends Wizard
implements INewWizard {
    public WizardNewProjectCreationPage _askProjectNamePage;
    public AskMoCInfoWizardPage _askMoCInfoPage;
    private IProject createdProject = null;
    public String createdProjectName = "";
    public String createdTemplateMoCFile = "";

    public CreateNewMoCProject() {
        this.setWindowTitle("Create MoCCML project");
        this._askProjectNamePage = new WizardNewProjectCreationPage("NewProjectName");
        this._askProjectNamePage.setTitle("Project");
        this._askProjectNamePage.setDescription("Create a new MoCCML Project");
        this.addPage((IWizardPage)this._askProjectNamePage);
        this._askMoCInfoPage = new AskMoCInfoWizardPage("NewMoCInfo");
        this._askMoCInfoPage.setTitle("MoCCML");
        this._askMoCInfoPage.setDescription("Specify the MoCC");
        this.addPage((IWizardPage)this._askMoCInfoPage);
    }

    public void addPages() {
        super.addPages();
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this._askMoCInfoPage && this._askMoCInfoPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.createdProject = this._askProjectNamePage.getProjectHandle();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.createdProject.getName());
            if (!this._askProjectNamePage.getLocationPath().equals((Object)workspace.getRoot().getLocation())) {
                description.setLocation(this._askProjectNamePage.getLocationPath());
            }
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    CreateNewMoCProject.this.createdProject.create(description, monitor);
                    CreateNewMoCProject.this.createdProject.open(monitor);
                    try {
                        PluginConverter.convert((IProject)CreateNewMoCProject.this.createdProject);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String filePath = "mocc/" + CreateNewMoCProject.this._askMoCInfoPage.getTemplateMoCFileNameFile() + ".moccml";
                    IProjectUtils.createFile((IProject)CreateNewMoCProject.this.createdProject, (String)filePath, (String)("AutomataConstraintLibrary " + CreateNewMoCProject.this._askMoCInfoPage.getTemplateMoCFileNameFile().toString() + "{ \n\n}"), (IProgressMonitor)monitor);
                    CreateNewMoCProject.this.createdProjectName = CreateNewMoCProject.this._askProjectNamePage.getProjectName();
                    CreateNewMoCProject.this.createdTemplateMoCFile = CreateNewMoCProject.this._askMoCInfoPage.getTemplateMoCFileNameFile();
                    CreateNewMoCProject.this.createdProject.refreshLocal(2, monitor);
                    CreateNewMoCProject.this.createdProject.touch((IProgressMonitor)new NullProgressMonitor());
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (CoreException exception) {
            Activator.error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public IProject getCreatedProject() {
        return this.createdProject;
    }
}

