/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.AbstractProjectNature;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.jdt.JavaProject;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.osgi.framework.BundleException;

public class MoccmlLanguageProjectNature
extends AbstractProjectNature {
    public static final String NATURE_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.MoccmlLanguageProjectNature";

    public void configure() throws CoreException {
        this.requirementConfigure();
        this.addBuilder("org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.MoccmlLanguageProjectBuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeBuilder("org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.MoccmlLanguageProjectBuilder");
    }

    public void requirementConfigure() throws CoreException {
        try {
            IProject project = this.getProject();
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectNature");
            JavaProject.create((IProject)project);
            this.addPluginNature(project);
            JavaProject.addSourceFolder((IProject)project, (String)"xdsml-java-gen/");
            this.addGemocResourcesToBuildProperties(project);
            this.updateManifestFile(project);
        }
        catch (IOException e) {
            Activator.error("Problem while adding Gemoc Language nature to project. " + e.getMessage(), e);
        }
    }

    private void addPluginNature(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            try {
                PluginXMLHelper.createEmptyTemplateFile((IFile)project.getFile("plugin.xml"), (boolean)false);
                PluginConverter.convert((IProject)project);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.error("cannot add org.eclipse.pde.PluginNature nature to project due to " + e.getMessage(), e);
            }
        }
    }

    private void updateManifestFile(IProject project) {
        ManifestChanger changer = new ManifestChanger(project);
        try {
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare");
            changer.commit();
        }
        catch (IOException | CoreException | BundleException e) {
            Activator.error("Failed to update manifest " + e.getMessage(), e);
        }
    }

    private void addGemocResourcesToBuildProperties(IProject project) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = project.getFile("build.properties").getContents();
            properties.load(inputStream);
            String binIncludes = properties.getProperty("bin.includes");
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            properties.store(out, "");
            out.close();
            project.getFile("build.properties").setContents((InputStream)in, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            Activator.error(e1.getMessage(), e1);
        }
        catch (IOException e) {
            Activator.error(e.getMessage(), e);
        }
    }
}

