/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.api.Containment;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jdom2.Element;
import org.osgi.framework.BundleException;

public class MoccmlLanguageProjectBuilder
extends IncrementalProjectBuilder {
    private Set<String> setAspectsWithRTDs = null;
    HashMap<String, String> mapAspectizedClass = new HashMap();
    Multimap<String, SourceField> mapAspectProperties = null;
    Multimap<String, Field> mapAspectFieldProperties = null;
    HashMap<SourceField, Containment.ContainmentStrategy> mapFieldContainmentStrategy = null;
    public static final String BUILDER_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.MoccmlLanguageProjectBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    public void checkConsistency(IResource resource) {
    }

    private void updateProjectPluginConfiguration(IResource resource) {
        if (resource instanceof IFile && resource.getFileExtension().equals("dsl")) {
            IFile file = (IFile)resource;
            IProject project = file.getProject();
            if (file.exists()) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource res = rs.getResource(uri, true);
                Dsl root = (Dsl)res.getContents().get(0);
                String packageName = root.getName();
                ManifestChanger manifestChanger = new ManifestChanger(project);
                String languageName = "null";
                String eclFileName = "null";
                for (Entry anEntry : root.getEntries()) {
                    if (anEntry.getKey().compareTo("name") == 0) {
                        languageName = anEntry.getValue();
                        try {
                            this.setPluginLanguageNameAndFilePath(project, file, languageName);
                            this.updateCodeExecutorClass(project, languageName, manifestChanger);
                            this.updateModelLoaderClass(project, languageName, null);
                            this.updateSolverClass(project, languageName, null);
                        }
                        catch (IOException | CoreException | BundleException e) {
                            Activator.error(e.getMessage(), e);
                        }
                    }
                    if (anEntry.getKey().compareTo("ecl") == 0) {
                        eclFileName = anEntry.getValue();
                        this.updateQVTO(project, languageName, eclFileName, null);
                    }
                    if (anEntry.getKey().compareTo("k3") != 0) continue;
                    try {
                        String k3AspectListString = anEntry.getValue();
                        this.populateK3AspectMaps(k3AspectListString);
                        this.createLanguageSpecificDSAHelper(k3AspectListString, project, languageName, manifestChanger);
                        this.createLanguageSpecificModelStateHelper(k3AspectListString, project, languageName, manifestChanger);
                    }
                    catch (IOException | ClassNotFoundException | CoreException | BundleException e) {
                        Activator.error(e.getMessage(), e);
                    }
                }
                try {
                    manifestChanger.addPluginDependency("org.eclipse.gemoc.executionframework.extensions.sirius");
                    manifestChanger.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate");
                    manifestChanger.commit();
                }
                catch (IOException | CoreException | BundleException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
        }
    }

    private void createLanguageSpecificModelStateHelper(String value, IProject project, String fullLanguageName, ManifestChanger manifestChanger) {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = MoccmlLanguageProjectBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = MoccmlLanguageProjectBuilder.getPackageName(languageName);
        String folderName = MoccmlLanguageProjectBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, copy it first */\npackage ${package.name};\nimport java.io.Serializable;\nimport java.lang.reflect.Method;\nimport java.util.Collection;\nimport java.util.HashSet;\nimport java.util.Map;import java.lang.reflect.InvocationTargetException;\nimport org.eclipse.emf.common.util.TreeIterator;\nimport org.eclipse.emf.ecore.EObject;\nimport org.eclipse.emf.ecore.EStructuralFeature.Setting;\nimport org.eclipse.emf.ecore.resource.Resource;\nimport org.eclipse.emf.ecore.util.EcoreUtil;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.ElementState;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelState;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelStateFactory;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.helper.IK3ModelStateHelper;import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils.Copier;import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.List;\n${extraImports}\n\npublic class ${language.name.toupperfirst}ModelStateHelper implements IK3ModelStateHelper{\n\tprivate static class AttributeNameToValue implements Serializable{\n\n\t\tprivate static final long serialVersionUID = 0;\t\tString name;\n\t\tObject value;\n\t\tpublic AttributeNameToValue(String n, Object v) {\n\t\t\tname = n;\n\t\t\tvalue = v;\n\t\t}\n\n\n\t\t@Override\n\t\tpublic boolean equals(Object obj) {\n\t\t\tif (! (obj instanceof AttributeNameToValue)) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tAttributeNameToValue a2n = (AttributeNameToValue)obj;\n\t\t\tif (this.name.compareTo(a2n.name) != 0) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tif (this.value == null) {\n\t\t\t\treturn a2n.value == null;\n\t\t\t}\n\t\t\tif (!this.value.equals(a2n.value)) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn true;\n\t\t}\t}\n\t\tK3ModelStateFactory theFactory = K3ModelStateFactory.eINSTANCE; \n${saveAndRestoreMethod}\n\n\tpublic void restoreModelState(K3ModelState state) {\n\t\tfor(ElementState elemState : state.getOwnedElementstates()) {\n\t\t\tfor(Object o : elemState.getSavedRTDs()) {\n\t\t\t\tAttributeNameToValue n2v = (AttributeNameToValue)o;\n\t\t\t\tMethod setter = null;\n\t\t\t\tsetter = getRestorePropertySetter(elemState.getModelElement().getClass(), n2v);\n\t\t\t\ttry {\n\t\t\t\t\tsetter.invoke(null, elemState.getModelElement(), n2v.value);\n\t\t\t\t} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n\n\n\tprivate Method getRestorePropertySetter(Class<?> targetClass, AttributeNameToValue n2v) {\n\t\tMethod setter = null;\n\t\ttry {\n\t\t\tfor(Method m2 : ${language.name.toupperfirst}RTDAccessor.class.getMethods()) {\n\t\t\t\tif(m2.getName().equals(\"restoreProperty_\"+n2v.name) && m2.getParameterTypes().length == 2) {\n\t\t\t\t\tif(m2.getParameterTypes()[0].isAssignableFrom(targetClass) &&\n\t\t\t\t\t\t\t(n2v.value == null || m2.getParameterTypes()[1].isAssignableFrom(n2v.value.getClass()))\t) {\n\t\t\t\t\t\tsetter = m2;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (setter == null) {\n\t\t\t\tthrow new RuntimeException(\"no method found for restoreProperty_\"+n2v.name+\"(\"+targetClass+\", \"+n2v.value.getClass().getName()+\")\");\n\t\t\t}\n\t\t\treturn setter;\n\t\t} catch (SecurityException | IllegalArgumentException e) {\n\t\t\tthrow new RuntimeException(\"no method found for set\"+n2v.name+\"(\"+targetClass+\", \"+n2v.value.getClass().getName()+\")\");\n\t\t}\n\t}\n\t\n\tpublic static List<Class> getSuperClasses(Class c) {\n\t\tList<Class> r = new ArrayList<>();\n\t\tList<Class> q = new ArrayList<>();\n\t\tq.add(c);\n\t\twhile (!q.isEmpty()) {\n\t\t\tc = q.remove(0);\n\t\t\tr.add(c);\n\t\t\tif (c.getSuperclass() != null) {\n\t\t\t\tq.add(c.getSuperclass());\n\t\t\t}\n\t\t\tfor (Class i : c.getInterfaces()) {\n\t\t\t\tq.add(i);\n\t\t\t}\n\t\t}\n\t\treturn r;\n\t}\n};";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbExtraImport = new StringBuilder();
        sbContent.append("\n\tpublic K3ModelState getK3StateSpaceModelState(EObject model) {\n\t\treturn getK3ModelState(model, false);\n\t}\n\t\n\tpublic K3ModelState getK3ModelState(EObject model) {\n\t\treturn getK3ModelState(model, true);\n\t}\n\t\t\n\tpublic K3ModelState getK3ModelState(EObject model, boolean allRTDs) {\n\t\tK3ModelState res = theFactory.createK3ModelState();\n\n\t\t// consider indirectly referenced models (ugly and probably not efficient)\n\t\tArrayList<EObject> allElements = new ArrayList<EObject>();\n\t\tmodel.eAllContents().forEachRemaining(x -> allElements.add(x));\n\t\tMap<EObject, Collection<Setting>> f = EcoreUtil.CrossReferencer.find(allElements);\n\t\tHashSet<Resource> consideredResources = new HashSet<Resource>();\n\t\tconsideredResources.add(model.eResource());\n\t\tf.keySet().forEach(eo -> consideredResources.add(eo.eResource()));\n\t\t\n\t\tfor(Resource resource : consideredResources) {\n\t\t\tTreeIterator<EObject> allContentIt = resource.getAllContents();\n\t\t\twhile (allContentIt.hasNext()) {\n\t\t\t\tEObject elem = allContentIt.next();\n\n");
        sbContent.append("\t\t\t\tClass<?> clazz =null;\n");
        for (String aspectName : this.setAspectsWithRTDs) {
            sbContent.append("\t\t\t\tclazz = K3DslHelper.getTarget(" + aspectName + ".class);\n" + "\t\t\t\tif (clazz.isInstance(elem)) {\n" + "\t\t\t\t\tElementState elemState = theFactory.createElementState();\n" + "\t\t\t\t\telemState.setModelElement(elem);\n" + "\t\t\t\t\tres.getOwnedElementstates().add(elemState);\n" + "\t\t\t\t\tObject propertyValue = null;\n");
            int i = 0;
            for (SourceField property : this.mapAspectProperties.get((Object)aspectName)) {
                IAnnotation annotation;
                String indent = "";
                if (property.getAnnotation("NotInStateSpace").exists()) {
                    sbContent.append("\t\t\t\t\tif (allRTDs) {  //property not in state space:" + property.getElementName() + "\n");
                    indent = "\t";
                }
                if ((annotation = property.getAnnotation("Containment")) != null) {
                    sbContent.append("\t\t\t\t\t// Annotation " + this.mapFieldContainmentStrategy.get(property) + "\n");
                }
                sbContent.append(String.valueOf(indent) + "\t\t\t\t\tpropertyValue = " + languageToUpperFirst + "RTDAccessor.saveProperty_" + property.getElementName() + "((" + this.mapAspectizedClass.get(aspectName) + ")elem);\n");
                sbContent.append(String.valueOf(indent) + "\t\t\t\t\tAttributeNameToValue n2v" + i + " = new AttributeNameToValue(\"" + property.getElementName() + "\", propertyValue);\n");
                sbContent.append(String.valueOf(indent) + "\t\t\t\t\telemState.getSavedRTDs().add(n2v" + i + ");\n");
                ++i;
                if (!property.getAnnotation("NotInStateSpace").exists()) continue;
                sbContent.append("\t\t\t\t\t}\n");
            }
            sbContent.append("\t\t\t\t}\n");
        }
        sbContent.append("\t\t\t}\n\t\t}\n\t\treturn res;\n\t}\n");
        fileContent = fileContent.replaceAll(Pattern.quote("${saveAndRestoreMethod}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${extraImports}"), sbExtraImport.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "ModelStateHelper" + ".java");
        MoccmlLanguageProjectBuilder.writeFile(file, fileContent);
    }

    protected void populateK3AspectMaps(String allAspects) throws CoreException, BundleException, IOException {
        this.setAspectsWithRTDs = new HashSet<String>();
        this.mapAspectProperties = ArrayListMultimap.create();
        this.mapAspectFieldProperties = ArrayListMultimap.create();
        this.mapAspectizedClass = new HashMap();
        this.mapFieldContainmentStrategy = new HashMap();
        String[] stringArray = allAspects.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block29: {
                IType aspectIType;
                String aspectClassName;
                block28: {
                    String simpleName;
                    char[][] qualifications;
                    aspectClassName = stringArray[n2];
                    int dot = aspectClassName.lastIndexOf(46);
                    String aspectPropertiesClassName = String.valueOf(aspectClassName) + aspectClassName.substring(dot + 1) + "Properties";
                    if (dot != -1) {
                        qualifications = new char[][]{aspectPropertiesClassName.substring(0, dot).toCharArray()};
                        simpleName = aspectPropertiesClassName.substring(dot + 1);
                    } else {
                        qualifications = null;
                        simpleName = aspectPropertiesClassName;
                    }
                    char[][] typeNames = new char[][]{simpleName.toCharArray()};
                    aspectIType = MoccmlLanguageProjectBuilder.findAnyTypeInWorkspace(qualifications, typeNames);
                    if (aspectIType != null) break block28;
                    System.err.println("type \"" + simpleName + "\" not found");
                    break block29;
                }
                IJavaProject aspectProject = aspectIType.getJavaProject();
                String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)aspectProject);
                ArrayList<URL> urlList = new ArrayList<URL>();
                int i = 0;
                while (i < classPathEntries.length) {
                    String entry = classPathEntries[i];
                    Path path = new Path(entry);
                    URL url = path.toFile().toURI().toURL();
                    urlList.add(url);
                    ++i;
                }
                try {
                    ClassLoader parentClassLoader = aspectProject.getClass().getClassLoader();
                    URL[] urls = urlList.toArray(new URL[urlList.size()]);
                    URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
                    Class<?> aspectClass = classLoader.loadClass(aspectIType.getFullyQualifiedName());
                    try {
                        String aspectizedClassName = this.getAspectizedClassCanonicalName(classLoader, aspectClassName);
                        this.mapAspectizedClass.put(aspectClassName, aspectizedClassName);
                        IJavaElement[] allChildren = aspectIType.getChildren();
                        int i2 = 0;
                        while (i2 < allChildren.length) {
                            block27: {
                                IJavaElement javaElem = allChildren[i2];
                                if (!(javaElem instanceof SourceField)) break block27;
                                this.setAspectsWithRTDs.add(aspectClassName);
                                SourceField sf = (SourceField)javaElem;
                                this.mapAspectProperties.put((Object)aspectClassName, (Object)sf);
                                try {
                                    block30: {
                                        Field f = aspectClass.getField(sf.getElementName());
                                        this.mapAspectFieldProperties.put((Object)aspectClassName, (Object)f);
                                        Optional<Annotation> annotation = Arrays.asList(f.getAnnotations()).stream().filter(a -> a.annotationType().getCanonicalName().equals(Containment.class.getCanonicalName())).findFirst();
                                        if (!annotation.isPresent()) break block30;
                                        Method m = annotation.get().annotationType().getMethod("value", new Class[0]);
                                        Object o = m.invoke((Object)annotation.get(), new Object[0]);
                                        switch (o.toString()) {
                                            case "CONTAINER": {
                                                this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.CONTAINER);
                                                break;
                                            }
                                            case "REFERENCE": {
                                                this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.REFERENCE);
                                                break;
                                            }
                                            case "MAP_KEYCONTAINMENT_VALUEREFERENCE": {
                                                this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.MAP_KEYCONTAINMENT_VALUEREFERENCE);
                                                break;
                                            }
                                            case "MAP_KEYREFERENCE_VALUECONTAINMENT": {
                                                this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.MAP_KEYREFERENCE_VALUECONTAINMENT);
                                                break;
                                            }
                                            default: {
                                                this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.CONTAINER);
                                                break;
                                            }
                                        }
                                        break block27;
                                    }
                                    this.mapFieldContainmentStrategy.put(sf, Containment.ContainmentStrategy.CONTAINER);
                                }
                                catch (NoSuchFieldException e) {
                                    Activator.error("Cannot generate getter and setter for aspect property " + aspectIType.getFullyQualifiedName() + " " + sf.getElementName(), e);
                                }
                            }
                            ++i2;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                        Activator.error("Cannot generate getter and setter for aspect " + aspectIType.getFullyQualifiedName(), e1);
                    }
                    classLoader.close();
                }
                catch (ClassNotFoundException e2) {
                    Activator.error("Cannot generate getter and setter for aspect " + aspectIType.getFullyQualifiedName(), e2);
                }
            }
            ++n2;
        }
    }

    protected void createLanguageSpecificDSAHelper(String allAspects, IProject project, String fullLanguageName, ManifestChanger manifestChanger) throws CoreException, BundleException, IOException, ClassNotFoundException {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = MoccmlLanguageProjectBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = MoccmlLanguageProjectBuilder.getPackageName(languageName);
        String folderName = MoccmlLanguageProjectBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, copy it first */\npackage ${package.name};\nimport org.eclipse.emf.ecore.EObject;\nimport java.lang.reflect.InvocationTargetException;\nimport java.util.List;\nimport java.lang.reflect.Method;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils.Copier;\nimport org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;\n${extraImports}\n\npublic class ${language.name.toupperfirst}RTDAccessor {\n${allGettersAndSetters}\n\tpublic static Object getAspectProperty(EObject eObject, String languageName, String aspectName, String propertyName) {\n\t\tList<Class<?>> aspects = K3DslHelper.getAspectsOn(languageName, eObject.getClass());\n\t\tClass<?> aspect = null;\n\t\tfor (Class<?> a : aspects) {\n\t\t\ttry {\n\t\t\t\tif (Class.forName(aspectName).isAssignableFrom(a)) {\n\t\t\t\t\taspect = a;\n\t\t\t\t}\n\t\t\t} catch (ClassNotFoundException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t}\n\t\tif (aspect == null) {\n\t\t\treturn null;\n\t\t}\n\t\tObject res = null;\n\t\t try {\n\t\t\tres = aspect.getDeclaredMethod(propertyName, ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).className()).invoke(eObject, eObject);\n\t\t\treturn res;\n\t\t} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException\n\t\t\t\t\t| NoSuchMethodException | SecurityException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\n\t\treturn null;\n\t}\n\t\n\t\npublic static boolean setAspectProperty(EObject eObject, String languageName, String aspectName, String propertyName, Object newValue) {\n\t\tList<Class<?>> aspects = K3DslHelper.getAspectsOn(languageName, eObject.getClass());\n\t\tClass<?> aspect = null;\n\t\tfor (Class<?> a : aspects) {\n\t\t\ttry {\n\t\t\t\tif (Class.forName(aspectName).isAssignableFrom(a)) {\n\t\t\t\t\taspect = a;\n\t\t\t\t}\n\t\t\t} catch (ClassNotFoundException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\tif (aspect == null) {\n\t\t\treturn false;\n\t\t}\n\t\t Method m = getSetter(propertyName,newValue,aspect);\n\t\t try {\n\t\t\tm.invoke(eObject, eObject, newValue);\n\t\t\treturn true;\n\t\t} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n\t\t\te.printStackTrace();\n\t\t}\t\t\t\n\t\treturn false;\n}\n\t\n\tprivate static Method getSetter(String propertyName, Object value, Class<?> aspect) {\n\t\tMethod setter = null;\n\t\ttry {\n\t\t\tif(value != null) {\n\t\t\t\tsetter = aspect.getMethod(propertyName, ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).className(), value.getClass());\n\t\t\t}else {\n\t\t\t\tfor (Method m : aspect.getMethods()) {\n\t\t\t\t\tif (m.getName().compareTo(propertyName) ==0 && m.getParameterCount() == 2) {\n\t\t\t\t\t\tsetter= m;\n\t\t\t\t\t\treturn setter;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tthrow new NoSuchMethodException();\n\t\t\t}\n\t\t\treturn setter;\n\t\t} catch (NoSuchMethodException | SecurityException | IllegalArgumentException e) {\n\t\t\t\n\t\t\t\tfor(Class<?> c : ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).getClass().getInterfaces()) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tif(value != null) {\n\t\t\t\t\t\t\tsetter = aspect.getMethod(propertyName, c, value.getClass());\n\t\t\t\t\t\t\treturn setter;\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (NoSuchMethodException | SecurityException | IllegalArgumentException e1) {\n\t\t\t\t\t}\n\t\t\t\t\tfor (Method m : aspect.getMethods()) {\n\t\t\t\t\t\tif (m.getName().compareTo(propertyName) ==0 && m.getParameterCount() == 2) {\n\t\t\t\t\t\t\tsetter= m;\n\t\t\t\t\t\t\treturn setter;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\tif (setter == null) {\n\t\t\t\t\tthrow new RuntimeException(\"no method found for \"+value.getClass().getName()+\"::set\"+propertyName);\n\t\t\t\t}\n\t\t\t}\n\t\treturn setter;\n\t}};";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbExtraImport = new StringBuilder();
        for (String aspectName : this.setAspectsWithRTDs) {
            String aspectizedClassName = this.mapAspectizedClass.get(aspectName);
            for (Field property : this.mapAspectFieldProperties.get((Object)aspectName)) {
                String fieldName = property.getName();
                String fieldTypeName = property.getType().getTypeName();
                sbContent.append("  public static " + fieldTypeName + " get" + fieldName + "(" + aspectizedClassName + " eObject) {\n" + "     " + fieldTypeName + " theProperty = (" + fieldTypeName + ")getAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + aspectName + "\", \"" + fieldName + "\");\n" + "\t\treturn theProperty;\n}\n");
                String savePropertyStrategy = "";
                Optional<SourceField> propertySourceField = this.mapAspectProperties.get((Object)aspectName).stream().filter(p -> p.getElementName().equals(fieldName)).findFirst();
                Containment.ContainmentStrategy propertyContainmentStragety = propertySourceField.isEmpty() ? Containment.ContainmentStrategy.CONTAINER : this.mapFieldContainmentStrategy.get(propertySourceField.get());
                switch (propertyContainmentStragety) {
                    case REFERENCE: {
                        savePropertyStrategy = "// Reference property\n";
                        break;
                    }
                    case MAP_KEYCONTAINMENT_VALUEREFERENCE: {
                        Activator.error("MAP_KEYCONTAINMENT_VALUEREFERENCE not implemented, probable issue with property " + fieldName, new Exception("MAP_KEYCONTAINMENT_VALUEREFERENCE not implemented, probable issue with property " + fieldName));
                        break;
                    }
                    case MAP_KEYREFERENCE_VALUECONTAINMENT: {
                        Activator.error("MAP_KEYREFERENCE_VALUECONTAINMENT not implemented, probable issue with property " + fieldName, new Exception("MAP_KEYREFERENCE_VALUECONTAINMENT not implemented, probable issue with property " + fieldName));
                        break;
                    }
                    default: {
                        savePropertyStrategy = "propertyValue = propertyValue == null ? null : (" + fieldTypeName + ")Copier.clone(propertyValue);\n";
                    }
                }
                sbContent.append("  public static " + fieldTypeName + " saveProperty_" + fieldName + "(" + aspectizedClassName + " eObject) {\n" + "\t\t" + fieldTypeName + " propertyValue = (" + fieldTypeName + ")getAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + aspectName + "\", \"" + fieldName + "\");\n" + "\t\t" + savePropertyStrategy + "\t\treturn propertyValue;\n}\n");
                sbContent.append("\tpublic static boolean set" + fieldName + "(" + aspectizedClassName + " eObject, " + fieldTypeName + " newValue) {\n" + "\t\treturn setAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + aspectName + "\", \"" + fieldName + "\", newValue);\n\t}\n");
                sbContent.append("\tpublic static boolean restoreProperty_" + fieldName + "(" + aspectizedClassName + " eObject, " + fieldTypeName + " newValue) {\n" + "\t\t" + fieldTypeName + " propertyValue = newValue;\n" + "\t\t" + savePropertyStrategy + "\t\treturn setAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + aspectName + "\", \"" + fieldName + "\", propertyValue);\n\t}\n");
            }
        }
        fileContent = fileContent.replaceAll(Pattern.quote("${allGettersAndSetters}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${extraImports}"), sbExtraImport.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "RTDAccessor" + ".java");
        MoccmlLanguageProjectBuilder.writeFile(file, fileContent);
        IFile AspectsFile = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "RTDAspects" + ".list");
        StringBuilder sbAspects = new StringBuilder();
        this.setAspectsWithRTDs.stream().forEachOrdered(s -> {
            StringBuilder stringBuilder2 = sbAspects.append(String.valueOf(s) + "\n");
        });
        MoccmlLanguageProjectBuilder.writeFile(AspectsFile, sbAspects.toString());
        manifestChanger.addExportPackage(packageName);
    }

    private static IType findAnyTypeInWorkspace(char[][] qualifications, char[][] typeNames) throws JavaModelException {
        class ResultException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IType fType;

            public ResultException(IType type) {
                this.fType = type;
            }
        }
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                throw new ResultException(match.getType());
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(qualifications, typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (ResultException e) {
            return e.fType;
        }
        return null;
    }

    protected void updateCodeExecutorClass(IProject project, String fullLanguageName, ManifestChanger manifestChanger) throws BundleException, IOException, CoreException {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = MoccmlLanguageProjectBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = MoccmlLanguageProjectBuilder.getPackageName(languageName);
        String folderName = MoccmlLanguageProjectBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, disable the generation in the BuildOptions of the project.xdsml */\npackage ${package.name};\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.CodeExecutorDispatcher;\npublic class ${language.name.toupperfirst}CodeExecutor extends CodeExecutorDispatcher ${implements.content} {\n\tpublic ${language.name.toupperfirst}CodeExecutor(){\n\t    ${constructor.content}\n\t}\n\tpublic String getDSAProjectName(){\n\t\t//TODO please implement\n\t\treturn \"\";\n\t}\n   ${additional.operations}\n}";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbImplementContent = new StringBuilder();
        StringBuilder sbAdditionalOperations = new StringBuilder();
        sbContent.append("// add Melange or K3 DSA specific executors\n");
        sbContent.append("\t\taddExecutor(new org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.impl.K3DSLCodeExecutor(this,\n");
        sbContent.append("\t\t\t\"" + fullLanguageName + "\"));\n");
        sbImplementContent.append("\n\t\timplements org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.api.IK3DSAExecutorClassLoader ");
        sbAdditionalOperations.append("@Override\n\tpublic Class<?> getClassForName(String className) throws ClassNotFoundException {\n\t\treturn Class.forName(className);\n\t}\n\t@Override\n\tpublic java.io.InputStream getResourceAsStream(String resourceName) {\n\t\t//this.getClass().getResourceAsStream(resourceName);\n\t\treturn Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);\n\t}");
        sbContent.append("\t\t// fall back executor : search classic java method\n");
        sbContent.append("\t\taddExecutor(new org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.JavaCodeExecutor());");
        fileContent = fileContent.replaceAll(Pattern.quote("${constructor.content}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${implements.content}"), sbImplementContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${additional.operations}"), sbAdditionalOperations.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "CodeExecutor" + ".java");
        MoccmlLanguageProjectBuilder.writeFile(file, fileContent);
        this.setPluginCodeExecutorValue(project, String.valueOf(packageName) + "." + languageToUpperFirst + "CodeExecutor");
        manifestChanger.addExportPackage(packageName);
    }

    protected void setPluginCodeExecutorValue(IProject project, String value) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocLanguageAdditionExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.moccml.xdsml.addition");
        helper.updateAttributeInExtensionPoint(gemocLanguageAdditionExtensionPoint, "MOCCML_XDSML_Addition", "codeExecutor_class", value);
        helper.saveDocument(pluginfile);
    }

    protected void setPluginLanguageNameAndFilePath(IProject project, IFile dslFile, String languageName) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocLangExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.xdsml");
        helper.updateXDSMLDefinitionInExtensionPoint(gemocLangExtensionPoint, languageName);
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocLangExtensionPoint, "xdsmlFilePath", dslFile.getFullPath().toString());
        Element moccmlAdditionExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.moccml.xdsml.addition");
        helper.updateAttributeInExtensionPoint(moccmlAdditionExtensionPoint, "MOCCML_XDSML_Addition", "name", languageName);
        helper.updateAttributeInExtensionPoint(moccmlAdditionExtensionPoint, "MOCCML_XDSML_Addition", "referencedXDSMLName", languageName);
        helper.saveDocument(pluginfile);
    }

    protected void updateDependenciesWithProject(ManifestChanger connection, String projectName) throws BundleException, IOException, CoreException {
        connection.addPluginDependency(projectName);
    }

    protected void updateMapAspectizedClass(URLClassLoader classLoader, String aspectClassName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        Class<?> aspectClass = classLoader.loadClass(aspectClassName);
        Annotation[] annotationArray = aspectClass.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if (annot.annotationType().getCanonicalName().equals("fr.inria.diverse.k3.al.annotationprocessor.Aspect")) {
                Method methodClassName = annot.getClass().getMethod("className", new Class[0]);
                Object o = methodClassName.invoke((Object)annot, new Object[0]);
                Method methodGetCanonicalName = o.getClass().getMethod("getCanonicalName", new Class[0]);
                String aspectizedClassName = (String)methodGetCanonicalName.invoke(o, new Object[0]);
                this.mapAspectizedClass.put(aspectClassName, aspectizedClassName);
            }
            ++n2;
        }
    }

    public String getAspectizedClassCanonicalName(URLClassLoader classLoader, String aspectClassName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        Class<?> aspectClass = classLoader.loadClass(aspectClassName);
        Annotation[] annotationArray = aspectClass.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if (annot.annotationType().getCanonicalName().equals("fr.inria.diverse.k3.al.annotationprocessor.Aspect")) {
                Method methodClassName = annot.getClass().getMethod("className", new Class[0]);
                Object o = methodClassName.invoke((Object)annot, new Object[0]);
                Method methodGetCanonicalName = o.getClass().getMethod("getCanonicalName", new Class[0]);
                String aspectizedClassName = (String)methodGetCanonicalName.invoke(o, new Object[0]);
                return aspectizedClassName;
            }
            ++n2;
        }
        return null;
    }

    protected void updateModelLoaderClass(IProject project, String languageName, String modelLoaderClass) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "modelLoader_class", modelLoaderClass != null ? modelLoaderClass : "org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.DefaultModelLoader");
        helper.saveDocument(pluginfile);
    }

    public static String getLanguageNameWithFirstUpper(String languageDefinitionName) {
        return String.valueOf(languageDefinitionName.substring(0, 1).toUpperCase()) + languageDefinitionName.substring(1);
    }

    public static String getPackageName(String languageDefinitionName) {
        return String.valueOf(languageDefinitionName.toLowerCase()) + ".xdsml.api.impl";
    }

    public static String getFolderName(String languageDefinitionName) {
        return MoccmlLanguageProjectBuilder.getPackageName(languageDefinitionName).replaceAll("\\.", "/");
    }

    public static void writeFile(IFile file, String fileContent) {
        try {
            IFileUtils.writeInFile((IFile)file, (String)fileContent, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    protected void updateSolverClass(IProject project, String languageName, String solverClassName) {
        String computedSolverClassName = "";
        computedSolverClassName = solverClassName == null || solverClassName.isEmpty() ? "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.moc.impl.CcslSolver" : solverClassName;
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element moccmlAdditionExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.moccml.xdsml.addition");
        helper.updateAttributeInExtensionPoint(moccmlAdditionExtensionPoint, "MOCCML_XDSML_Addition", "solver_class", computedSolverClassName);
        helper.saveDocument(pluginfile);
    }

    protected void updateQVTO(IProject project, String languageName, String eclFileLocationUri, String qvtoFileLocationUri) {
        String computedQVTOLocationURI = "";
        if (qvtoFileLocationUri == null || qvtoFileLocationUri.isEmpty()) {
            int endProjectIndex;
            if (eclFileLocationUri.startsWith("/")) {
                eclFileLocationUri = eclFileLocationUri.substring(1);
            }
            if ((endProjectIndex = eclFileLocationUri.indexOf("/")) != -1) {
                String eclProject = eclFileLocationUri.substring(0, endProjectIndex);
                IProject dseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(eclProject);
                IFolder qvtoFolder = dseProject.getFolder("qvto-gen/modeling");
                if (qvtoFolder != null) {
                    FileFinderVisitor fileFinder = new FileFinderVisitor("qvto");
                    try {
                        qvtoFolder.accept((IResourceVisitor)fileFinder);
                        IFile qvtoFile = fileFinder.getFile();
                        if (qvtoFile != null) {
                            computedQVTOLocationURI = qvtoFile.getFullPath().toString();
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        } else {
            computedQVTOLocationURI = qvtoFileLocationUri;
        }
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element moccmlAdditionExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.moccml.xdsml.addition");
        helper.updateAttributeInExtensionPoint(moccmlAdditionExtensionPoint, "MOCCML_XDSML_Addition", "toCCSLQVTOFilePath", computedQVTOLocationURI);
        helper.saveDocument(pluginfile);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new LanguageProjectResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new LanguageProjectDeltaVisitor());
    }

    class LanguageProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        LanguageProjectDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    MoccmlLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    MoccmlLanguageProjectBuilder.this.checkConsistency(resource);
                    break;
                }
                case 2: {
                    MoccmlLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    MoccmlLanguageProjectBuilder.this.checkConsistency(resource);
                    break;
                }
                case 4: {
                    MoccmlLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    MoccmlLanguageProjectBuilder.this.checkConsistency(resource);
                }
            }
            return true;
        }
    }

    class LanguageProjectResourceVisitor
    implements IResourceVisitor {
        LanguageProjectResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            MoccmlLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
            MoccmlLanguageProjectBuilder.this.checkConsistency(resource);
            return true;
        }
    }
}

