/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractTemplateCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.templates.ContextTypeRegistry;

public class AJTemplateCompletionProcessor
extends AbstractTemplateCompletionProposalComputer {
    private static final String ASPECTJ = "aspectj";
    private final TemplateEngine aspectJTemplateEngine;

    public AJTemplateCompletionProcessor() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        this.aspectJTemplateEngine = this.createTemplateEngine(templateContextRegistry);
    }

    private TemplateEngine createTemplateEngine(ContextTypeRegistry templateContextRegistry) {
        Object contextType = templateContextRegistry.getContextType(ASPECTJ);
        if (contextType == null) {
            contextType = new JavaContextType(){

                protected void initializeContext(JavaContext context) {
                    context.addCompatibleContextType(AJTemplateCompletionProcessor.ASPECTJ);
                }
            };
            contextType.setId(ASPECTJ);
            templateContextRegistry.addContextType(contextType);
        }
        return new TemplateEngine(contextType);
    }

    protected TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        if (!(unit instanceof AJCompilationUnit)) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        return this.aspectJTemplateEngine;
    }
}

