/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.proposals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.views.proposals.patterns.IAcceleoPatternProposal;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionTemplateProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.AcceleoPatternProposalsUtils;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.EClassHandler;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.ProposalsBrowserPatternsLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.ProposalsBrowserPatternsProvider;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.ProposalsBrowserTypesLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.ProposalsBrowserTypesProvider;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.compare.Splitter;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProposalsBrowser
extends ViewPart
implements IEditingDomainProvider {
    public static final String PROPOSALS_BROWSER_VIEW_ID = "org.eclipse.acceleo.ide.ui.views.proposals.ProposalsBrowser";
    private AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private CheckboxTreeViewer typesViewer;
    private CheckboxTreeViewer patternsViewer;
    private IPartListener partListener;
    private Map<EClass, List<EClass>> mapSubTypes = new HashMap<EClass, List<EClass>>();
    private Map<EClass, List<EClassHandler>> mapEClassHandlers = new HashMap<EClass, List<EClassHandler>>();
    private long beginningTime;

    public ProposalsBrowser() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void createPartControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.verticalIndent = 1;
        rootContainer.setLayoutData((Object)gridData);
        GridLayout rootContainerLayout = new GridLayout();
        rootContainer.setLayout((Layout)rootContainerLayout);
        Splitter composite = new Splitter(rootContainer, 512);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData(1808);
        gridData.verticalIndent = 1;
        composite.setLayoutData((Object)gridData);
        this.createPatternsViewer((Composite)composite);
        this.createTypesViewer((Composite)composite);
        if (this.getSite() != null && this.getSite().getPage() != null && this.partListener == null) {
            this.partListener = this.createPartListener();
            this.getSite().getPage().addPartListener(this.partListener);
        }
    }

    private IPartListener createPartListener() {
        return new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof AcceleoEditor) {
                    AcceleoEditor editor = (AcceleoEditor)part;
                    ProposalsBrowser.this.updateViewTypes(editor);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof AcceleoEditor) {
                    AcceleoEditor editor = (AcceleoEditor)part;
                    ProposalsBrowser.this.updateViewTypes(editor);
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        if (this.partListener != null && this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.partListener = null;
        }
    }

    public void setFocus() {
    }

    private void createTypesViewer(Composite parent) {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.typesViewer = new CheckboxTreeViewer(parent, 2048);
        this.typesViewer.getTree().setLayoutData((Object)data);
        this.typesViewer.getTree().setFont(parent.getFont());
        this.typesViewer.setContentProvider((IContentProvider)new ProposalsBrowserTypesProvider(this, (AdapterFactory)this.adapterFactory));
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new ProposalsBrowserTypesLabelProvider((AdapterFactory)this.adapterFactory));
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean active;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!this.active) {
                    this.active = true;
                    ProposalsBrowser.this.beginningTime = System.currentTimeMillis();
                    try {
                        if (event.getElement() instanceof EClassHandler) {
                            EClassHandler eClassHandler = (EClassHandler)event.getElement();
                            ProposalsBrowser.this.checkStateType(eClassHandler, event.getChecked());
                        }
                    }
                    finally {
                        this.active = false;
                        ProposalsBrowser.this.beginningTime = 0L;
                    }
                }
            }
        });
        IEditorPart part = this.getSite().getPage().getActiveEditor();
        if (part instanceof AcceleoEditor) {
            AcceleoEditor editor = (AcceleoEditor)part;
            this.updateViewTypes(editor);
        } else {
            this.typesViewer.setInput(null);
        }
    }

    private synchronized void checkStateType(EClassHandler eClassHandler, boolean state) {
        block4: {
            Object[] checkedElements = this.typesViewer.getCheckedElements();
            try {
                List<EClassHandler> eClassAllHandlers = this.mapEClassHandlers.get(eClassHandler.getEClass());
                if (eClassAllHandlers != null) {
                    for (EClassHandler eClassAllHandler : eClassAllHandlers) {
                        this.typesViewer.expandToLevel((Object)eClassAllHandler, 1);
                        this.typesViewer.setChecked((Object)eClassAllHandler, state);
                        this.checkStateSubTypes(eClassAllHandler, state);
                    }
                }
            }
            catch (CancellationException e) {
                this.typesViewer.setCheckedElements(checkedElements);
                if (!state) break block4;
                this.typesViewer.setChecked((Object)eClassHandler, !state);
            }
        }
    }

    private void checkStateSubTypes(EClassHandler eClassHandler, boolean state) {
        long longTimeOperation = 5000L;
        List<EClass> subTypes = this.mapSubTypes.get(eClassHandler.getEClass());
        if (subTypes == null || subTypes.size() == 0) {
            return;
        }
        this.typesViewer.expandToLevel((Object)eClassHandler, 1);
        for (EClass eSubType : subTypes) {
            List<EClassHandler> eSubTypeHandlers = this.mapEClassHandlers.get(eSubType);
            if (eSubTypeHandlers == null) continue;
            for (EClassHandler eSubTypeHandler : eSubTypeHandlers) {
                if (this.beginningTime != -1L && System.currentTimeMillis() - this.beginningTime > 5000L) {
                    if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AcceleoUIMessages.getString("ProposalsBrowser.LongTimeOperation"), (String)AcceleoUIMessages.getString("ProposalsBrowser.LongTimeOperationCancel"))) {
                        throw new CancellationException();
                    }
                    this.beginningTime = -1L;
                }
                this.typesViewer.setChecked((Object)eSubTypeHandler, state);
                this.checkStateSubTypes(eSubTypeHandler, state);
            }
        }
    }

    private synchronized void updateViewTypes(AcceleoEditor editor) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        Module cst = editor.getContent().getCST();
        if (cst != null) {
            for (TypedModel typedModel : cst.getInput()) {
                for (EPackage ePackage : typedModel.getTakesTypesFrom()) {
                    if (ePackages.contains(ePackage)) continue;
                    ePackages.add(ePackage);
                }
            }
        }
        this.mapSubTypes.clear();
        this.mapEClassHandlers.clear();
        this.computeSubTypes(this.mapSubTypes, ePackages);
        ArrayList<EClassHandler> input = new ArrayList<EClassHandler>();
        for (EClass eClass : this.mapSubTypes.keySet()) {
            if (eClass.getESuperTypes().size() != 0) continue;
            EClassHandler handler = new EClassHandler(eClass);
            input.add(handler);
            List<EClassHandler> handlers = this.mapEClassHandlers.get(eClass);
            if (handlers == null) {
                handlers = new ArrayList<EClassHandler>();
                this.mapEClassHandlers.put(eClass, handlers);
            }
            handlers.add(handler);
        }
        this.typesViewer.setInput(input);
    }

    protected EClassHandler[] createSubTypeHandlers(EClassHandler eClassHandler) {
        ArrayList<EClassHandler> result = new ArrayList<EClassHandler>();
        List<EClass> subTypes = this.mapSubTypes.get(eClassHandler.getEClass());
        if (subTypes != null) {
            for (EClass subType : subTypes) {
                EClassHandler handler = new EClassHandler(subType);
                result.add(handler);
                List<EClassHandler> handlers = this.mapEClassHandlers.get(subType);
                if (handlers == null) {
                    handlers = new ArrayList<EClassHandler>();
                    this.mapEClassHandlers.put(subType, handlers);
                }
                handlers.add(handler);
            }
        }
        return result.toArray(new EClassHandler[result.size()]);
    }

    protected boolean hasSubType(EClassHandler eClassHandler) {
        List<EClass> subTypes = this.mapSubTypes.get(eClassHandler.getEClass());
        return subTypes != null && subTypes.size() > 0;
    }

    private void computeSubTypes(Map<EClass, List<EClass>> subTypesMap, List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            for (EClassifier eChildClassifier : ePackage.getEClassifiers()) {
                if (!(eChildClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eChildClassifier;
                this.computeSubTypesOfAllSuperTypes(subTypesMap, eClass);
                if (subTypesMap.containsKey(eClass)) continue;
                subTypesMap.put(eClass, new ArrayList());
            }
            this.computeSubTypes(subTypesMap, (List<EPackage>)ePackage.getESubpackages());
        }
    }

    private void computeSubTypesOfAllSuperTypes(Map<EClass, List<EClass>> subTypesMap, EClass eClass) {
        for (EClass eSuperType : eClass.getESuperTypes()) {
            List<EClass> subTypes = subTypesMap.get(eSuperType);
            if (subTypes == null) {
                subTypes = new ArrayList<EClass>();
                subTypesMap.put(eSuperType, subTypes);
            }
            if (!subTypes.contains(eClass)) {
                subTypes.add(eClass);
            }
            this.computeSubTypesOfAllSuperTypes(subTypesMap, eSuperType);
        }
    }

    private void createPatternsViewer(Composite parent) {
        GridData data = new GridData(768);
        int heightHint = 50;
        data.heightHint = 50;
        this.patternsViewer = new CheckboxTreeViewer(parent, 2048);
        this.patternsViewer.getTree().setLayoutData((Object)data);
        this.patternsViewer.getTree().setFont(parent.getFont());
        this.patternsViewer.setContentProvider((IContentProvider)new ProposalsBrowserPatternsProvider((AdapterFactory)this.adapterFactory));
        this.patternsViewer.setLabelProvider((IBaseLabelProvider)new ProposalsBrowserPatternsLabelProvider((AdapterFactory)this.adapterFactory));
        this.patternsViewer.setInput(AcceleoPatternProposalsUtils.getPatternProposals());
    }

    public List<ICompletionProposal> getPatternCompletionProposals(IDocument document, String text, int offset, CSTNode cstNode) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Object[] patternCheckedElements = this.patternsViewer.getCheckedElements();
        int i = 0;
        while (i < patternCheckedElements.length) {
            Object patternCheckedElement = patternCheckedElements[i];
            if (patternCheckedElement instanceof IAcceleoPatternProposal && ((IAcceleoPatternProposal)patternCheckedElement).isEnabled(text, offset, (EObject)cstNode)) {
                String newTemplateProposal;
                IAcceleoPatternProposal pattern = (IAcceleoPatternProposal)patternCheckedElement;
                int index = offset;
                while (index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1))) {
                    --index;
                }
                if (index > 0 && (text.charAt(index - 1) == '[' || text.charAt(index - 1) == ']')) {
                    --index;
                }
                String start = text.substring(index, offset);
                StringBuffer tabBuffer = new StringBuffer();
                while (index > 0 && Character.isWhitespace(text.charAt(index - 1)) && text.charAt(index - 1) != '\n') {
                    tabBuffer.insert(0, text.charAt(index - 1));
                    --index;
                }
                String indentTab = tabBuffer.toString();
                ArrayList<EClass> types = new ArrayList<EClass>();
                Object[] typeCheckedElements = this.typesViewer.getCheckedElements();
                int j = 0;
                while (j < typeCheckedElements.length) {
                    EClass eClass;
                    Object typeCheckedElement = typeCheckedElements[j];
                    if (typeCheckedElement instanceof EClassHandler && !types.contains(eClass = ((EClassHandler)typeCheckedElement).getEClass())) {
                        types.add(eClass);
                    }
                    ++j;
                }
                if (types.size() == 0) {
                    types.add(EcorePackage.eINSTANCE.getInvalidType());
                }
                if ((newTemplateProposal = pattern.createTemplateProposal(types, indentTab)) != null && newTemplateProposal.length() > 0 && (newTemplateProposal.startsWith(start) || newTemplateProposal.startsWith("[") && newTemplateProposal.substring("[".length()).startsWith(start))) {
                    Template template = new Template(pattern.getDescription(), pattern.getDescription(), "__ACCELEO_block", newTemplateProposal, true);
                    TemplateContextType type = new TemplateContextType("__ACCELEO_block", "__ACCELEO_block");
                    DocumentTemplateContext context = new DocumentTemplateContext(type, document, offset - start.length(), start.length());
                    Region region = new Region(offset - start.length(), start.length());
                    AcceleoCompletionTemplateProposal proposal = new AcceleoCompletionTemplateProposal(template, (TemplateContext)context, (IRegion)region, AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/ProposalsBrowser.gif"));
                    proposals.add((ICompletionProposal)proposal);
                }
            }
            ++i;
        }
        return proposals;
    }
}

