/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.graph;

import fr.kairos.timesquare.ccsl.graph.IGraph;
import java.util.HashSet;
import java.util.Set;

public final class DigraphBuilder {
    private Set<String> nodes = new HashSet<String>();
    private Set<Arc> arcs = new HashSet<Arc>();
    private String param = null;

    void setParam(String param) {
        this.param = param;
    }

    public int getNodeNumber() {
        return this.nodes.size();
    }

    public int getEdgeNumber() {
        return this.arcs.size();
    }

    public Iterable<Arc> edges() {
        return this.arcs;
    }

    protected final void addArc(String tail, String head) {
        this.nodes.add(tail);
        this.nodes.add(head);
        this.arcs.add(new Arc(tail, head, this.param));
    }

    public final void buildGraph(IGraph graph) {
        for (Arc a : this.arcs) {
            graph.addNode(a.head);
            graph.addNode(a.tail);
        }
        for (Arc a : this.arcs) {
            a.build(graph);
        }
    }

    public static class Arc {
        private String head;
        private String tail;
        private String param;

        public String head() {
            return this.head;
        }

        public String tail() {
            return this.tail;
        }

        private Arc(String tail, String head, String param) {
            this.head = head;
            this.tail = tail;
            this.param = param;
        }

        protected void build(IGraph graph) {
            graph.addEdge(this.tail, this.head, this.param);
        }

        public int hashCode() {
            return this.head.hashCode() + this.tail.hashCode() + this.param.hashCode();
        }

        public boolean equals(Arc arc) {
            return this.param == arc.param && this.head == arc.head && this.tail == arc.tail;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Arc) {
                return this.equals((Arc)obj);
            }
            return super.equals(obj);
        }

        public String toString() {
            return String.valueOf(this.tail) + " -> " + this.head + " : " + this.param;
        }
    }
}

