/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.ui.labeling;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.metamodel.melange.Aspect;
import fr.inria.diverse.melange.metamodel.melange.Inheritance;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.metamodel.melange.Subtyping;
import fr.inria.diverse.melange.metamodel.melange.Transformation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;

public class MelangeLabelProvider
extends XbaseLabelProvider {
    @Inject
    public MelangeLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String image(ModelTypingSpace root) {
        return "melange.png";
    }

    public String image(Language l) {
        return "metamodel.png";
    }

    public String image(ModelType mt) {
        return "modeltype.png";
    }

    public String image(Transformation t) {
        return "transformation.png";
    }

    public String text(Aspect asp) {
        String _xifexpression = null;
        JvmType _type = asp.getAspectTypeRef().getType();
        if (_type instanceof JvmDeclaredType) {
            boolean _tripleNotEquals;
            StringConcatenation _builder = new StringConcatenation();
            String _simpleName = asp.getAspectTypeRef().getType().getSimpleName();
            _builder.append(_simpleName);
            EClass _aspectedClass = asp.getAspectedClass();
            boolean bl = _tripleNotEquals = _aspectedClass != null;
            if (_tripleNotEquals) {
                _builder.append(" @ ");
                String _name = asp.getAspectedClass().getName();
                _builder.append(_name);
            }
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = "Unbinded aspect";
        }
        return _xifexpression;
    }

    public String image(Aspect asp) {
        String _xifexpression = null;
        EClass _aspectedClass = asp.getAspectedClass();
        boolean _tripleNotEquals = _aspectedClass != null;
        _xifexpression = _tripleNotEquals ? "aspect.png" : "aspect2.png";
        return _xifexpression;
    }

    public String text(ModelType mt) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = mt.getName();
        _builder.append(_name);
        EList _subtypingRelations = mt.getSubtypingRelations();
        boolean _hasElements = false;
        for (Subtyping t : _subtypingRelations) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(" \u25c1 ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = t.getSuperType().getName();
            _builder.append(_name_1);
        }
        return _builder.toString();
    }

    public String text(Language l) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = l.getName();
        _builder.append(_name);
        Functions.Function1<Inheritance, Language> _function = new Functions.Function1<Inheritance, Language>(){

            public Language apply(Inheritance it) {
                return it.getTargetLanguage();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)Iterables.filter((Iterable)l.getOperators(), Inheritance.class), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Language t : _map) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("\u25c0");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = t.getName();
            _builder.append(_name_1);
        }
        EList _implements = l.getImplements();
        boolean _hasElements_1 = false;
        for (ModelType t_1 : _implements) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
                _builder.append(" \u25c1 ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_2 = t_1.getName();
            _builder.append(_name_2);
        }
        return _builder.toString();
    }

    public String text(EAttribute a) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = a.getName();
        _builder.append(_name);
        _builder.append(" : ");
        String _name_1 = a.getEType().getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    public String text(EReference r) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = r.getName();
        _builder.append(_name);
        _builder.append(" : ");
        String _name_1 = r.getEType().getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    public String text(EOperation o) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = o.getName();
        _builder.append(_name);
        _builder.append(" : ");
        String _name_1 = o.getEType().getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    public String text(EParameter p) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(" : ");
        String _name_1 = p.getEType().getName();
        _builder.append(_name_1);
        return _builder.toString();
    }
}

