/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.VcdZoom;
import fr.inria.aoste.timesquare.vcd.draw.FigureCanvasBase;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.listener.VcdFindButtonListener;
import fr.inria.aoste.timesquare.vcd.listener.VcdIntervalButtonListener;
import fr.inria.aoste.timesquare.vcd.listener.VcdOrderButtonListener;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.menu.VcdMenu;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.model.Function;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.ConstraintsFactory;
import fr.inria.aoste.timesquare.vcd.view.Iupdate;
import fr.inria.aoste.timesquare.vcd.view.MarkerFactory;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class VcdDiagram
extends ApplicationWindow
implements IVcdDiagram,
Iupdate {
    protected FigureCanvas _figureCanvas;
    protected Composite _composite;
    protected ConstraintsFactory _constraintsFactory;
    private MarkerFactory _markerFactory;
    protected boolean _ctrlKey = false;
    protected VcdFactory _vcdFactory = new VcdFactory(VcdColorPreferences.createColor());
    protected Mode _ghostMode = Mode.hide;
    protected ArrayList<MenuItem> _intervalItem;
    protected ListConnections _listConnections = new ListConnections(new ArrayList<Description>(), new ArrayList<ConstraintsConnection>(), new HashMap<ConstraintCommentCommand, ArrayList<ConstraintsConnection>>());
    protected double _markerZoomVaule = 1.0;
    private FigureCanvas _names;
    private Rectangle _oldrc = null;
    protected Shell _shell;
    protected boolean _simulation = false;
    protected TraceCollector _traceCollector;
    protected double _traceCollectorZoomValue = 1.0;
    protected String _title;
    protected ToolBar _toolbar;
    protected VCDDefinitions _vcdDef;
    protected double _zoomValue = 1.0;
    protected VcdColorPreferences _mca;
    protected VcdMenu _vcdMenu;
    FigureCanvasBase _fcb = null;
    private VcdZoom vcdzoom = null;

    @Override
    public VcdColorPreferences getColorPreferences() {
        return this._mca;
    }

    @Override
    public int getActivePageID() {
        return 0;
    }

    @Override
    public FigureCanvasBase getfcb() {
        return this._fcb;
    }

    @Override
    public void print() {
        Shell s = new Shell();
        PrintDialog printDialog = new PrintDialog(s, 0);
        printDialog.setText("Print");
        PrinterData printerData = printDialog.open();
        if (printerData != null) {
            Printer p = new Printer(printerData);
            PrintFigureOperation pfo = new PrintFigureOperation(p, this._figureCanvas.getContents());
            pfo.setPrintMode(2);
            pfo.run("test");
        }
    }

    public VcdDiagram(Shell parentShell, String title, VcdFactory factory) {
        super(parentShell);
        this.addToolBar(0);
        this._title = title;
        this._vcdFactory = factory;
        this._mca = factory.getMca();
        if (this._mca == null) {
            this._mca = VcdColorPreferences.createColor();
        }
        this._constraintsFactory = new ConstraintsFactory(this._listConnections, this);
        this._markerFactory = new MarkerFactory(this._listConnections, this);
        this._vcdMenu = new VcdMenu(this);
        this.vcdzoom = new VcdZoom(this._listConnections, this);
        parentShell.setImage(PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.vcd.antlr", (String)"icons/sampleInria.gif"));
    }

    @Override
    public void vcdMultiPageEditorRefresh() {
    }

    public boolean close() {
        this.getCanvas().setContents(null);
        this.getNames().setContents(null);
        this.getCanvas().dispose();
        this.getNames().dispose();
        ErrorConsole.println((String)"Closed");
        this._composite.dispose();
        this._listConnections.getListConstraints().clear();
        Runtime.getRuntime().runFinalization();
        return super.close();
    }

    public void create() {
        super.create();
        this._shell = this.getShell();
        this._shell.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, this.getCanvas().getSize().y + 140);
        this.createMenuBar();
    }

    public void createClockMenu(Menu menuBar) {
        MenuItem clockMenu = new MenuItem(menuBar, 64);
        clockMenu.setText("Clock");
        Menu menu = new Menu((Decorations)this.getShell(), 4);
        clockMenu.setMenu(menu);
        MenuItem subItem = new MenuItem(menu, 0);
        subItem.setText("Order");
        subItem.addSelectionListener((SelectionListener)new VcdOrderButtonListener(this._listConnections, this));
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(this._title);
        this._fcb = new FigureCanvasBase(this, this._mca);
        this._fcb.makeVcd(parent, false);
        this._composite = this._fcb.getComposite();
        this._names = this._fcb.getNames();
        this._figureCanvas = this._fcb.getClockCanvas();
        this._toolbar = new ToolBar(this._composite, 0);
        this._fcb.getComposite().getVerticalBar().setVisible(true);
        this._fcb.getComposite().getHorizontalBar().setVisible(true);
        this._fcb.scrollUpdate();
        this._fcb.layoutall();
        this._fcb.createListener(this._listConnections, this);
        this._fcb.addScrollListener();
        return this._composite;
    }

    @Override
    public FigureCanvas getScaleCanvas() {
        return this._fcb.getScaleCanvas();
    }

    public void createFileMenu(Menu menuBar) {
        MenuItem fileMenu = new MenuItem(menuBar, 64);
        fileMenu.setText("File");
        Menu menu = new Menu((Decorations)this.getShell(), 4);
        fileMenu.setMenu(menu);
        MenuItem exitItem = new MenuItem(menu, 0);
        exitItem.setText("Exit");
        class ExitListener
        implements SelectionListener {
            private VcdDiagram vdt;

            public ExitListener(VcdDiagram vdt) {
                this.vdt = vdt;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                this.vdt.close();
            }
        }
        exitItem.addSelectionListener((SelectionListener)new ExitListener(this));
    }

    public void createFindMenu(Menu menuBar) {
        MenuItem findMenu = new MenuItem(menuBar, 64);
        findMenu.setText("Find");
        Menu menu = new Menu((Decorations)this.getShell(), 4);
        findMenu.setMenu(menu);
        MenuItem subItem = new MenuItem(menu, 0);
        subItem.setText("Find");
        subItem.addSelectionListener((SelectionListener)new VcdFindButtonListener(this._listConnections, this));
    }

    public void createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.getShell(), 2);
        this.getShell().setMenuBar(menuBar);
        this.createFileMenu(menuBar);
        this.createClockMenu(menuBar);
        this.createOptionsMenu(menuBar);
        this.createFindMenu(menuBar);
    }

    public void createOptionsMenu(Menu menuBar) {
        MenuItem optionMenu = new MenuItem(menuBar, 64);
        optionMenu.setText("Options");
        Menu menu = new Menu((Decorations)this.getShell(), 4);
        optionMenu.setMenu(menu);
        MenuItem syncItem = new MenuItem(menu, 64);
        syncItem.setText("Synchronized");
        Menu syncMenu = new Menu(menu);
        syncItem.setMenu(syncMenu);
        syncItem.setEnabled(false);
        for (ConstraintCommentCommand cc : this._vcdDef.getConstraintCommentCommand()) {
            if (cc.getFunction() != Function._synchronizeswith) continue;
            syncItem.setEnabled(true);
            break;
        }
        if (syncItem.isEnabled()) {
            this._intervalItem = new ArrayList();
            int i = 0;
            ArrayList<String> clocksnames = new ArrayList<String>();
            Color color = this._mca.colorLightGraySync();
            for (ConstraintCommentCommand cc : this._vcdDef.getConstraintCommentCommand()) {
                if (i == 0) {
                    color = this._mca.colorLightGraySync();
                }
                if (i == 1) {
                    color = this._mca.colorLightBlueSync();
                }
                if (i == 2) {
                    color = this._mca.colorRedSync();
                }
                if (i == 3) {
                    i = 0;
                }
                if (cc.getFunction() != Function._synchronizeswith || clocksnames.contains(cc.getReferenceClocks().get(0))) continue;
                clocksnames.add(cc.getClock());
                this._listConnections.getListInterval().put(cc, new ArrayList());
                this._listConnections.firstClock1Put(cc, new ArrayList<IFigure>());
                this._listConnections.firstClock2Put(cc, new ArrayList<IFigure>());
                this._listConnections.lastClock1Put(cc, new ArrayList<IFigure>());
                this._listConnections.lastClock2Put(cc, new ArrayList<IFigure>());
                MenuItem item = new MenuItem(syncMenu, 32);
                item.setText(cc.toString());
                item.addSelectionListener((SelectionListener)new VcdIntervalButtonListener(this._listConnections, this, cc));
                this._listConnections.getMenuForComment().put(item, cc);
                this._listConnections.menuForColorPut(item, color);
                this._intervalItem.add(item);
                ++i;
            }
        }
    }

    @Override
    public FigureCanvas getCanvas() {
        return this._figureCanvas;
    }

    @Override
    public ConstraintsFactory getConstraintsFactory() {
        return this._constraintsFactory;
    }

    @Override
    public MarkerFactory getMarkerFactory() {
        return this._markerFactory;
    }

    @Override
    public VcdFactory getVcdFactory() {
        return this._vcdFactory;
    }

    @Override
    public final void setVcdFactory(VcdFactory factory) {
        this._vcdFactory = factory;
    }

    public ArrayList<MenuItem> getIntervalItem() {
        return this._intervalItem;
    }

    @Override
    public ListConnections getListConnections() {
        return this._listConnections;
    }

    @Override
    public double getMarkerZoom() {
        return this._markerZoomVaule;
    }

    @Override
    public Shell getMyShell() {
        return this._shell;
    }

    @Override
    public FigureCanvas getNames() {
        return this._names;
    }

    @Override
    public TraceCollector getTraceCollector() {
        return this._traceCollector;
    }

    @Override
    public double getTraceZoomValue() {
        return this._traceCollectorZoomValue;
    }

    @Override
    public ToolBar getToolbar() {
        return this._toolbar;
    }

    @Override
    public VCDDefinitions getVcdModel() {
        return this._vcdDef;
    }

    @Override
    public double getZoomValue() {
        return this._zoomValue;
    }

    @Override
    public boolean isCtrlKey() {
        return this._ctrlKey;
    }

    @Override
    public Mode isGhostMode() {
        return this._ghostMode;
    }

    @Override
    public boolean isSimulation() {
        return this._simulation;
    }

    @Override
    public void setCtrlKey(boolean ctrlKey) {
        this._ctrlKey = ctrlKey;
    }

    @Override
    public void setGhostMode(Mode ghostMode) {
        this._ghostMode = ghostMode;
    }

    @Override
    public void setMarkerZoom(double markerZoom) {
        this._markerZoomVaule = markerZoom;
    }

    @Override
    public void setSimulation(boolean simulation) {
        this._simulation = simulation;
    }

    @Override
    public void setTc(TraceCollector tc) {
        this._traceCollector = tc;
    }

    @Override
    public void setTcZoom(double tcZoom) {
        this._traceCollectorZoomValue = tcZoom;
    }

    @Override
    public void setVcdModel(VCDDefinitions vcd) {
        this._vcdDef = vcd;
    }

    @Override
    public void setZoomValue(double zoom) {
        this._zoomValue = zoom;
    }

    @Override
    public void setSimulationProgress(int etape) {
    }

    @Override
    public int update2(int n1, int n2, boolean b) {
        return this.update(n1, n2, b);
    }

    @Override
    public int update(int n1, int n2, boolean b) {
        ArrayList<IVar> listvar = new ArrayList<IVar>();
        listvar.addAll(this.getTraceCollector().getSelectedClocks());
        this.getTraceCollector().setZoom(this.getTraceZoomValue());
        this.getVcdModel().visit(this.getTraceCollector(), n1, n2, b);
        this.getCanvas().setContents((IFigure)this.getVcdFactory().getBackPanel());
        int x1 = -1;
        int x2 = -1;
        int y1 = -1;
        int y2 = -1;
        Rectangle rc = null;
        for (Object obj : this.getCanvas().getContents().getChildren()) {
            Panel panel = null;
            if (!(obj instanceof Panel)) continue;
            panel = (Panel)obj;
            Rectangle r = null;
            for (Object f : panel.getChildren()) {
                if (!(f instanceof IFigure)) continue;
                IFigure poly = (IFigure)f;
                r = poly.getBounds();
                rc = rc == null ? r : rc.getUnion(r);
            }
        }
        if (rc == null) {
            return 0;
        }
        Rectangle rc2 = null;
        rc2 = this._oldrc == null ? rc : new Rectangle(this._oldrc.getTopRight(), rc.getBottomRight());
        Rectangle rc3 = null;
        this._oldrc = rc;
        for (Object obj : this.getCanvas().getContents().getChildren()) {
            Panel panel = null;
            if (!(obj instanceof Panel)) continue;
            panel = (Panel)obj;
            Rectangle r = null;
            for (Object f : panel.getChildren()) {
                IFigure poly;
                if (!(f instanceof IFigure) || !(r = (poly = (IFigure)f).getBounds()).intersects(rc2)) continue;
                rc3 = rc3 == null ? r : rc3.getUnion(r);
            }
        }
        if (rc3 != null) {
            x1 = rc3.x;
            x2 = rc3.width;
            y1 = rc3.y;
            y2 = rc3.height;
            this.getCanvas().layout();
            for (MenuItem menuitem : this._listConnections.getMenuForComment().keySet()) {
                if (!menuitem.getSelection()) continue;
                ConstraintCommentCommand cc = this._listConnections.getMenuForComment().get(menuitem);
                Color color = this._listConnections.menuForColorGet(menuitem);
                this.getConstraintsFactory().drawSyncInterval(cc, color);
            }
            this.getCanvas().redraw(x1, y1, x2, y2, false);
        }
        return 0;
    }

    @Override
    public VcdZoom getVcdzoom() {
        return this.vcdzoom;
    }

    @Override
    public void setFocus() {
        if (this._shell != null && !this._shell.isDisposed()) {
            this._shell.setFocus();
        }
    }

    public int replace(int pos, String src, String newtext) {
        return 0;
    }

    @Override
    public boolean isContainGhost() {
        return true;
    }

    @Override
    public VcdMenu getVcdmenu() {
        return this._vcdMenu;
    }
}

