/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.command;

import fr.inria.aoste.timesquare.vcd.model.ISimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.keyword.SimulationKeyword;
import fr.inria.aoste.timesquare.vcd.model.visitor.ISimulationCollector;
import java.util.ArrayList;
import java.util.Iterator;

public class SimulationCommand
implements ISimulationCommand {
    private ArrayList<ValueChange> _changes = new ArrayList();
    private int _time;
    private SimulationKeyword _keyword;
    private VCDDefinitions _vcdModel;

    public SimulationCommand(int time, VCDDefinitions vcdModel) {
        this._time = time;
        this._keyword = null;
        this._vcdModel = vcdModel;
    }

    public SimulationCommand(SimulationKeyword keyword) {
        this._time = 0;
        this._keyword = keyword;
    }

    @Override
    public ISimulationCommand cloneCommand() {
        SimulationCommand sc = new SimulationCommand(this._time, this._vcdModel);
        sc._keyword = this._keyword;
        sc._changes = new ArrayList<ValueChange>(this._changes);
        return sc;
    }

    public void merge(SimulationCommand other) {
        this._keyword = other._keyword;
        this._changes = other._changes;
    }

    public void addValueChange(ValueChange vc) {
        this._changes.add(vc);
    }

    @Override
    public Iterator<ValueChange> iterator() {
        return this._changes.iterator();
    }

    @Override
    public void visit(ISimulationCollector visitor) {
        visitor.visitTimeLine(this._time);
        visitor.visitKeyword(this._keyword);
        for (ValueChange vc : this._changes) {
            visitor.visitValueChange(vc, this._time);
        }
        visitor.visitEnd(this._keyword);
    }

    @Override
    public int getTime() {
        return this._time;
    }

    public final void setTime(int time) {
        this._time = time;
    }

    public VCDDefinitions getVcdDefinitions() {
        return this._vcdModel;
    }

    public void setVcdDefinitions(VCDDefinitions vcdDef) {
        this._vcdModel = vcdDef;
    }
}

