/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.action;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.action.IActionTextVCD;
import fr.inria.aoste.timesquare.vcd.dialogs.FindDialog;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Panel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class FindAction
extends Action
implements IActionTextVCD {
    private final IVcdDiagram ivcddiagram;
    VcdColorPreferences mca;
    IAction actionText = null;

    public FindAction(IVcdDiagram ivcd) {
        this.ivcddiagram = ivcd;
        this.mca = ivcd.getColorPreferences();
    }

    @Override
    public IAction getActionText() {
        return this.actionText;
    }

    @Override
    public void setActionText(IAction ac) {
        this.actionText = ac;
    }

    public void run() {
        if (this.ivcddiagram.getActivePageID() == 0) {
            this.find();
        } else if (this.actionText != null) {
            this.actionText.run();
        }
    }

    private void find() {
        FindDialog inputDialog = new FindDialog(Display.getCurrent().getActiveShell(), "Find", "Clock name", "Instance", "", this.ivcddiagram);
        int reponse = inputDialog.open();
        if (reponse == 0) {
            Description d = new Description(inputDialog.getClock(), null, inputDialog.getInstance(), -1);
            for (Object obj : this.ivcddiagram.getCanvas().getContents().getChildren()) {
                Panel panel = null;
                if (!(obj instanceof Panel)) continue;
                panel = (Panel)obj;
                for (Object f : panel.getChildren()) {
                    IFigure poly = (IFigure)f;
                    Description descr = this.ivcddiagram.getVcdFactory().getFigureForDescription(poly);
                    if (descr == null || !d.equals(descr)) continue;
                    int x = poly.getBounds().x;
                    poly.setForegroundColor(this.mca.colorRedFind());
                    this.ivcddiagram.getCanvas().scrollToX(x - this.ivcddiagram.getCanvas().getSize().x / 2);
                    this.ivcddiagram.getScaleCanvas().scrollToX(x - this.ivcddiagram.getScaleCanvas().getSize().x / 2);
                    this.ivcddiagram.getMarkerFactory().hideMarkerFireable();
                    this.ivcddiagram.getListConnections().getListFind().add(poly);
                    this.ivcddiagram.setFocus();
                    return;
                }
            }
            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 33);
            messageBox.setText("Warning");
            messageBox.setMessage("Figure introuvable !");
            messageBox.open();
        }
        this.ivcddiagram.setFocus();
    }
}

