/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IComboZoom;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.action.ActionSync;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.view.EventPanel;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;

public class VcdZoom {
    private double size = 1.0;
    private int delta = 0;
    private IVcdDiagram vdt;
    private ListConnections list;
    private IComboZoom iczoom;
    private int counter;
    private int lastpoint = 0;
    private IFigure fig = null;
    private Dimension dim = null;
    private boolean lock = false;
    public ZoomList zoomlist = null;

    public VcdZoom(ListConnections listin, IVcdDiagram vdtin) {
        this.vdt = vdtin;
        this.list = listin;
        this.zoomlist = new ZoomList();
    }

    public int getDelta() {
        return this.delta;
    }

    public ListConnections getList() {
        return this.list;
    }

    public void setList(ListConnections list) {
        this.list = list;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double sizein) {
        if (sizein <= 0.0) {
            return;
        }
        this.size = sizein;
    }

    public void scale(int n) {
        if (n == 0) {
            return;
        }
        if (n > 0) {
            this.size *= (double)(1 << n);
            return;
        }
        this.size /= (double)(1 << -n);
    }

    public void scaleration(double f) {
        this.size *= f;
    }

    public final boolean isLock() {
        return this.lock;
    }

    public void applyScrollZoom() {
        try {
            this.fig = this.vdt.getCanvas().getContents();
            int n = this.zoomlist.selectValue(this.vdt.getTraceZoomValue() * 100.0);
            if (n == -1) {
                this.lock = false;
                return;
            }
            this.applyZoomMore();
            this.vdt.setMarkerZoom(this.vdt.getTraceZoomValue());
            this.vdt.getMarkerFactory().hideMarkerFireable();
            this.vdt.getCanvas().layout();
            this.vdt.getCanvas().update();
            this.vdt.getfcb().getComposite().layout();
            this.vdt.getfcb().getComposite().update();
            this.zoomlist.selectValue(this.vdt.getTraceZoomValue() * 100.0);
            if (this.iczoom != null) {
                this.iczoom.select(this.vdt.getTraceZoomValue() * 100.0);
            }
            this.vdt.getfcb().scrollUpdate();
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e, (String)" VCDZOOM ");
        }
        this.lock = false;
    }

    public void applyClickZoom() {
        try {
            int selX = this.vdt.getfcb().getClockCanvas().getHorizontalBar().getSelection();
            this.fig = this.vdt.getCanvas().getContents();
            double delta = 1.0;
            delta = this.vdt.getZoomValue();
            int n = this.zoomlist.selectValue(this.vdt.getTraceZoomValue() * 100.0);
            if (n == -1) {
                this.lock = false;
                return;
            }
            this.applyZoomMore();
            this.vdt.setMarkerZoom(this.vdt.getTraceZoomValue());
            this.vdt.getMarkerFactory().hideMarkerFireable();
            this.vdt.getCanvas().layout();
            this.vdt.getCanvas().update();
            this.vdt.getfcb().getComposite().layout();
            this.vdt.getfcb().getComposite().update();
            this.zoomlist.selectValue(this.vdt.getTraceZoomValue() * 100.0);
            if (this.iczoom != null) {
                this.iczoom.select(this.vdt.getTraceZoomValue() * 100.0);
            }
            this.vdt.getCanvas().scrollToX((int)((double)selX * delta));
            this.vdt.getScaleCanvas().scrollToX((int)((double)selX * delta));
            this.vdt.getfcb().scrollUpdate();
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e, (String)" VCDZOOM ");
        }
        this.lock = false;
    }

    public int computeposition(int t) {
        int r = (int)((double)t * this.vdt.getTraceZoomValue());
        return r;
    }

    private void applyZoomMore() {
        EventPanel ep;
        this.lastpoint = 0;
        for (Object obj : this.vdt.getCanvas().getContents().getChildren()) {
            ep = null;
            if (!(obj instanceof EventPanel)) continue;
            ep = (EventPanel)((Object)obj);
            ep.setValid(false);
            ep.getEventline().eventLineZoom(this.vdt.getTraceZoomValue() / 2.0);
            ep.markersZoom(this.vdt.getTraceZoomValue() / 2.0);
            ep.setValid(true);
            if (!ep.isDurationModel().booleanValue()) continue;
            for (Object f : ep.getChildren()) {
                if (!(f instanceof IFigure) || !(f instanceof ExtendFigure)) continue;
                ((ExtendFigure)f).mycompute();
            }
        }
        this.vdt.getVcdFactory().getTimeline().timelineZoom(this.vdt.getTraceZoomValue() / 2.0);
        this.lastpoint = this.vdt.getVcdFactory().getScalePanel().getPreferredSize().width;
        this.fig.setPreferredSize(new Dimension(this.lastpoint, this.fig.getPreferredSize().height));
        for (Object obj : this.vdt.getCanvas().getContents().getChildren()) {
            ep = null;
            if (!(obj instanceof EventPanel)) continue;
            ep = (EventPanel)((Object)obj);
            ep.setValid(false);
            ep.setPreferredSize(this.fig.getPreferredSize().width, ep.getPreferredSize().height);
            ep.setValid(true);
        }
        this.dim = this.vdt.getCanvas().getContents().getPreferredSize();
        this.vdt.getCanvas().getContents().setPreferredSize(new Dimension(this.vdt.getCanvas().getContents().getPreferredSize().width, this.dim.height));
        this.vdt.getVcdFactory().getScalePanel().repaint();
        this.vdt.getScaleCanvas().redraw();
        if (this.vdt.getVcdmenu().getSyncAction() != null) {
            for (ActionSync menuitem : this.vdt.getVcdmenu().getSyncAction()) {
                if (!menuitem.isChecked()) continue;
                ConstraintCommentCommand cc = menuitem.getCc();
                Color color = menuitem.getColor();
                this.vdt.getConstraintsFactory().drawSyncInterval(cc, color);
            }
        }
        this.vdt.getCanvas().redraw();
    }

    public void setZoomCounter(int comp) {
        this.counter = comp;
    }

    public int getZoomCounter() {
        return this.counter;
    }

    public final IComboZoom getIczoom() {
        return this.iczoom;
    }

    public final void setIczoom(IComboZoom iczoom) {
        this.iczoom = iczoom;
    }

    public final ZoomList getZoomlist() {
        return this.zoomlist;
    }

    public IVcdDiagram getVdt() {
        return this.vdt;
    }

    public void unSetVdt() {
        this.vdt = null;
    }

    public static class ZoomList {
        private int indice = 0;
        private ArrayList<Double> ardb = new ArrayList();

        private ZoomList() {
            this.ardb.add(6.25);
            this.ardb.add(12.5);
            this.ardb.add(25.0);
            this.ardb.add(50.0);
            this.ardb.add(100.0);
            this.ardb.add(200.0);
            this.ardb.add(400.0);
            this.indice = this.ardb.indexOf(100.0);
        }

        public final int getIndice() {
            return this.indice;
        }

        public int selectValue(Double d) {
            if (d < 0.001 || d > 5000.0) {
                return -1;
            }
            int n = 0;
            n = this.ardb.indexOf(d);
            if (n != -1) {
                this.indice = n;
                return n;
            }
            n = 0;
            for (double dl : this.ardb) {
                if (dl > d) break;
                ++n;
            }
            this.ardb.add(n, d);
            this.indice = n = this.ardb.indexOf(d);
            return n;
        }

        public String[] arrayOf() {
            ArrayList<String> lst = new ArrayList<String>();
            for (Double d : this.ardb) {
                lst.add(d.toString());
            }
            return lst.toArray(new String[0]);
        }
    }
}

